/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.logging;

import com.sun.enterprise.tools.upgrade.logging.LogService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogParser {
    private static final Logger logger = LogService.getLogger();
    private static final String SEP = "|";
    private static final Pattern errorPattern;
    private Pattern pattern = Pattern.compile("at .*[(].*:[0-9]*[)]");
    private static final String endToken = "|#]";
    private long startPoint = 0L;
    private File logFile;

    public LogParser(File logFile) throws FileNotFoundException, IOException {
        this.logFile = logFile;
        RandomAccessFile raf = new RandomAccessFile(logFile, "r");
        this.startPoint = raf.length();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Parsing file: %s", logFile.getAbsolutePath()));
            logger.fine("File length: " + this.startPoint);
        }
        raf.close();
    }

    public void setStartPoint(long start) {
        this.startPoint = start < 0L ? 0L : start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder parseLog() throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Parsing file: %s", this.logFile.getAbsolutePath()));
        }
        StringBuilder sBuf = new StringBuilder();
        RandomAccessFile reader = null;
        try {
            reader = new RandomAccessFile(this.logFile, "r");
            reader.seek(this.startPoint);
            String line = reader.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    if (line.endsWith(endToken)) {
                        if (this.matchErrorPattern(line)) {
                            sBuf.append(line).append("\n\n");
                        }
                    } else {
                        String tmpBuf = this.getFullMsg(line, reader);
                        Matcher matcher = this.pattern.matcher(tmpBuf);
                        if (matcher.find()) {
                            sBuf.append(tmpBuf).append("\n\n");
                        }
                    }
                }
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        return sBuf;
    }

    private boolean matchErrorPattern(String line) {
        Matcher matcher = errorPattern.matcher(line);
        if (matcher.find()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("Found error message: %s", line));
            }
            return true;
        }
        return false;
    }

    private String getFullMsg(String l, RandomAccessFile reader) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(l + "\n");
        String line = reader.readLine();
        while (line != null) {
            sbuf.append(line + "\n");
            if (line.endsWith(endToken)) break;
            line = reader.readLine();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("multi-line message: %s", sbuf.toString()));
        }
        return sbuf.toString();
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append(".*\\|(");
        sb.append(Level.SEVERE.getName());
        sb.append(SEP);
        sb.append(Level.WARNING.getName());
        sb.append(")\\|.*");
        errorPattern = Pattern.compile(sb.toString());
    }
}

