/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;

public class OutputParameterForCallableStatement
extends BindCallCustomParameter {
    protected boolean isCursor;
    protected int jdbcType;
    protected String typeName;
    protected boolean isTypeNameRequired;

    public OutputParameterForCallableStatement(DatabaseField field) {
        super(field);
    }

    public OutputParameterForCallableStatement(DatabaseField field, AbstractSession session) {
        this(field, session, false);
    }

    public OutputParameterForCallableStatement(DatabaseField field, AbstractSession session, boolean isCursor) {
        this(field);
        this.isCursor = isCursor;
        this.prepare(session);
    }

    public OutputParameterForCallableStatement(OutputParameterForCallableStatement outParameter) {
        super(outParameter.obj);
        this.isCursor = outParameter.isCursor;
        this.jdbcType = outParameter.jdbcType;
        this.typeName = outParameter.typeName;
        this.isTypeNameRequired = outParameter.isTypeNameRequired;
    }

    protected OutputParameterForCallableStatement() {
    }

    public void setIsCursor(boolean isCursor) {
        this.isCursor = isCursor;
    }

    public boolean isCursor() {
        return this.isCursor;
    }

    public boolean isTypeNameRequired() {
        return this.isTypeNameRequired;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public DatabaseField getOutputField() {
        return (DatabaseField)this.obj;
    }

    public void prepare(AbstractSession session) {
        org.eclipse.persistence.platform.database.DatabasePlatform dbplatform = session.getPlatform();
        if (this.isCursor()) {
            this.jdbcType = dbplatform.getCursorCode();
        } else {
            this.jdbcType = dbplatform.getJDBCType(this.getOutputField());
            if (this.obj instanceof ObjectRelationalDatabaseField) {
                this.isTypeNameRequired = true;
                this.typeName = ((ObjectRelationalDatabaseField)this.obj).getSqlTypeName();
            } else {
                this.isTypeNameRequired = dbplatform.requiresTypeNameToRegisterOutputParameter();
                if (this.isTypeNameRequired) {
                    this.typeName = dbplatform.getJdbcTypeName(this.jdbcType);
                }
            }
        }
    }

    public void set(DatabasePlatform platform, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
        if (this.isTypeNameRequired) {
            ((CallableStatement)statement).registerOutParameter(index, this.jdbcType, this.typeName);
        } else {
            ((CallableStatement)statement).registerOutParameter(index, this.jdbcType);
        }
    }

    public String toString() {
        return "=> " + this.getOutputField().getNameDelimited();
    }
}

