/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CachingType;
import javax.persistence.Embeddable;
import javax.persistence.GenerationType;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.InterfaceAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.GeneratedValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitDefaults;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitMetadata;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataProject {
    private static final String DEFAULT_AUTO_GENERATOR = "SEQ_GEN";
    private static final String DEFAULT_TABLE_GENERATOR = "SEQ_GEN_TABLE";
    private static final String DEFAULT_SEQUENCE_GENERATOR = "SEQ_GEN_SEQUENCE";
    private static final String DEFAULT_IDENTITY_GENERATOR = "SEQ_GEN_IDENTITY";
    private boolean m_weaveEager;
    private boolean m_weavingEnabled;
    private PersistenceUnitInfo m_persistenceUnitInfo;
    private AbstractSession m_session;
    private MetadataLogger m_logger;
    private XMLPersistenceUnitMetadata m_persistenceUnitMetadata;
    private HashMap<URL, XMLEntityMappings> m_entityMappings;
    private HashMap<String, MappedSuperclassAccessor> m_mappedSuperclasses;
    private HashMap<String, ClassAccessor> m_allAccessors;
    private HashMap<String, EntityAccessor> m_entityAccessors;
    private HashMap<String, EmbeddableAccessor> m_embeddableAccessors;
    private HashMap<String, InterfaceAccessor> m_interfaceAccessors;
    private HashMap<String, NamedQueryMetadata> m_queries;
    private HashMap<String, SQLResultSetMappingMetadata> m_sqlResultSetMappings;
    private HashMap<MetadataClass, GeneratedValueMetadata> m_generatedValues;
    private HashMap<String, TableGeneratorMetadata> m_tableGenerators;
    private HashMap<String, SequenceGeneratorMetadata> m_sequenceGenerators;
    private HashMap<String, AbstractConverterMetadata> m_converters;
    private HashSet<String> m_idClasses;
    private HashSet<EntityListenerMetadata> m_defaultListeners;
    private HashSet<ClassAccessor> m_accessorsWithCustomizer;
    private HashSet<ClassAccessor> m_accessorsWithDerivedIDs;
    private HashSet<DirectCollectionAccessor> m_directCollectionAccessors;
    private HashSet<MappingAccessor> m_embeddableMappingAccessors;
    private HashSet<RelationshipAccessor> m_relationshipAccessors;
    private HashSet<EmbeddableAccessor> m_rootEmbeddableAccessors;
    private HashMap<String, MappedSuperclassAccessor> m_metamodelMappedSuperclasses;

    public MetadataProject(PersistenceUnitInfo puInfo, AbstractSession session, boolean weavingEnabled, boolean weaveEager) {
        this.m_persistenceUnitInfo = puInfo;
        this.m_session = session;
        this.m_logger = new MetadataLogger(session);
        this.m_weavingEnabled = weavingEnabled;
        this.m_weaveEager = weaveEager;
        this.m_entityMappings = new LinkedHashMap<URL, XMLEntityMappings>();
        this.m_defaultListeners = new LinkedHashSet<EntityListenerMetadata>();
        this.m_queries = new HashMap();
        this.m_sqlResultSetMappings = new HashMap();
        this.m_mappedSuperclasses = new HashMap();
        this.m_allAccessors = new HashMap();
        this.m_entityAccessors = new HashMap();
        this.m_embeddableAccessors = new HashMap();
        this.m_interfaceAccessors = new HashMap();
        this.m_idClasses = new HashSet();
        this.m_accessorsWithCustomizer = new HashSet();
        this.m_relationshipAccessors = new HashSet();
        this.m_rootEmbeddableAccessors = new HashSet();
        this.m_embeddableMappingAccessors = new HashSet();
        this.m_directCollectionAccessors = new HashSet();
        this.m_generatedValues = new HashMap();
        this.m_tableGenerators = new HashMap();
        this.m_sequenceGenerators = new HashMap();
        this.m_converters = new HashMap();
        this.m_accessorsWithDerivedIDs = new HashSet();
        this.m_metamodelMappedSuperclasses = new HashMap();
    }

    protected void addAccessor(ClassAccessor accessor) {
        MetadataDescriptor descriptor = accessor.getDescriptor();
        if (this.m_persistenceUnitMetadata != null) {
            descriptor.setIgnoreAnnotations(this.m_persistenceUnitMetadata.isXMLMappingMetadataComplete());
            descriptor.setIgnoreDefaultMappings(this.m_persistenceUnitMetadata.excludeDefaultMappings());
            XMLPersistenceUnitDefaults persistenceUnitDefaults = this.m_persistenceUnitMetadata.getPersistenceUnitDefaults();
            if (persistenceUnitDefaults != null) {
                descriptor.setDefaultAccess(persistenceUnitDefaults.getAccess());
                descriptor.setDefaultSchema(persistenceUnitDefaults.getSchema());
                descriptor.setDefaultCatalog(persistenceUnitDefaults.getCatalog());
                descriptor.setIsCascadePersist(persistenceUnitDefaults.isCascadePersist());
            }
        }
        this.m_session.getProject().addDescriptor(descriptor.getClassDescriptor());
        this.m_allAccessors.put(accessor.getJavaClassName(), accessor);
    }

    public void addAccessorWithCustomizer(ClassAccessor accessor) {
        this.m_accessorsWithCustomizer.add(accessor);
    }

    public void addAccessorWithDerivedIDs(ClassAccessor accessor) {
        this.m_accessorsWithDerivedIDs.add(accessor);
    }

    public void addAlias(String alias, MetadataDescriptor descriptor) {
        ClassDescriptor existingDescriptor = this.m_session.getProject().getDescriptorForAlias(alias);
        if (existingDescriptor != null) {
            throw ValidationException.nonUniqueEntityName((String)existingDescriptor.getJavaClassName(), (String)descriptor.getJavaClassName(), (String)alias);
        }
        descriptor.setAlias(alias);
        this.m_session.getProject().addAlias(alias, descriptor.getClassDescriptor());
    }

    public void addConverter(AbstractConverterMetadata converter) {
        if (converter.shouldOverride(this.m_converters.get(converter.getName()))) {
            this.m_converters.put(converter.getName(), converter);
        }
    }

    public void addDefaultListener(EntityListenerMetadata defaultListener) {
        this.m_defaultListeners.add(defaultListener);
    }

    public void addDirectCollectionAccessor(MappingAccessor accessor) {
        this.m_directCollectionAccessors.add((DirectCollectionAccessor)accessor);
    }

    public void addEmbeddableAccessor(EmbeddableAccessor accessor) {
        this.addAccessor(accessor);
        accessor.getDescriptor().setIsEmbeddable();
        this.m_embeddableAccessors.put(accessor.getJavaClassName(), accessor);
    }

    public void addEmbeddableMappingAccessor(MappingAccessor accessor) {
        this.m_embeddableMappingAccessors.add(accessor);
    }

    public void addEntityAccessor(EntityAccessor accessor) {
        this.addAccessor(accessor);
        this.m_entityAccessors.put(accessor.getJavaClassName(), accessor);
    }

    public void addEntityMappings(XMLEntityMappings entityMappings) {
        this.m_entityMappings.put(entityMappings.getMappingFile(), entityMappings);
    }

    public void addGeneratedValue(GeneratedValueMetadata generatedvalue, MetadataClass entityClass) {
        this.m_generatedValues.put(entityClass, generatedvalue);
    }

    public void addIdClass(String idClassName) {
        this.m_idClasses.add(idClassName);
    }

    public void addInterfaceAccessor(InterfaceAccessor accessor) {
        this.m_interfaceAccessors.put(accessor.getJavaClassName(), accessor);
        this.m_session.getProject().addDescriptor(accessor.getDescriptor().getClassDescriptor());
    }

    public void addMappedSuperclass(String className, MappedSuperclassAccessor mappedSuperclass) {
        if (this.m_mappedSuperclasses.containsKey(className)) {
            this.m_mappedSuperclasses.get(className).merge(mappedSuperclass);
        } else {
            this.m_mappedSuperclasses.put(className, mappedSuperclass);
        }
    }

    public void addMetamodelMappedSuperclass(MetadataClass metadataClass, MappedSuperclassAccessor accessor) {
        String className = metadataClass.getName();
        if (null != className && !this.m_metamodelMappedSuperclasses.containsKey(className)) {
            accessor.getDescriptor().setClassAccessor(accessor);
            accessor.processAccessType();
            accessor.addAccessors();
            this.m_metamodelMappedSuperclasses.put(className, accessor);
            MetadataDescriptor metadataDescriptor = accessor.getDescriptor();
            RelationalDescriptor relationalDescriptor = (RelationalDescriptor)metadataDescriptor.getClassDescriptor();
            metadataDescriptor.setPrimaryTable(new DatabaseTable("__METAMODEL_RESERVED_IN_MEM_ONLY_TABLE_NAME"));
            if (!metadataDescriptor.hasIdAccessor()) {
                relationalDescriptor.addPrimaryKeyFieldName("__PK_METAMODEL_RESERVED_IN_MEM_ONLY_FIELD_NAME");
            }
            this.m_session.getProject().addMappedSuperclass((Object)metadataClass, relationalDescriptor);
        }
    }

    public void addQuery(NamedQueryMetadata query) {
        if (query.shouldOverride(this.m_queries.get(query.getName()))) {
            this.m_queries.put(query.getName(), query);
        }
    }

    public void addRelationshipAccessor(MappingAccessor accessor) {
        this.m_relationshipAccessors.add((RelationshipAccessor)accessor);
    }

    public void addRootEmbeddableAccessor(EmbeddableAccessor accessor) {
        this.m_rootEmbeddableAccessors.add(accessor);
    }

    public void addSequenceGenerator(SequenceGeneratorMetadata sequenceGenerator, String defaultCatalog, String defaultSchema) {
        String name = sequenceGenerator.getName();
        if (name.equals(DEFAULT_TABLE_GENERATOR)) {
            throw ValidationException.sequenceGeneratorUsingAReservedName((String)DEFAULT_TABLE_GENERATOR, (Object)sequenceGenerator.getLocation());
        }
        if (name.equals(DEFAULT_IDENTITY_GENERATOR)) {
            throw ValidationException.sequenceGeneratorUsingAReservedName((String)DEFAULT_IDENTITY_GENERATOR, (Object)sequenceGenerator.getLocation());
        }
        sequenceGenerator.setCatalog(MetadataHelper.getName(sequenceGenerator.getCatalog(), defaultCatalog, sequenceGenerator.getCatalogContext(), this.m_logger, sequenceGenerator.getLocation()));
        sequenceGenerator.setSchema(MetadataHelper.getName(sequenceGenerator.getSchema(), defaultSchema, sequenceGenerator.getSchemaContext(), this.m_logger, sequenceGenerator.getLocation()));
        TableGeneratorMetadata tableGenerator = this.m_tableGenerators.get(name);
        if (tableGenerator != null) {
            throw ValidationException.conflictingSequenceAndTableGeneratorsSpecified((String)name, (Object)sequenceGenerator.getLocation(), (Object)tableGenerator.getLocation());
        }
        for (TableGeneratorMetadata otherTableGenerator : this.m_tableGenerators.values()) {
            if (!otherTableGenerator.getPkColumnValue().equals(sequenceGenerator.getSequenceName()) || otherTableGenerator.getPkColumnValue().length() <= 0) continue;
            throw ValidationException.conflictingSequenceNameAndTablePkColumnValueSpecified((String)sequenceGenerator.getSequenceName(), (Object)sequenceGenerator.getLocation(), (Object)otherTableGenerator.getLocation());
        }
        if (sequenceGenerator.shouldOverride(this.m_sequenceGenerators.get(name))) {
            this.m_sequenceGenerators.put(sequenceGenerator.getName(), sequenceGenerator);
        }
    }

    public void addSQLResultSetMapping(SQLResultSetMappingMetadata sqlResultSetMapping) {
        if (sqlResultSetMapping.shouldOverride(this.m_sqlResultSetMappings.get(sqlResultSetMapping.getName()))) {
            this.m_sqlResultSetMappings.put(sqlResultSetMapping.getName(), sqlResultSetMapping);
        }
    }

    public void addTableGenerator(TableGeneratorMetadata tableGenerator, String defaultCatalog, String defaultSchema) {
        this.processTable(tableGenerator, "SEQUENCE", defaultCatalog, defaultSchema);
        String generatorName = tableGenerator.getGeneratorName();
        if (generatorName.equals(DEFAULT_SEQUENCE_GENERATOR)) {
            throw ValidationException.tableGeneratorUsingAReservedName((String)DEFAULT_SEQUENCE_GENERATOR, (Object)tableGenerator.getLocation());
        }
        if (generatorName.equals(DEFAULT_IDENTITY_GENERATOR)) {
            throw ValidationException.tableGeneratorUsingAReservedName((String)DEFAULT_IDENTITY_GENERATOR, (Object)tableGenerator.getLocation());
        }
        SequenceGeneratorMetadata otherSequenceGenerator = this.m_sequenceGenerators.get(generatorName);
        if (otherSequenceGenerator != null) {
            throw ValidationException.conflictingSequenceAndTableGeneratorsSpecified((String)generatorName, (Object)otherSequenceGenerator.getLocation(), (Object)tableGenerator.getLocation());
        }
        for (SequenceGeneratorMetadata sequenceGenerator : this.m_sequenceGenerators.values()) {
            if (!sequenceGenerator.getSequenceName().equals(tableGenerator.getPkColumnValue()) || sequenceGenerator.getSequenceName().length() <= 0) continue;
            throw ValidationException.conflictingSequenceNameAndTablePkColumnValueSpecified((String)sequenceGenerator.getSequenceName(), (Object)sequenceGenerator.getLocation(), (Object)tableGenerator.getLocation());
        }
        if (tableGenerator.shouldOverride(this.m_tableGenerators.get(generatorName))) {
            this.m_tableGenerators.put(generatorName, tableGenerator);
        }
    }

    public ClassAccessor getAccessor(String className) {
        return this.m_allAccessors.get(className);
    }

    public Set<ClassAccessor> getAccessorsWithCustomizer() {
        return this.m_accessorsWithCustomizer;
    }

    public Set<ClassAccessor> getAccessorsWithDerivedIDs() {
        return this.m_accessorsWithDerivedIDs;
    }

    public Collection<ClassAccessor> getAllAccessors() {
        return this.m_allAccessors.values();
    }

    protected String getCaching() {
        try {
            Method method = null;
            Object cachingType = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                method = (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(PersistenceUnitInfo.class, "getCaching", null));
                cachingType = AccessController.doPrivileged(new PrivilegedMethodInvoker(method, (Object)this.m_persistenceUnitInfo));
            } else {
                method = PrivilegedAccessHelper.getDeclaredMethod(PersistenceUnitInfo.class, (String)"getCaching", null);
                cachingType = PrivilegedAccessHelper.invokeMethod((Method)method, (Object)this.m_persistenceUnitInfo, null);
            }
            if (cachingType != null) {
                return ((CachingType)cachingType).name();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public AbstractConverterMetadata getConverter(String name) {
        return this.m_converters.get(name);
    }

    public Set<EntityListenerMetadata> getDefaultListeners() {
        return this.m_defaultListeners;
    }

    public EmbeddableAccessor getEmbeddableAccessor(MetadataClass cls) {
        return this.getEmbeddableAccessor(cls, false);
    }

    public EmbeddableAccessor getEmbeddableAccessor(MetadataClass cls, boolean checkIsIdClass) {
        EmbeddableAccessor accessor = this.m_embeddableAccessors.get(cls.getName());
        if (accessor == null && (cls.isAnnotationPresent(Embeddable.class) || checkIsIdClass && this.isIdClass(cls))) {
            accessor = new EmbeddableAccessor(cls.getAnnotation(Embeddable.class), cls, this);
            this.addEmbeddableAccessor(accessor);
        }
        return accessor;
    }

    public EmbeddableAccessor getEmbeddableAccessor(String className) {
        return this.m_embeddableAccessors.get(className);
    }

    public Collection<EmbeddableAccessor> getEmbeddableAccessors() {
        return this.m_embeddableAccessors.values();
    }

    public EntityAccessor getEntityAccessor(String className) {
        return this.m_entityAccessors.get(className);
    }

    public Collection<EntityAccessor> getEntityAccessors() {
        return this.m_entityAccessors.values();
    }

    public Collection<XMLEntityMappings> getEntityMappings() {
        return this.m_entityMappings.values();
    }

    public InterfaceAccessor getInterfaceAccessor(String className) {
        return this.m_interfaceAccessors.get(className);
    }

    public MetadataLogger getLogger() {
        return this.m_logger;
    }

    public MappedSuperclassAccessor getMappedSuperclass(MetadataClass cls) {
        return this.getMappedSuperclass(cls.getName());
    }

    public MappedSuperclassAccessor getMappedSuperclass(String className) {
        return this.m_mappedSuperclasses.get(className);
    }

    public Collection<MappedSuperclassAccessor> getMappedSuperclasses() {
        return this.m_mappedSuperclasses.values();
    }

    public Collection<MappedSuperclassAccessor> getMetamodelMappedSuperclasses() {
        return this.m_metamodelMappedSuperclasses.values();
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.m_persistenceUnitInfo;
    }

    public XMLPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.m_persistenceUnitMetadata;
    }

    public Set<EmbeddableAccessor> getRootEmbeddableAccessors() {
        return this.m_rootEmbeddableAccessors;
    }

    public List<StructConverterMetadata> getStructConverters() {
        ArrayList<StructConverterMetadata> structConverters = new ArrayList<StructConverterMetadata>();
        for (AbstractConverterMetadata converter : this.m_converters.values()) {
            if (!converter.isStructConverter()) continue;
            structConverters.add((StructConverterMetadata)converter);
        }
        return structConverters;
    }

    public Collection<String> getWeavableClassNames() {
        return Collections.unmodifiableCollection(this.m_allAccessors.keySet());
    }

    public boolean hasConverter(String name) {
        return this.m_converters.containsKey(name);
    }

    public boolean hasEmbeddable(MetadataClass cls) {
        return this.hasEmbeddable(cls.getName());
    }

    public boolean hasEmbeddable(String className) {
        return this.m_embeddableAccessors.containsKey(className);
    }

    public boolean hasEntity(MetadataClass cls) {
        return this.hasEntity(cls.getName());
    }

    public boolean hasEntity(String className) {
        return this.m_entityAccessors.containsKey(className);
    }

    public boolean hasInterface(MetadataClass cls) {
        return this.m_interfaceAccessors.containsKey(cls.getName());
    }

    public boolean hasMappedSuperclass(MetadataClass cls) {
        return this.hasMappedSuperclass(cls.getName());
    }

    public boolean hasMappedSuperclass(String className) {
        return this.m_mappedSuperclasses.containsKey(className);
    }

    public boolean isIdClass(MetadataClass idClass) {
        return this.m_idClasses.contains(idClass.getName());
    }

    public boolean isWeavingEnabled() {
        return this.m_weavingEnabled;
    }

    public boolean isCacheAll() {
        return this.getCaching() != null && this.getCaching().equals("ALL");
    }

    public boolean isCacheDisableSelective() {
        return this.getCaching() == null || this.getCaching().equals("DISABLE_SELECTIVE");
    }

    public boolean isCacheEnableSelective() {
        return this.getCaching() != null && this.getCaching().equals("ENABLE_SELECTIVE");
    }

    public boolean isCacheNone() {
        return this.getCaching() != null && this.getCaching().equals("NONE");
    }

    protected void processEmbeddableMappingAccessors() {
        for (MappingAccessor mappingAccessor : this.m_embeddableMappingAccessors) {
            if (mappingAccessor.isProcessed()) continue;
            mappingAccessor.process();
        }
    }

    protected void processAccessorsWithDerivedIDs() {
        HashSet<ClassAccessor> processed = new HashSet<ClassAccessor>();
        HashSet<ClassAccessor> processing = new HashSet<ClassAccessor>();
        for (ClassAccessor classAccessor : this.getAccessorsWithDerivedIDs()) {
            classAccessor.processDerivedIDs(processing, processed);
        }
    }

    public void processDirectCollectionAccessors() {
        for (DirectCollectionAccessor accessor : this.m_directCollectionAccessors) {
            accessor.process();
        }
    }

    protected void processInterfaceAccessors() {
        for (EntityAccessor accessor : this.getEntityAccessors()) {
            for (String interfaceClass : accessor.getJavaClass().getInterfaces()) {
                if (!this.m_interfaceAccessors.containsKey(interfaceClass)) continue;
                this.m_interfaceAccessors.get(interfaceClass).addEntityAccessor(accessor);
            }
        }
    }

    public void processQueries(ClassLoader loader) {
        for (SQLResultSetMappingMetadata sqlResultSetMapping : this.m_sqlResultSetMappings.values()) {
            sqlResultSetMapping.process(this.m_session, loader);
        }
        for (NamedQueryMetadata query : this.m_queries.values()) {
            query.process(this.m_session, loader);
        }
    }

    protected void processRelationshipAccessors() {
        for (RelationshipAccessor accessor : this.m_relationshipAccessors) {
            accessor.processRelationship();
        }
    }

    protected void processSequencingAccessors() {
        if (!this.m_generatedValues.isEmpty()) {
            Integer allocationSize;
            String seqName;
            DatabaseLogin login = this.m_session.getProject().getLogin();
            NativeSequence defaultAutoSequence = null;
            TableSequence defaultTableSequence = new TableSequence(DEFAULT_TABLE_GENERATOR);
            NativeSequence defaultObjectNativeSequence = new NativeSequence(DEFAULT_SEQUENCE_GENERATOR, false);
            NativeSequence defaultIdentityNativeSequence = new NativeSequence(DEFAULT_IDENTITY_GENERATOR, 1, true);
            Hashtable<String, Object> sequences = new Hashtable<String, Object>();
            for (SequenceGeneratorMetadata sequenceGenerator : this.m_sequenceGenerators.values()) {
                String sequenceGeneratorName = sequenceGenerator.getName();
                seqName = sequenceGenerator.getSequenceName() != null && !sequenceGenerator.getSequenceName().equals("") ? sequenceGenerator.getSequenceName() : sequenceGeneratorName;
                allocationSize = sequenceGenerator.getAllocationSize();
                if (allocationSize == null) {
                    allocationSize = new Integer(50);
                }
                NativeSequence sequence = new NativeSequence(seqName, allocationSize.intValue(), false);
                sequence.setQualifier(sequenceGenerator.getQualifier());
                sequences.put(sequenceGeneratorName, sequence);
                if (sequenceGeneratorName.equals(DEFAULT_AUTO_GENERATOR)) {
                    defaultAutoSequence = sequence;
                    continue;
                }
                if (!sequenceGeneratorName.equals(DEFAULT_SEQUENCE_GENERATOR)) continue;
                defaultObjectNativeSequence = sequence;
            }
            for (TableGeneratorMetadata tableGenerator : this.m_tableGenerators.values()) {
                Integer initialValue;
                String tableGeneratorName = tableGenerator.getGeneratorName();
                seqName = tableGenerator.getPkColumnValue() != null && !tableGenerator.getPkColumnValue().equals("") ? tableGenerator.getPkColumnValue() : tableGeneratorName;
                allocationSize = tableGenerator.getAllocationSize();
                if (allocationSize == null) {
                    allocationSize = new Integer(50);
                }
                if ((initialValue = tableGenerator.getInitialValue()) == null) {
                    initialValue = new Integer(0);
                }
                TableSequence sequence = new TableSequence(seqName, allocationSize.intValue(), initialValue.intValue());
                sequences.put(tableGeneratorName, sequence);
                sequence.setTable(tableGenerator.getDatabaseTable());
                if (tableGenerator.getPkColumnName() != null && !tableGenerator.getPkColumnName().equals("")) {
                    sequence.setNameFieldName(tableGenerator.getPkColumnName());
                }
                if (tableGenerator.getValueColumnName() != null && !tableGenerator.getValueColumnName().equals("")) {
                    sequence.setCounterFieldName(tableGenerator.getValueColumnName());
                }
                if (tableGeneratorName.equals(DEFAULT_AUTO_GENERATOR)) {
                    defaultAutoSequence = sequence;
                    continue;
                }
                if (!tableGeneratorName.equals(DEFAULT_TABLE_GENERATOR)) continue;
                defaultTableSequence = sequence;
            }
            boolean usesAuto = false;
            for (MetadataClass entityClass : this.m_generatedValues.keySet()) {
                ClassAccessor accessor = this.m_allAccessors.get(entityClass.getName());
                if (null != accessor) {
                    MetadataDescriptor descriptor = accessor.getDescriptor();
                    GeneratedValueMetadata generatedValue = this.m_generatedValues.get(entityClass);
                    String generatorName = generatedValue.getGenerator();
                    if (generatorName == null) {
                        generatorName = "";
                    }
                    Sequence sequence = null;
                    if (!generatorName.equals("")) {
                        sequence = (Sequence)sequences.get(generatorName);
                    }
                    if (sequence == null) {
                        String strategy = generatedValue.getStrategy();
                        if (strategy == null || strategy.equals(GenerationType.AUTO.name())) {
                            usesAuto = true;
                        } else if (strategy.equals(GenerationType.TABLE.name())) {
                            if (generatorName.equals("")) {
                                sequence = defaultTableSequence;
                            } else {
                                sequence = (Sequence)defaultTableSequence.clone();
                                sequence.setName(generatorName);
                            }
                        } else if (strategy.equals(GenerationType.SEQUENCE.name())) {
                            if (generatorName.equals("")) {
                                sequence = defaultObjectNativeSequence;
                            } else {
                                sequence = (Sequence)defaultObjectNativeSequence.clone();
                                sequence.setName(generatorName);
                            }
                        } else if (strategy.equals(GenerationType.IDENTITY.name())) {
                            if (generatorName.equals("")) {
                                sequence = defaultIdentityNativeSequence;
                            } else {
                                sequence = (Sequence)defaultIdentityNativeSequence.clone();
                                sequence.setName(generatorName);
                            }
                        }
                    }
                    if (sequence != null) {
                        descriptor.setSequenceNumberName(sequence.getName());
                        login.addSequence(sequence);
                    } else {
                        String seqName2 = generatorName.equals("") ? (defaultAutoSequence != null ? defaultAutoSequence.getName() : DEFAULT_AUTO_GENERATOR) : generatorName;
                        descriptor.setSequenceNumberName(seqName2);
                    }
                }
                if (!usesAuto || defaultAutoSequence == null) continue;
                login.setDefaultSequence(defaultAutoSequence);
            }
        }
    }

    public void processStage1() {
        for (EntityAccessor entity : this.getEntityAccessors()) {
            if (entity.isPreProcessed()) continue;
            entity.preProcess();
        }
        for (EmbeddableAccessor embeddable : this.getRootEmbeddableAccessors()) {
            if (embeddable.isPreProcessed()) continue;
            embeddable.preProcess();
        }
    }

    public void processStage2() {
        for (MappedSuperclassAccessor msAccessor : this.m_metamodelMappedSuperclasses.values()) {
            if (msAccessor.isProcessed()) continue;
            msAccessor.processMetamodelDescriptor();
        }
        for (EntityAccessor entity : this.getEntityAccessors()) {
            if (entity.isProcessed()) continue;
            entity.process();
        }
    }

    public void processStage3() {
        this.processAccessorsWithDerivedIDs();
        this.processDirectCollectionAccessors();
        this.processSequencingAccessors();
        this.processRelationshipAccessors();
        this.processInterfaceAccessors();
        this.processEmbeddableMappingAccessors();
    }

    public void processTable(TableMetadata table, String defaultName, String defaultCatalog, String defaultSchema) {
        String name = MetadataHelper.getName(table.getName(), defaultName, table.getNameContext(), this.m_logger, table.getLocation());
        String catalog = MetadataHelper.getName(table.getCatalog(), defaultCatalog, table.getCatalogContext(), this.m_logger, table.getLocation());
        String schema = MetadataHelper.getName(table.getSchema(), defaultSchema, table.getSchemaContext(), this.m_logger, table.getLocation());
        String tableName = new String(name);
        if (!schema.equals("")) {
            tableName = schema + "." + tableName;
        }
        if (!catalog.equals("")) {
            tableName = catalog + "." + tableName;
        }
        table.setFullyQualifiedTableName(tableName);
        table.setUseDelimiters(this.useDelimitedIdentifier());
        table.processUniqueConstraints();
    }

    public void setPersistenceUnitMetadata(XMLPersistenceUnitMetadata persistenceUnitMetadata) {
        if (this.m_persistenceUnitMetadata == null) {
            this.m_persistenceUnitMetadata = persistenceUnitMetadata;
        } else {
            this.m_persistenceUnitMetadata.merge(persistenceUnitMetadata);
        }
    }

    public void setWeavingEnabled(boolean weavingEnabled) {
        this.m_weavingEnabled = weavingEnabled;
    }

    public boolean useDelimitedIdentifier() {
        return this.m_persistenceUnitMetadata != null && this.m_persistenceUnitMetadata.isDelimitedIdentifiers();
    }

    public boolean weaveEager() {
        return this.m_weaveEager;
    }
}

