/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor.stats;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@ManagedObject
@Description(value="Network Connections Statistics")
public class ConnectionsStatsProvider {
    private final String name;
    private final CountStatisticImpl totalConnectionsCount = new CountStatisticImpl("TotalConnectionsCount", "count", "The total number of connections accepted");
    private final Map<Integer, Long> openConnectionsCount = new ConcurrentHashMap<Integer, Long>();

    public ConnectionsStatsProvider(String name) {
        this.name = name;
    }

    @ManagedAttribute(id="totalconnections")
    @Description(value="The total number of connections accepted")
    public CountStatistic getTotalConnectionsCount() {
        return this.totalConnectionsCount;
    }

    @ManagedAttribute(id="openconnections")
    @Description(value="The number of open connections")
    public CountStatistic getOpenConnectionsCount() {
        CountStatisticImpl stats = new CountStatisticImpl("OpenConnectionsCount", "count", "The number of open connections");
        stats.setCount(this.openConnectionsCount.size());
        return stats;
    }

    @ProbeListener(value="glassfish:kernel:connections:connectionAcceptedEvent")
    public void connectionAcceptedEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="connection") int connectionId) {
        if (this.name.equals(listenerName)) {
            this.totalConnectionsCount.increment();
            this.openConnectionsCount.put(connectionId, System.currentTimeMillis());
        }
    }

    @ProbeListener(value="glassfish:kernel:connections:connectionClosedEvent")
    public void connectionClosedEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="connection") int connectionId) {
        if (this.name.equals(listenerName)) {
            this.openConnectionsCount.remove(connectionId);
        }
    }
}

