/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.embedded;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.archive.ReadableArchiveAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScatteredArchive
extends ReadableArchiveAdapter {
    final String name;
    final File topDir;
    final File resources;
    final List<URL> urls = new ArrayList<URL>();
    final Map<String, File> metadata = new HashMap<String, File>();
    final Builder.type type;
    final String prefix;

    private ScatteredArchive(Builder builder, Builder.type type2) {
        this.name = builder.name;
        this.topDir = builder.topDir;
        this.resources = builder.resources;
        this.urls.addAll(builder.urls);
        this.metadata.putAll(builder.metadata);
        this.type = type2;
        this.prefix = type2 == Builder.type.war ? "WEB-INF/classes" : null;
    }

    public Iterable<URL> getClassPath() {
        return Collections.unmodifiableCollection(this.urls);
    }

    public File getResourcesDir() {
        return this.resources;
    }

    @Override
    public InputStream getEntry(String name) throws IOException {
        File f = this.getFile(name);
        if (f != null && f.exists()) {
            return new FileInputStream(f);
        }
        return null;
    }

    @Override
    public boolean exists(String name) throws IOException {
        if ("WEB-INF".equals(name) && this.type == Builder.type.war) {
            return true;
        }
        File f = this.getFile(name);
        return f != null && f.exists();
    }

    @Override
    public Enumeration<String> entries() {
        Vector<String> entries = new Vector<String>();
        File localResources = this.resources;
        for (URL url : this.urls) {
            try {
                File f;
                if (localResources.toURI().toURL().sameFile(url)) {
                    localResources = null;
                }
                if ((f = new File(url.toURI())).isFile()) {
                    JarFile jar = new JarFile(f);
                    Enumeration<JarEntry> jarEntries = jar.entries();
                    while (jarEntries.hasMoreElements()) {
                        entries.add(jarEntries.nextElement().getName());
                    }
                    continue;
                }
                this.getListOfFiles(f, this.prefix, entries);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (localResources != null) {
            this.getListOfFiles(localResources, null, entries);
        }
        return entries.elements();
    }

    private void getListOfFiles(File directory, String prefix, List<String> list) {
        for (File f : directory.listFiles()) {
            String name;
            String string = name = prefix == null ? f.getName() : prefix + "/" + f.getName();
            if (f.isDirectory()) {
                this.getListOfFiles(f, name, list);
                continue;
            }
            list.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        InputStream is = this.getEntry("META-INF/MANIFEST.MF");
        if (is != null) {
            Manifest manifest;
            try {
                manifest = new Manifest(is);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                is.close();
                throw throwable;
            }
            is.close();
            return manifest;
        }
        return new Manifest();
    }

    @Override
    public URI getURI() {
        if (this.topDir != null) {
            return this.topDir.toURI();
        }
        if (this.resources != null) {
            return this.resources.toURI();
        }
        try {
            return this.urls.get(0).toURI();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Enumeration<String> entries(String s) {
        throw new UnsupportedOperationException("entries(String)");
    }

    @Override
    public Collection<String> getDirectories() throws IOException {
        return new ArrayList<String>();
    }

    public String toString() {
        return super.toString() + " located at " + (this.topDir == null ? this.resources : this.topDir);
    }

    public File getFile(String name) {
        File f;
        String shortName;
        if (this.metadata.containsKey(name)) {
            return this.metadata.get(name);
        }
        String string = shortName = name.indexOf("/") != -1 ? name.substring(name.indexOf("/") + 1) : name;
        if (this.metadata.containsKey(shortName)) {
            return this.metadata.get(name);
        }
        if (this.resources != null && (f = new File(this.resources, name)).exists()) {
            return new File(this.resources, name);
        }
        if (name.startsWith(this.prefix)) {
            name = name.substring(this.prefix.length() + 1);
        }
        for (URL url : this.urls) {
            File f2 = null;
            try {
                f2 = new File(url.toURI());
                if (!(f2 = new File(f2, name)).exists()) continue;
                return f2;
            }
            catch (URISyntaxException e) {
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        final String name;
        File topDir = null;
        File resources = null;
        final List<URL> urls = new ArrayList<URL>();
        final Map<String, File> metadata = new HashMap<String, File>();

        public Builder(String name, File topDir) {
            this.name = name;
            this.topDir = topDir;
        }

        public Builder(String name, Collection<URL> urls) {
            this.name = name;
            for (URL u : urls) {
                this.urls.add(u);
            }
        }

        public Builder setResources(File resources) {
            this.resources = resources;
            return this;
        }

        public Builder addMetadata(String name, File metadata) {
            this.metadata.put(name, metadata);
            return this;
        }

        public Builder addMetadata(File metadata) {
            return this.addMetadata(metadata.getName(), metadata);
        }

        public Builder addClassPath(URL classpath) {
            this.urls.add(classpath);
            return this;
        }

        public ScatteredArchive buildJar() {
            return new ScatteredArchive(this, type.jar);
        }

        public ScatteredArchive buildWar() {
            return new ScatteredArchive(this, type.war);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum type {
            jar,
            war;

        }
    }
}

