/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.AnnotationProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.bean.ManagedBean;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.convert.FacesConverter;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationScanner
extends AnnotationProvider {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final Pattern FACES_CONFIG_PATTERN = Pattern.compile("^META-INF/[a-zA-Z_0-9-]+\\.faces-config.xml");
    private static final String WEB_INF_CLASSES = "/WEB-INF/classes/";
    private static final String WEB_INF_LIB = "/WEB-INF/lib/";
    private static final String FACES_CONFIG_XML = "META-INF/faces-config.xml";
    private static final String META_INF_PREFIX = "META-INF/";
    private static final String WILDCARD = "*";
    private static final Set<String> FACES_ANNOTATIONS;
    private static final Set<Class<? extends Annotation>> FACES_ANNOTATION_TYPE;
    private ClassFile classFileScanner = new ClassFile();
    private String[] webInfClassesPackages;
    private Map<String, String[]> webInfLibPackages;

    public AnnotationScanner(ServletContext sc) {
        super(sc);
        WebConfiguration webConfig = WebConfiguration.getInstance(sc);
        if (webConfig.isSet(WebConfiguration.WebContextInitParameter.AnnotationScanPackages)) {
            this.webInfLibPackages = new HashMap<String, String[]>(4);
            this.webInfClassesPackages = new String[0];
            String[] options = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.AnnotationScanPackages, "\\s+");
            ArrayList<String> packages = new ArrayList<String>(4);
            for (String option : options) {
                if (option.length() == 0) continue;
                if (option.startsWith("jar:")) {
                    String[] parts = Util.split(option, ":");
                    if (parts.length != 3) {
                        if (!LOGGER.isLoggable(Level.WARNING)) continue;
                        LOGGER.log(Level.WARNING, "jsf.annotation.scanner.configuration.invalid", new String[]{WebConfiguration.WebContextInitParameter.AnnotationScanPackages.getQualifiedName(), option});
                        continue;
                    }
                    if (WILDCARD.equals(parts[1]) && !this.webInfLibPackages.containsKey(WILDCARD)) {
                        this.webInfLibPackages.clear();
                        this.webInfLibPackages.put(WILDCARD, this.normalizeJarPackages(Util.split(parts[2], ",")));
                        continue;
                    }
                    if (WILDCARD.equals(parts[1]) && this.webInfLibPackages.containsKey(WILDCARD)) {
                        if (!LOGGER.isLoggable(Level.WARNING)) continue;
                        LOGGER.log(Level.WARNING, "jsf.annotation.scanner.configuration.duplicate.wildcard", new String[]{WebConfiguration.WebContextInitParameter.AnnotationScanPackages.getQualifiedName(), option});
                        continue;
                    }
                    if (this.webInfLibPackages.containsKey(WILDCARD)) continue;
                    this.webInfLibPackages.put(parts[1], this.normalizeJarPackages(Util.split(parts[2], ",")));
                    continue;
                }
                if (WILDCARD.equals(option) && !packages.contains(WILDCARD)) {
                    packages.clear();
                    packages.add(WILDCARD);
                    continue;
                }
                if (packages.contains(WILDCARD)) continue;
                packages.add(option);
            }
            this.webInfClassesPackages = packages.toArray(new String[packages.size()]);
        }
    }

    @Override
    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses() {
        HashSet<String> classList = new HashSet<String>();
        this.processWebInfClasses(this.sc, classList);
        this.processWebInfLib(this.sc, classList);
        Map<Class<Annotation>, Set<Class<?>>> annotatedClasses = null;
        if (classList.size() > 0) {
            annotatedClasses = new HashMap(6, 1.0f);
            for (String className : classList) {
                try {
                    Annotation[] annotations;
                    Class clazz = Util.loadClass(className, this);
                    for (Annotation annotation : annotations = clazz.getAnnotations()) {
                        Class<? extends Annotation> annoType = annotation.annotationType();
                        if (!FACES_ANNOTATION_TYPE.contains(annoType)) continue;
                        Set<Class<?>> classes = annotatedClasses.get(annoType);
                        if (classes == null) {
                            classes = new HashSet();
                            annotatedClasses.put(annoType, classes);
                        }
                        classes.add(clazz);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "Unable to load annotated class: {0}", className);
                }
            }
        }
        return annotatedClasses != null ? annotatedClasses : Collections.emptyMap();
    }

    private static boolean isAnnotation(String value) {
        return FACES_ANNOTATIONS.contains(value);
    }

    private void processWebInfLib(ServletContext sc, Set<String> classList) {
        Set entries = sc.getResourcePaths(WEB_INF_LIB);
        Map<String, JarFile> jars = this.getJars(sc, entries);
        if (jars != null) {
            for (Map.Entry<String, JarFile> entry : jars.entrySet()) {
                this.processJarEntries(entry.getValue(), this.webInfLibPackages != null ? this.webInfLibPackages.get(entry.getKey()) : null, classList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJarEntries(JarFile jarFile, String[] allowedPackages, Set<String> classList) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Scanning JAR {0} for annotations...", jarFile.getName());
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String cname;
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || (name = entry.getName()).startsWith("/META-INF") || !name.endsWith(".class") || !this.processClass(cname = this.convertToClassName(name), allowedPackages)) continue;
            ReadableByteChannel channel = null;
            try {
                channel = Channels.newChannel(jarFile.getInputStream(entry));
                if (!this.classFileScanner.containsAnnotation(channel)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[JAR] Found annotated Class: {0}", cname);
                }
                classList.add(cname);
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.log(Level.SEVERE, "Unexpected exception scanning JAR {0} for annotations", jarFile.getName());
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            finally {
                if (channel == null) continue;
                try {
                    channel.close();
                }
                catch (IOException ignored) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, ignored.toString(), ignored);
                }
            }
        }
    }

    private Map<String, JarFile> getJars(ServletContext sc, Set<String> entries) {
        HashMap<String, JarFile> jars = null;
        if (entries != null && !entries.isEmpty()) {
            block2: for (String entry : entries) {
                String jarName;
                if (!entry.endsWith(".jar") || !this.processJar(jarName = entry.substring(entry.lastIndexOf(47) + 1))) continue;
                try {
                    URL url = sc.getResource(entry);
                    StringBuilder sb = new StringBuilder(32);
                    sb.append("jar:").append(url.toString()).append("!/");
                    url = new URL(sb.toString());
                    JarFile jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                    if (jarFile.getJarEntry(FACES_CONFIG_XML) != null) {
                        if (jars == null) {
                            jars = new HashMap<String, JarFile>();
                        }
                        jars.put(jarName, jarFile);
                        continue;
                    }
                    Enumeration<JarEntry> e = jarFile.entries();
                    while (e.hasMoreElements()) {
                        Matcher m;
                        JarEntry ent = e.nextElement();
                        String entryName = ent.getName();
                        if (!entryName.startsWith(META_INF_PREFIX) || !(m = FACES_CONFIG_PATTERN.matcher(entryName)).matches()) continue;
                        if (jars == null) {
                            jars = new HashMap();
                        }
                        jars.put(entry, jarFile);
                        continue block2;
                    }
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
            }
        }
        return jars;
    }

    private void processWebInfClasses(ServletContext sc, Set<String> classList) {
        this.processWebInfClasses(sc, WEB_INF_CLASSES, classList);
    }

    private void processWebInfClasses(ServletContext sc, String path, Set<String> classList) {
        Set paths = sc.getResourcePaths(path);
        this.processWebInfClasses(sc, paths, classList);
    }

    private void processWebInfClasses(ServletContext sc, Set<String> paths, Set<String> classList) {
        if (paths != null && !paths.isEmpty()) {
            for (String pathElement : paths) {
                String cname;
                if (pathElement.endsWith("/")) {
                    this.processWebInfClasses(sc, pathElement, classList);
                    continue;
                }
                if (!pathElement.endsWith(".class") || !this.processClass(cname = this.convertToClassName(WEB_INF_CLASSES, pathElement), this.webInfClassesPackages) || !this.containsAnnotation(sc, pathElement)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[WEB-INF/classes] Found annotated Class: {0}", cname);
                }
                classList.add(cname);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsAnnotation(ServletContext sc, String pathElement) {
        Channel channel = null;
        try {
            URL url = sc.getResource(pathElement);
            channel = Channels.newChannel(url.openStream());
            boolean bl = this.classFileScanner.containsAnnotation((ReadableByteChannel)channel);
            return bl;
        }
        catch (MalformedURLException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        catch (IOException ioe) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
        finally {
            block19: {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException ignored) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block19;
                        LOGGER.log(Level.FINE, ignored.toString(), ignored);
                    }
                }
            }
        }
        return false;
    }

    private String[] normalizeJarPackages(String[] packages) {
        if (packages.length == 0) {
            return packages;
        }
        ArrayList<String> normalizedPackages = new ArrayList<String>(packages.length);
        for (String pkg : packages) {
            if (WILDCARD.equals(pkg)) {
                normalizedPackages.clear();
                normalizedPackages.add(WILDCARD);
                break;
            }
            normalizedPackages.add(pkg);
        }
        return normalizedPackages.toArray(new String[normalizedPackages.size()]);
    }

    private String convertToClassName(String pathEntry) {
        return this.convertToClassName(null, pathEntry);
    }

    private String convertToClassName(String prefix, String pathEntry) {
        String className = pathEntry;
        if (prefix != null) {
            className = className.substring(prefix.length());
        }
        className = className.substring(0, className.length() - 6);
        return className.replace('/', '.');
    }

    private boolean processJar(String entry) {
        return this.webInfLibPackages == null || this.webInfLibPackages.containsKey(entry) || this.webInfLibPackages.containsKey(WILDCARD);
    }

    private boolean processClass(String candidate, String[] packages) {
        if (packages == null) {
            return true;
        }
        for (String packageName : packages) {
            if (!candidate.startsWith(packageName) && !WILDCARD.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    static {
        HashSet annotations = new HashSet(8, 1.0f);
        Collections.addAll(annotations, "Ljavax/faces/component/FacesComponent;", "Ljavax/faces/convert/FacesConverter;", "Ljavax/faces/validator/FacesValidator;", "Ljavax/faces/render/FacesRenderer;", "Ljavax/faces/bean/ManagedBean;", "Ljavax/faces/event/NamedEvent;", "Ljavax/faces/component/behavior/FacesBehavior;", "Ljavax/faces/render/FacesBehaviorRenderer;");
        FACES_ANNOTATIONS = Collections.unmodifiableSet(annotations);
        HashSet annotationInstances = new HashSet(8, 1.0f);
        Collections.addAll(annotationInstances, FacesComponent.class, FacesConverter.class, FacesValidator.class, FacesRenderer.class, ManagedBean.class, NamedEvent.class, FacesBehavior.class, FacesBehaviorRenderer.class);
        FACES_ANNOTATION_TYPE = Collections.unmodifiableSet(annotationInstances);
    }

    private static class ConstantPoolInfo {
        private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
        public static final byte CLASS = 7;
        public static final int FIELDREF = 9;
        public static final int METHODREF = 10;
        public static final int STRING = 8;
        public static final int INTEGER = 3;
        public static final int FLOAT = 4;
        public static final int LONG = 5;
        public static final int DOUBLE = 6;
        public static final int INTERFACEMETHODREF = 11;
        public static final int NAMEANDTYPE = 12;
        public static final int ASCIZ = 1;
        public static final int UNICODE = 2;
        byte[] bytes = new byte[Short.MAX_VALUE];

        public boolean containsAnnotation(int constantPoolSize, ByteBuffer buffer, ReadableByteChannel in) throws IOException {
            block7: for (int i = 1; i < constantPoolSize; ++i) {
                if (!this.refill(buffer, in, 1)) {
                    return false;
                }
                byte type = buffer.get();
                switch (type) {
                    case 1: 
                    case 2: {
                        String stringValue;
                        if (!this.refill(buffer, in, 2)) {
                            return false;
                        }
                        short length = buffer.getShort();
                        if (length < 0 || length > Short.MAX_VALUE) {
                            return true;
                        }
                        if (!this.refill(buffer, in, length)) {
                            return false;
                        }
                        buffer.get(this.bytes, 0, length);
                        if (this.bytes[0] != 76 || this.bytes[1] != 106 || this.bytes[2] != 97 || !AnnotationScanner.isAnnotation(stringValue = type == 1 ? new String(this.bytes, 0, (int)length, "US-ASCII") : new String(this.bytes, 0, (int)length))) continue block7;
                        return true;
                    }
                    case 7: 
                    case 8: {
                        if (!this.refill(buffer, in, 2)) {
                            return false;
                        }
                        buffer.getShort();
                        continue block7;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: {
                        if (!this.refill(buffer, in, 4)) {
                            return false;
                        }
                        buffer.position(buffer.position() + 4);
                        continue block7;
                    }
                    case 5: 
                    case 6: {
                        if (!this.refill(buffer, in, 8)) {
                            return false;
                        }
                        buffer.position(buffer.position() + 8);
                        ++i;
                        continue block7;
                    }
                    case 12: {
                        if (!this.refill(buffer, in, 4)) {
                            return false;
                        }
                        buffer.getShort();
                        buffer.getShort();
                        continue block7;
                    }
                    default: {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue block7;
                        LOGGER.log(Level.SEVERE, "Unknow type constant pool {0} at position {1}", new Object[]{type, i});
                    }
                }
            }
            return false;
        }

        private boolean refill(ByteBuffer buffer, ReadableByteChannel in, int requestLen) throws IOException {
            int cap = buffer.capacity();
            if (buffer.position() + requestLen > cap) {
                buffer.compact();
                int read = in.read(buffer);
                if (read < 0) {
                    return false;
                }
                buffer.rewind();
            }
            return true;
        }
    }

    private static final class ClassFile {
        private static final int magic = -889275714;
        public static final int ACC_PUBLIC = 1;
        public static final int ACC_PRIVATE = 2;
        public static final int ACC_PROTECTED = 4;
        public static final int ACC_STATIC = 8;
        public static final int ACC_FINAL = 16;
        public static final int ACC_SYNCHRONIZED = 32;
        public static final int ACC_THREADSAFE = 64;
        public static final int ACC_TRANSIENT = 128;
        public static final int ACC_NATIVE = 256;
        public static final int ACC_INTERFACE = 512;
        public static final int ACC_ABSTRACT = 1024;
        public short majorVersion;
        public short minorVersion;
        public ConstantPoolInfo[] constantPool;
        public short accessFlags;
        public ConstantPoolInfo thisClass;
        public ConstantPoolInfo superClass;
        public ConstantPoolInfo[] interfaces;
        ByteBuffer header;
        ConstantPoolInfo constantPoolInfo = new ConstantPoolInfo();

        public ClassFile() {
            this.header = ByteBuffer.allocate(12000);
        }

        public void setConstantPoolInfo(ConstantPoolInfo poolInfo) {
            this.constantPoolInfo = poolInfo;
        }

        public boolean containsAnnotation(ReadableByteChannel in) throws IOException {
            this.header.clear();
            long read = in.read(this.header);
            if (read == -1L) {
                return false;
            }
            this.header.rewind();
            if (this.header.getInt() != -889275714) {
                return false;
            }
            this.minorVersion = this.header.getShort();
            this.majorVersion = this.header.getShort();
            short constantPoolSize = this.header.getShort();
            return this.constantPoolInfo.containsAnnotation(constantPoolSize, this.header, in);
        }
    }
}

