/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.TypeLiteral;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bootstrap.BeanDeployment;
import org.jboss.webbeans.bootstrap.api.Singleton;
import org.jboss.webbeans.bootstrap.api.SingletonProvider;
import org.jboss.webbeans.bootstrap.spi.BeanDeploymentArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentManager {
    private static Singleton<BeanManagerImpl> rootManager = SingletonProvider.instance().create(BeanManagerImpl.class);
    private static final Singleton<Map<Integer, BeanManagerImpl>> keyedManagers = SingletonProvider.instance().create(new IntegerMangerImplMap().getRawType());
    private static final Singleton<Map<BeanDeploymentArchive, BeanManagerImpl>> beanDeploymentArchives = SingletonProvider.instance().create(new BeanDeploymentArchiveManagerImplMap().getRawType());

    public static void clear() {
        keyedManagers.get().clear();
        rootManager.clear();
        keyedManagers.clear();
        beanDeploymentArchives.clear();
    }

    public static boolean isAvailable() {
        return rootManager.isSet() && beanDeploymentArchives.isSet();
    }

    public static BeanManagerImpl rootManager() {
        return rootManager.get();
    }

    public static void setRootManager(BeanManagerImpl managerImpl) {
        rootManager.set(managerImpl);
        if (!keyedManagers.isSet()) {
            keyedManagers.set(new ConcurrentHashMap());
        }
        keyedManagers.get().put(managerImpl.getId(), managerImpl);
    }

    public static void setBeanDeploymentArchives(Map<BeanDeploymentArchive, BeanDeployment> beanDeployments) {
        beanDeploymentArchives.set(new ConcurrentHashMap());
        for (Map.Entry<BeanDeploymentArchive, BeanDeployment> entry : beanDeployments.entrySet()) {
            beanDeploymentArchives.get().put(entry.getKey(), entry.getValue().getBeanManager());
            CurrentManager.add(entry.getValue().getBeanManager());
        }
    }

    public static Map<BeanDeploymentArchive, BeanManagerImpl> getBeanDeploymentArchives() {
        return beanDeploymentArchives.get();
    }

    public static BeanManagerImpl get(Integer key) {
        return keyedManagers.get().get(key);
    }

    public static Integer add(BeanManagerImpl manager) {
        Integer id = manager.getId();
        keyedManagers.get().put(id, manager);
        return id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanDeploymentArchiveManagerImplMap
    extends TypeLiteral<Map<BeanDeploymentArchive, BeanManagerImpl>> {
        private BeanDeploymentArchiveManagerImplMap() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerMangerImplMap
    extends TypeLiteral<Map<Integer, BeanManagerImpl>> {
        private IntegerMangerImplMap() {
        }
    }
}

