/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.AbstractReceiverBean;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.introspector.WBMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisposalMethodBean<T>
extends AbstractReceiverBean<T, Method> {
    protected MethodInjectionPoint<T, ?> disposalMethodInjectionPoint;
    private final String id;

    protected DisposalMethodBean(BeanManagerImpl manager, WBMethod<T, ?> disposalMethod, AbstractClassBean<?> declaringBean) {
        super(declaringBean, manager);
        this.disposalMethodInjectionPoint = MethodInjectionPoint.of(this, disposalMethod);
        this.id = DisposalMethodBean.createId("DisposalMethod-" + declaringBean.getName() + "-" + disposalMethod.getSignature().toString());
        this.initBindings();
        this.initType();
        this.initTypes();
        this.initStereotypes();
        this.initPolicy();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        this.addInjectionPoint(this.disposalMethodInjectionPoint);
        super.initialize(environment);
        this.checkDisposalMethod();
    }

    protected void initType() {
        this.type = this.disposalMethodInjectionPoint.getAnnotatedParameters(Disposes.class).get(0).getJavaClass();
    }

    @Override
    public WBMethod<T, ?> getAnnotatedItem() {
        return this.disposalMethodInjectionPoint;
    }

    public static <T> DisposalMethodBean<T> of(BeanManagerImpl manager, WBMethod<T, ?> disposalMethod, AbstractClassBean<?> declaringBean) {
        return new DisposalMethodBean<T>(manager, disposalMethod, declaringBean);
    }

    @Override
    protected void initBindings() {
        this.bindings = new HashSet();
        this.bindings.addAll(this.disposalMethodInjectionPoint.getWBParameters().get(0).getQualifiers());
        this.initDefaultBindings();
    }

    @Override
    protected void initTypes() {
        HashSet<Object> types = new HashSet<Object>();
        types = new HashSet();
        types.addAll(this.disposalMethodInjectionPoint.getAnnotatedParameters(Disposes.class).get(0).getTypeClosure());
        types.add(Object.class);
        this.types = types;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return null;
    }

    @Override
    public Set<Type> getTypes() {
        return this.types;
    }

    @Override
    public String toString() {
        return this.disposalMethodInjectionPoint.toString();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSerializable() {
        return false;
    }

    @Override
    public boolean isProxyable() {
        return true;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        return null;
    }

    public void invokeDisposeMethod(Object instance) {
        CreationalContext creationalContext = this.manager.createCreationalContext((Contextual)this);
        Object receiverInstance = this.getReceiver(creationalContext);
        if (receiverInstance == null) {
            this.disposalMethodInjectionPoint.invokeWithSpecialValue(null, Disposes.class, instance, this.manager, creationalContext, IllegalArgumentException.class);
        } else {
            this.disposalMethodInjectionPoint.invokeOnInstanceWithSpecialValue(receiverInstance, Disposes.class, instance, this.manager, creationalContext, IllegalArgumentException.class);
        }
        creationalContext.release();
    }

    private void checkDisposalMethod() {
        if (!this.disposalMethodInjectionPoint.getWBParameters().get(0).isAnnotationPresent(Disposes.class)) {
            throw new DefinitionException(this.disposalMethodInjectionPoint.toString() + " doesn't have @Dispose as first parameter");
        }
        if (this.disposalMethodInjectionPoint.getAnnotatedParameters(Disposes.class).size() > 1) {
            throw new DefinitionException(this.disposalMethodInjectionPoint.toString() + " has more than one @Dispose parameters");
        }
        if (this.disposalMethodInjectionPoint.getAnnotatedParameters(Observes.class).size() > 0) {
            throw new DefinitionException("@Observes is not allowed on disposal method, see " + this.disposalMethodInjectionPoint.toString());
        }
        if (this.disposalMethodInjectionPoint.getAnnotation(Inject.class) != null) {
            throw new DefinitionException("@Intitializer is not allowed on a disposal method, see " + this.disposalMethodInjectionPoint.toString());
        }
        if (this.disposalMethodInjectionPoint.getAnnotation(Produces.class) != null) {
            throw new DefinitionException("@Produces is not allowed on a disposal method, see " + this.disposalMethodInjectionPoint.toString());
        }
        if (this.getDeclaringBean() instanceof EnterpriseBean) {
            boolean methodDeclaredOnTypes = false;
            for (Type type : this.getDeclaringBean().getTypes()) {
                if (!(type instanceof Class)) continue;
                Class clazz = (Class)type;
                try {
                    clazz.getDeclaredMethod(this.disposalMethodInjectionPoint.getName(), this.disposalMethodInjectionPoint.getParameterTypesAsArray());
                    methodDeclaredOnTypes = true;
                }
                catch (NoSuchMethodException nsme) {}
            }
            if (!methodDeclaredOnTypes) {
                throw new DefinitionException("Producer method " + this.toString() + " must be declared on a business interface of " + this.getDeclaringBean());
            }
        }
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    protected String getDefaultName() {
        return this.disposalMethodInjectionPoint.getPropertyName();
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return null;
    }

    @Override
    protected void initScopeType() {
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }
}

