/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.conversation;

import java.io.Serializable;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.conversation.AbstractConversationManager;
import org.jboss.webbeans.conversation.ConversationConcurrentAccessTimeout;
import org.jboss.webbeans.conversation.ConversationIdName;
import org.jboss.webbeans.conversation.ConversationInactivityTimeout;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.ConversationBeanStore;

@SessionScoped
public class ServletConversationManager
extends AbstractConversationManager
implements Serializable {
    private static final long serialVersionUID = 1647848566880659085L;
    private static LogProvider log = Logging.getLogProvider(ServletConversationManager.class);
    private static final long CONVERSATION_TIMEOUT_IN_MS = 600000L;
    private static final long CONVERSATION_CONCURRENT_ACCESS_TIMEOUT_IN_MS = 1000L;
    private static final String CONVERSATION_ID_NAME = "cid";
    @Inject
    Instance<HttpSession> httpSession;

    public BeanStore getBeanStore(String cid) {
        return new ConversationBeanStore((HttpSession)this.httpSession.get(), cid);
    }

    @Produces
    @ConversationInactivityTimeout
    public static long getConversationTimeoutInMilliseconds() {
        log.trace("Produced conversation timeout 600000");
        return 600000L;
    }

    @Produces
    @ConversationConcurrentAccessTimeout
    public static long getConversationConcurrentAccessTimeout() {
        log.trace("Produced conversation concurrent access timeout 1000");
        return 1000L;
    }

    @Produces
    @ConversationIdName
    public static String getConversationIdName() {
        log.trace("Produced conversation id name cid");
        return CONVERSATION_ID_NAME;
    }
}

