/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.decorator.Decorates;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.injection.Exceptions;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.introspector.ForwardingWBConstructor;
import org.jboss.webbeans.introspector.WBConstructor;
import org.jboss.webbeans.introspector.WBParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorInjectionPoint<T>
extends ForwardingWBConstructor<T>
implements WBInjectionPoint<T, Constructor<T>> {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Bean<?> declaringBean;
    private final WBConstructor<T> constructor;
    private final boolean delegate;

    public static <T> ConstructorInjectionPoint<T> of(Bean<?> declaringBean, WBConstructor<T> constructor) {
        return new ConstructorInjectionPoint<T>(declaringBean, constructor);
    }

    protected ConstructorInjectionPoint(Bean<?> declaringBean, WBConstructor<T> constructor) {
        this.declaringBean = declaringBean;
        this.constructor = constructor;
        this.delegate = this.isAnnotationPresent(Decorates.class) && declaringBean instanceof Decorator;
    }

    @Override
    protected WBConstructor<T> delegate() {
        return this.constructor;
    }

    @Override
    public Bean<?> getBean() {
        return this.declaringBean;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.delegate().getQualifiers();
    }

    public T newInstance(BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        try {
            return this.delegate().newInstance(this.getParameterValues(this.getWBParameters(), null, null, manager, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (InstantiationException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e);
        }
        return null;
    }

    @Override
    public List<ParameterInjectionPoint<?, ?>> getWBParameters() {
        final List<WBParameter<?, ?>> delegate = super.getWBParameters();
        return new ForwardingParameterInjectionPointList(){

            @Override
            protected Bean<?> declaringBean() {
                return ConstructorInjectionPoint.this.declaringBean;
            }

            @Override
            protected List<? extends WBParameter<?, ?>> delegate() {
                return delegate;
            }
        };
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        throw new UnsupportedOperationException();
    }

    protected Object[] getParameterValues(List<ParameterInjectionPoint<?, ?>> parameters, Object specialVal, Class<? extends Annotation> specialParam, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        Object[] parameterValues = new Object[parameters.size()];
        Iterator<ParameterInjectionPoint<?, ?>> iterator = parameters.iterator();
        for (int i = 0; i < parameterValues.length; ++i) {
            ParameterInjectionPoint<?, ?> param = iterator.next();
            parameterValues[i] = specialParam != null && param.isAnnotationPresent(specialParam) ? specialVal : param.getValueToInject(manager, creationalContext);
        }
        return parameterValues;
    }

    @Override
    public Type getType() {
        return this.getJavaClass();
    }

    @Override
    public Member getMember() {
        return this.getJavaMember();
    }

    @Override
    public Annotated getAnnotated() {
        return this.delegate();
    }

    @Override
    public boolean isDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ForwardingParameterInjectionPointList
    extends AbstractList<ParameterInjectionPoint<?, ?>> {
        private ForwardingParameterInjectionPointList() {
        }

        protected abstract List<? extends WBParameter<?, ?>> delegate();

        protected abstract Bean<?> declaringBean();

        @Override
        public ParameterInjectionPoint<?, ?> get(int index) {
            return ParameterInjectionPoint.of(ConstructorInjectionPoint.this.declaringBean, this.delegate().get(index));
        }

        @Override
        public int size() {
            return this.delegate().size();
        }
    }
}

