/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.inject.Scope;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.cache.AnnotationModel;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.collections.Arrays2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeModel<T extends Annotation>
extends AnnotationModel<T> {
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = Arrays2.asSet(Scope.class, NormalScope.class);
    private static final Log log = Logging.getLog(ScopeModel.class);
    private final boolean normal;
    private final boolean passivating;

    public ScopeModel(Class<T> scope, ClassTransformer classTransformer) {
        super(scope, classTransformer);
        if (this.isValid()) {
            if (this.getAnnotatedAnnotation().isAnnotationPresent(NormalScope.class)) {
                this.passivating = this.getAnnotatedAnnotation().getAnnotation(NormalScope.class).passivating();
                this.normal = true;
            } else {
                this.normal = false;
                this.passivating = false;
            }
        } else {
            this.normal = false;
            this.passivating = false;
        }
    }

    @Override
    protected void initValid() {
        super.initValid();
        if (!this.getAnnotatedAnnotation().isAnnotationPresent(Target.class)) {
            this.valid = false;
            log.debug((Object)"#0 is missing @Target annotation.", this.getAnnotatedAnnotation());
        } else if (!Arrays2.unorderedEquals((Object[])this.getAnnotatedAnnotation().getAnnotation(Target.class).value(), new Object[]{ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})) {
            this.valid = false;
            log.debug((Object)"#0 is has incorrect @Target annotation. Should be @Target(METHOD, FIELD, TYPE).", this.getAnnotatedAnnotation());
        }
    }

    public boolean isNormal() {
        return this.normal;
    }

    public boolean isPassivating() {
        return this.passivating;
    }

    @Override
    protected Set<Class<? extends Annotation>> getMetaAnnotationTypes() {
        return META_ANNOTATIONS;
    }

    @Override
    public String toString() {
        String valid = this.isValid() ? "Valid " : "Invalid";
        String normal = this.isNormal() ? "normal " : "non-normal ";
        String passivating = this.isPassivating() ? "passivating " : "pon-passivating ";
        return valid + normal + passivating + " scope model for " + this.getRawType();
    }
}

