/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.NameValuePairNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.ServiceRefPortInfoRuntimeNode;
import com.sun.enterprise.deployment.node.runtime.web.WebBundleRuntimeNode;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceRefNode
extends DeploymentDescriptorNode {
    private ServiceReferenceDescriptor descriptor;

    public ServiceRefNode() {
        this.registerElementHandler(new XMLElement("port-info"), ServiceRefPortInfoRuntimeNode.class);
        this.registerElementHandler(new XMLElement("call-property"), NameValuePairNode.class, "addCallProperty");
    }

    public void addDescriptor(Object desc) {
        if (desc instanceof ServiceRefPortInfo) {
            ServiceRefPortInfo newPortInfo = (ServiceRefPortInfo)desc;
            ServiceReferenceDescriptor serviceRef = (ServiceReferenceDescriptor)this.getDescriptor();
            serviceRef.addRuntimePortInfo(newPortInfo);
        }
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("service-impl-class", "setServiceImplClassName");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        String name = element.getQName();
        if ("service-ref-name".equals(name)) {
            Object parentDesc = this.getParentNode().getDescriptor();
            if (parentDesc instanceof JndiNameEnvironment) {
                this.descriptor = ((JndiNameEnvironment)parentDesc).getServiceReferenceByName(value);
            } else if (parentDesc instanceof SunWebApp) {
                WebBundleDescriptor desc = ((WebBundleRuntimeNode)this.getParentNode()).getWebBundleDescriptor();
                this.descriptor = desc.getServiceReferenceByName(value);
            }
        } else if ("namespaceURI".equals(name)) {
            if (this.descriptor.getServiceNamespaceUri() == null) {
                this.descriptor.setServiceNamespaceUri(value);
            }
        } else if ("localpart".equals(name)) {
            if (this.descriptor.getServiceLocalPart() == null) {
                this.descriptor.setServiceLocalPart(value);
            }
        } else if ("wsdl-override".equals(name)) {
            try {
                URL url = new URL(value);
                this.descriptor.setWsdlOverride(url);
            }
            catch (MalformedURLException mue) {
                DOLUtils.getDefaultLogger().log(Level.INFO, "Warning : Invalid wsdl override url=" + value, mue);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, ServiceReferenceDescriptor serviceRef) {
        Node serviceRefNode = super.writeDescriptor(parent, nodeName, serviceRef);
        ServiceRefNode.appendTextChild(serviceRefNode, "service-ref-name", serviceRef.getName());
        ServiceRefPortInfoRuntimeNode portInfoRuntimeNode = new ServiceRefPortInfoRuntimeNode();
        Set portsInfo = serviceRef.getPortsInfo();
        for (ServiceRefPortInfo next : portsInfo) {
            portInfoRuntimeNode.writeDescriptor(serviceRefNode, "port-info", next);
        }
        NameValuePairNode nameValueNode = new NameValuePairNode();
        for (NameValuePairDescriptor next : serviceRef.getCallProperties()) {
            nameValueNode.writeDescriptor(serviceRefNode, "call-property", next);
        }
        if (serviceRef.hasWsdlOverride()) {
            URL wsdlOverride = serviceRef.getWsdlOverride();
            ServiceRefNode.appendTextChild(serviceRefNode, "wsdl-override", wsdlOverride.toExternalForm());
        }
        ServiceRefNode.appendTextChild(serviceRefNode, "service-impl-class", serviceRef.getServiceImplClassName());
        if (serviceRef.hasServiceName()) {
            Element serviceNameNode = ServiceRefNode.appendChild(serviceRefNode, "service-qname");
            QName serviceName = serviceRef.getServiceName();
            ServiceRefNode.appendTextChild((Node)serviceNameNode, "namespaceURI", serviceName.getNamespaceURI());
            ServiceRefNode.appendTextChild((Node)serviceNameNode, "localpart", serviceName.getLocalPart());
        }
        return serviceRefNode;
    }

    public static void writeServiceReferences(Node parent, JndiNameEnvironment descriptor) {
        Iterator serviceRefs = descriptor.getServiceReferenceDescriptors().iterator();
        if (serviceRefs.hasNext()) {
            ServiceRefNode serviceRefNode = new ServiceRefNode();
            while (serviceRefs.hasNext()) {
                ServiceReferenceDescriptor next = (ServiceReferenceDescriptor)serviceRefs.next();
                if (!next.hasServiceImplClassName() && next.getPortsInfo().isEmpty() && next.getCallProperties().isEmpty() && !next.hasWsdlOverride()) continue;
                serviceRefNode.writeDescriptor(parent, "service-ref", next);
            }
        }
    }
}

