/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolChainInstruction;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.config.GrizzlyEmbeddedHttp;
import com.sun.grizzly.config.GrizzlyServiceListener;
import com.sun.grizzly.config.SSLConfigHolder;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.filter.SSLReadFilter;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.ssl.SSLAsyncProcessorTask;
import com.sun.grizzly.ssl.SSLAsyncProtocolFilter;
import com.sun.grizzly.ssl.SSLDefaultProtocolFilter;
import com.sun.grizzly.ssl.SSLProcessorTask;
import com.sun.grizzly.ssl.SSLSelectorThreadHandler;
import java.io.IOException;
import java.util.logging.Level;
import org.jvnet.hk2.component.Habitat;

public class GrizzlyEmbeddedHttps
extends GrizzlyEmbeddedHttp {
    private ProtocolFilter lazyInitializationFilter;
    private final SSLConfigHolder sslConfigHolder = new SSLConfigHolder();

    public GrizzlyEmbeddedHttps(GrizzlyServiceListener grizzlyServiceListener) {
        super(grizzlyServiceListener);
    }

    protected ProtocolChainInstanceHandler configureProtocol(NetworkListener networkListener, Protocol protocol, Habitat habitat, boolean mayEnableComet) {
        if (protocol.getHttp() != null && GrizzlyEmbeddedHttps.toBoolean(protocol.getSecurityEnabled())) {
            Ssl ssl = protocol.getSsl();
            if (ssl == null || Boolean.parseBoolean(ssl.getAllowLazyInit())) {
                logger.log(Level.INFO, "Perform lazy SSL initialization for the listener '" + networkListener.getName() + "'");
                this.lazyInitializationFilter = new LazySSLInitializationFilter(protocol.getSsl());
            } else if (SSLConfigHolder.configureSSL(protocol.getSsl(), this.sslConfigHolder)) {
                this.setHttpSecured(true);
            }
        }
        return super.configureProtocol(networkListener, protocol, habitat, mayEnableComet);
    }

    protected TCPSelectorHandler createSelectorHandler() {
        return new SSLSelectorThreadHandler(this);
    }

    protected ProtocolFilter createHttpParserFilter() {
        if (this.asyncExecution) {
            return new SSLAsyncProtocolFilter(this.algorithmClass, this.port, this.sslConfigHolder.getSSLImplementation());
        }
        return new SSLDefaultProtocolFilter(this.algorithmClass, this.port, this.sslConfigHolder.getSSLImplementation());
    }

    protected void configureFilters(ProtocolChain protocolChain) {
        if (this.lazyInitializationFilter != null) {
            protocolChain.addFilter(this.lazyInitializationFilter);
        } else {
            this.doConfigureFilters(protocolChain);
        }
    }

    private void doConfigureFilters(ProtocolChain protocolChain) {
        if (this.portUnificationFilter != null) {
            this.portUnificationFilter.setContinuousExecution(false);
            protocolChain.addFilter((ProtocolFilter)this.portUnificationFilter);
        } else {
            protocolChain.addFilter(this.createReadFilter());
        }
        protocolChain.addFilter(this.createHttpParserFilter());
    }

    protected ProtocolFilter createReadFilter() {
        SSLReadFilter readFilter = new SSLReadFilter();
        readFilter.setSSLContext(this.sslConfigHolder.getSSLContext());
        readFilter.setClientMode(this.sslConfigHolder.isClientMode());
        readFilter.setEnabledCipherSuites(this.sslConfigHolder.getEnabledCipherSuites());
        readFilter.setEnabledProtocols(this.sslConfigHolder.getEnabledProtocols());
        readFilter.setNeedClientAuth(this.sslConfigHolder.isNeedClientAuth());
        readFilter.setWantClientAuth(this.sslConfigHolder.isWantClientAuth());
        return readFilter;
    }

    protected ProcessorTask newProcessorTask(boolean initialize) {
        SSLProcessorTask t = this.asyncExecution ? new SSLAsyncProcessorTask(initialize, this.getBufferResponse()) : new SSLProcessorTask(initialize, this.getBufferResponse());
        this.configureProcessorTask(t);
        return t;
    }

    public class LazySSLInitializationFilter
    implements ProtocolFilter {
        private final Ssl ssl;

        public LazySSLInitializationFilter(Ssl ssl) {
            this.ssl = ssl;
        }

        public boolean execute(Context ctx) throws IOException {
            ProtocolChain chain = ctx.getProtocolChain();
            SSLConfigHolder.configureSSL(this.ssl, GrizzlyEmbeddedHttps.this.sslConfigHolder);
            GrizzlyEmbeddedHttps.this.doConfigureFilters(chain);
            return true;
        }

        public boolean postExecute(Context ctx) throws IOException {
            ProtocolChain chain = ctx.getProtocolChain();
            chain.removeFilter(this);
            ctx.setAttribute("ChainPostInstruction", (Object)ProtocolChainInstruction.REINVOKE);
            return true;
        }
    }
}

