/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.monitoring.stats.EjbMethodStatsProvider;
import com.sun.ejb.monitoring.stats.EjbMonitoringUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="ejb-application-mon", group="monitoring", isSingleton=false)
@ManagedObject
@Description(value="Ejb Application Statistics")
public class EjbMonitoringStatsProvider {
    private Map<Method, EjbMethodStatsProvider> methodMonitorMap = new HashMap<Method, EjbMethodStatsProvider>();
    private String appName = null;
    private String moduleName = null;
    private String beanName = null;
    private boolean registered = false;
    private CountStatisticImpl createStat = new CountStatisticImpl("CreateCount", "count", "Number of times EJB create method is called");
    private CountStatisticImpl removeStat = new CountStatisticImpl("RemoveCount", "count", "Number of times EJB remove method is called");
    private static final Logger _logger = EjbContainerUtilImpl.getInstance().getLogger();

    public EjbMonitoringStatsProvider(String appName, String moduleName, String beanName, Method[] methods) {
        this.appName = appName;
        this.moduleName = moduleName;
        this.beanName = beanName;
        for (Method m : methods) {
            EjbMethodStatsProvider monitor = new EjbMethodStatsProvider(m);
            this.methodMonitorMap.put(m, monitor);
        }
    }

    public void register() {
        String beanSubTreeNode = EjbMonitoringUtils.registerComponent(this.appName, this.moduleName, this.beanName, this);
        if (beanSubTreeNode != null) {
            this.registered = true;
            for (Method m : this.methodMonitorMap.keySet()) {
                EjbMethodStatsProvider monitor = this.methodMonitorMap.get(m);
            }
        }
    }

    public void unregister() {
        if (this.registered) {
            this.registered = false;
            StatsProviderManager.unregister((Object)this);
            for (EjbMethodStatsProvider monitor : this.methodMonitorMap.values()) {
                if (!monitor.isRegistered()) continue;
                monitor.unregistered();
                StatsProviderManager.unregister((Object)monitor);
            }
        }
    }

    @ProbeListener(value="glassfish:ejb:ejb-monitoring:methodStartEvent")
    public void ejbMethodStartEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName, @ProbeParam(value="method") Method method) {
        if (this.isValidEvent(appName, modName, ejbName)) {
            this.log("ejbMethodStartEvent", method);
            EjbMethodStatsProvider monitor = this.methodMonitorMap.get(method);
            if (monitor != null) {
                monitor.methodStart();
            }
        }
    }

    @ProbeListener(value="glassfish:ejb:ejb-monitoring:methodEndEvent")
    public void ejbMethodEndEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName, @ProbeParam(value="exception") Throwable exception, @ProbeParam(value="method") Method method) {
        if (this.isValidEvent(appName, modName, ejbName)) {
            this.log("ejbMethodEndEvent", method);
            EjbMethodStatsProvider monitor = this.methodMonitorMap.get(method);
            if (monitor != null) {
                monitor.methodEnd(exception == null);
            }
        }
    }

    @ProbeListener(value="glassfish:ejb:ejb-monitoring:beanCreatedEvent")
    public void ejbBeanCreatedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.isValidEvent(appName, modName, ejbName)) {
            this.log("ejbBeanCreatedEvent");
            this.createStat.increment();
        }
    }

    @ProbeListener(value="glassfish:ejb:ejb-monitoring:beanDestroyedEvent")
    public void ejbBeanDestroyedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.isValidEvent(appName, modName, ejbName)) {
            this.log("ejbBeanDestroyedEvent");
            this.removeStat.increment();
        }
    }

    @ProbeListener(value="glassfish:ejb:ejb-monitoring:beanActivatedEvent")
    public void ejbBeanActivatedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.isValidEvent(appName, modName, ejbName)) {
            this.log("ejbBeanActivatedEvent");
        }
    }

    @ProbeListener(value="glassfish:ejb:ejb-monitoring:beanPassivatedEvent")
    public void ejbBeanPassivatedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.isValidEvent(appName, modName, ejbName)) {
            this.log("ejbBeanPassivatedEvent");
        }
    }

    @ManagedAttribute(id="createcount")
    @Description(value="Number of times EJB create method is called")
    public CountStatistic getCreateCount() {
        return this.createStat.getStatistic();
    }

    @ManagedAttribute(id="removecount")
    @Description(value="Number of times EJB remove method is called")
    public CountStatistic getRemoveCount() {
        return this.removeStat.getStatistic();
    }

    private boolean isValidEvent(String appName, String moduleName, String beanName) {
        if (this.appName == null && appName != null || this.appName != null && !this.appName.equals(appName)) {
            return false;
        }
        if (this.moduleName == null && moduleName != null || this.moduleName != null && !this.moduleName.equals(moduleName)) {
            return false;
        }
        return (this.beanName != null || beanName == null) && (this.beanName == null || this.beanName.equals(beanName));
    }

    private void log(String mname) {
        _logger.fine("===> In EjbMonitoringStatsProvider for: [" + mname + "] " + this.appName + "::" + this.moduleName + "::" + this.beanName);
    }

    private void log(String mname, Method m) {
        _logger.fine("===> In EjbMonitoringStatsProvider for: [" + mname + "] " + this.appName + "::" + this.moduleName + "::" + this.beanName + "::" + EjbMonitoringUtils.stringify(m));
    }
}

