/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-http")
@Scoped(value=PerLookup.class)
@I18n(value="delete.http")
public class DeleteHttp
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteHttp.class);
    @Param(name="protocolname", primary=true)
    String protocolName;
    Protocol protocolToBeRemoved = null;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        NetworkConfig networkConfig = config.getNetworkConfig();
        Protocols protocols = networkConfig.getProtocols();
        try {
            for (Protocol protocol : protocols.getProtocol()) {
                if (!this.protocolName.equalsIgnoreCase(protocol.getName())) continue;
                this.protocolToBeRemoved = protocol;
            }
            if (this.protocolToBeRemoved == null) {
                report.setMessage(localStrings.getLocalString("delete.http.notexists", "{0} http doesn't exist", new Object[]{this.protocolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) {
                    param.setHttp(null);
                    return null;
                }
            }, (ConfigBeanProxy)this.protocolToBeRemoved);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.http.fail", "Deletion of http {0} failed", new Object[]{this.protocolName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

