/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="jsp-mon", group="monitoring")
@ManagedObject
@Description(value="Web Container JSP Statistics")
public class JspStatsProvider {
    private String moduleName;
    private String vsName;
    private Logger logger;
    private CountStatisticImpl activeJspsLoadedCount = new CountStatisticImpl("ActiveJspsLoaded", "count", "Number of currently loaded JSPs");
    private CountStatisticImpl maxJspsLoadedCount = new CountStatisticImpl("MaxJspsLoaded", "count", "Maximum number of JSPs loaded which were active");
    private CountStatisticImpl totalJspsLoadedCount = new CountStatisticImpl("TotalJspsLoaded", "count", "Cumulative number of JSP pages that have been loaded into the web module");

    public JspStatsProvider(String moduleName, String vsName, Logger logger) {
        this.moduleName = moduleName;
        this.vsName = vsName;
    }

    @ManagedAttribute(id="activejspsloadedcount")
    @Description(value="Number of currently loaded JSPs")
    public CountStatistic getActiveJspsLoaded() {
        return this.activeJspsLoadedCount;
    }

    @ManagedAttribute(id="maxjspsloadedcount")
    @Description(value="Maximum number of JSPs loaded which were active")
    public CountStatistic getMaxJspsLoaded() {
        return this.maxJspsLoadedCount;
    }

    @ManagedAttribute(id="totaljspsloadedcount")
    @Description(value="Cumulative number of JSP pages that have been loaded into the web module")
    public CountStatistic getTotalJspsLoaded() {
        return this.totalJspsLoadedCount;
    }

    @ProbeListener(value="glassfish:web:jsp:jspLoadedEvent")
    public void jspLoadedEvent(@ProbeParam(value="jsp") Servlet jsp, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeJspsLoadedCount.increment();
        this.totalJspsLoadedCount.increment();
        if (this.activeJspsLoadedCount.getCount() > this.maxJspsLoadedCount.getCount()) {
            this.maxJspsLoadedCount.setCount(this.activeJspsLoadedCount.getCount());
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.vsName;
    }

    private boolean isValidEvent(String mName, String hostName) {
        if (this.moduleName == null || this.vsName == null) {
            return true;
        }
        return this.moduleName.equals(mName) && this.vsName.equals(hostName);
    }

    private void resetStats() {
        this.activeJspsLoadedCount.setCount(0L);
        this.maxJspsLoadedCount.setCount(0L);
        this.totalJspsLoadedCount.setCount(0L);
    }
}

