/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="session-mon", group="monitoring")
@ManagedObject
@Description(value="Web Container Session Statistics")
public class SessionStatsProvider {
    private String moduleName;
    private String vsName;
    private Logger logger;
    private CountStatisticImpl activeSessionsCurrent = new CountStatisticImpl("ActiveSessionsCurrent", "count", "Number of currently active sessions");
    private CountStatisticImpl activeSessionsHigh = new CountStatisticImpl("ActiveSessionsHigh", "count", "Maximum number of concurrently active sessions");
    private CountStatisticImpl sessionsTotal = new CountStatisticImpl("SessionsTotal", "count", "Total number of sessions created");
    private CountStatisticImpl expiredSessionsTotal = new CountStatisticImpl("ExpiredSessionsTotal", "count", "Total number of expired sessions");
    private CountStatisticImpl rejectedSessionsTotal = new CountStatisticImpl("RejectedSessionsTotal", "count", "Total number of rejected sessions");
    private CountStatisticImpl persistedSessionsTotal = new CountStatisticImpl("PersistedSessionsTotal", "count", "Total number of persisted sessions");
    private CountStatisticImpl passivatedSessionsTotal = new CountStatisticImpl("PassivatedSessionsTotal", "count", "Total number of passivated sessions");
    private CountStatisticImpl activatedSessionsTotal = new CountStatisticImpl("ActivatedSessionsTotal", "count", "Total number of activated sessions");

    public SessionStatsProvider(String moduleName, String vsName, Logger logger) {
        this.logger = logger;
        this.moduleName = moduleName;
        this.vsName = vsName;
    }

    @ManagedAttribute(id="activesessionscurrent")
    @Description(value="Number of currently active sessions")
    public CountStatistic getActiveSessionsCurrent() {
        return this.activeSessionsCurrent;
    }

    @ManagedAttribute(id="sessionstotal")
    @Description(value="Total number of sessions created")
    public CountStatistic getSessionsTotal() {
        return this.sessionsTotal;
    }

    @ManagedAttribute(id="activesessionshigh")
    @Description(value="Maximum number of concurrently active sessions")
    public CountStatistic getActiveSessionsHigh() {
        return this.activeSessionsHigh;
    }

    @ManagedAttribute(id="rejectedsessionstotal")
    @Description(value="Total number of rejected sessions")
    public CountStatistic getRejectedSessionsTotal() {
        return this.rejectedSessionsTotal;
    }

    @ManagedAttribute(id="expiredsessionstotal")
    @Description(value="Total number of expired sessions")
    public CountStatistic getExpiredSessionsTotal() {
        return this.expiredSessionsTotal;
    }

    @ManagedAttribute(id="persistedsessionstotal")
    @Description(value="Total number of persisted sessions")
    public CountStatistic getPersistedSessionsTotal() {
        return this.persistedSessionsTotal;
    }

    @ManagedAttribute(id="passivatedsessionstotal")
    @Description(value="Total number of passivated sessions")
    public CountStatistic getPassivatedSessionsTotal() {
        return this.passivatedSessionsTotal;
    }

    @ManagedAttribute(id="activatedsessionstotal")
    @Description(value="Total number of activated sessions")
    public CountStatistic getActivatedSessionsTotal() {
        return this.activatedSessionsTotal;
    }

    @ProbeListener(value="glassfish:web:session:sessionCreatedEvent")
    public void sessionCreatedEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionCreatedEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.incrementActiveSessionsCurrent();
    }

    @ProbeListener(value="glassfish:web:session:sessionDestroyedEvent")
    public void sessionDestroyedEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionDestroyedEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeSessionsCurrent.decrement();
    }

    @ProbeListener(value="glassfish:web:session:sessionRejectedEvent")
    public void sessionRejectedEvent(@ProbeParam(value="maxThresholdSize") int maxSessions, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionRejectedEvent received - max sessions = " + maxSessions + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.sessionsTotal.increment();
        this.rejectedSessionsTotal.increment();
    }

    @ProbeListener(value="glassfish:web:session:sessionExpiredEvent")
    public void sessionExpiredEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionExpiredEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.expiredSessionsTotal.increment();
    }

    @ProbeListener(value="glassfish:web:session:sessionPersistedStartEvent")
    public void sessionPersistedStartEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionPersistedStartEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
    }

    @ProbeListener(value="glassfish:web:session:sessionPersistedEndEvent")
    public void sessionPersistedEndEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionPersistedEndEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.persistedSessionsTotal.increment();
    }

    @ProbeListener(value="glassfish:web:session:sessionActivatedStartEvent")
    public void sessionActivatedStartEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionActivatedStartEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
    }

    @ProbeListener(value="glassfish:web:session:sessionActivatedEndEvent")
    public void sessionActivatedEndEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionActivatedEndEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.incrementActiveSessionsCurrent();
        this.activatedSessionsTotal.increment();
    }

    @ProbeListener(value="glassfish:web:session:sessionPassivatedStartEvent")
    public void sessionPassivatedStartEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionPassivatedStartEvent  received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
    }

    @ProbeListener(value="glassfish:web:session:sessionPassivatedEndEvent")
    public void sessionPassivatedEndEvent(@ProbeParam(value="session") HttpSession session, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]sessionPassivatedEndEvent received - session = " + session.toString() + ": appname = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.passivatedSessionsTotal.increment();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.vsName;
    }

    private void incrementActiveSessionsCurrent() {
        this.activeSessionsCurrent.increment();
        if (this.activeSessionsCurrent.getCount() > this.activeSessionsHigh.getCount()) {
            this.activeSessionsHigh.setCount(this.activeSessionsCurrent.getCount());
        }
        this.sessionsTotal.increment();
    }

    private boolean isValidEvent(String mName, String hostName) {
        if (this.moduleName == null || this.vsName == null) {
            return true;
        }
        return this.moduleName.equals(mName) && this.vsName.equals(hostName);
    }

    private void resetStats() {
        this.activeSessionsCurrent.setCount(0L);
        this.activeSessionsHigh.setCount(0L);
        this.sessionsTotal.setCount(0L);
        this.expiredSessionsTotal.setCount(0L);
        this.rejectedSessionsTotal.setCount(0L);
        this.persistedSessionsTotal.setCount(0L);
        this.passivatedSessionsTotal.setCount(0L);
        this.activatedSessionsTotal.setCount(0L);
    }
}

