/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import java.beans.PropertyChangeEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.web.admin.monitor.JspStatsProvider;
import org.glassfish.web.admin.monitor.ServletStatsProvider;
import org.glassfish.web.admin.monitor.SessionStatsProvider;
import org.glassfish.web.admin.monitor.WebRequestStatsProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="web")
@Scoped(value=Singleton.class)
public class WebStatsProviderBootstrap
implements PostConstruct,
ConfigListener {
    @Inject
    Logger logger;
    @Inject
    private static Domain domain;
    private static HttpService httpService;
    private static NetworkConfig networkConfig;
    private Server server;
    private static final String APPLICATIONS = "applications";
    Map<String, List> statsProviderToAppMap = new HashMap<String, List>();

    public void postConstruct() {
        Level dbgLevel = Level.FINEST;
        Level defaultLevel = this.logger.getLevel();
        if (defaultLevel == null || dbgLevel.intValue() < defaultLevel.intValue()) {
            // empty if block
        }
        this.logger.finest("[Monitor]In the WebStatsProviderBootstrap.postConstruct ************");
        List lc = domain.getConfigs().getConfig();
        Config config = null;
        for (Config cf : lc) {
            if (!cf.getName().equals("server-config")) continue;
            config = cf;
            break;
        }
        httpService = config.getHttpService();
        networkConfig = config.getNetworkConfig();
        this.server = null;
        List ls = domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            this.server = sr;
            break;
        }
        this.registerWebStatsProviders();
        this.registerApplicationStatsProviders();
    }

    private void registerWebStatsProviders() {
        StatsProviderManager.register("web-container", PluginPoint.SERVER, "web/jsp", new JspStatsProvider(null, null, this.logger));
        StatsProviderManager.register("web-container", PluginPoint.SERVER, "web/request", new WebRequestStatsProvider(null, null, this.logger));
        StatsProviderManager.register("web-container", PluginPoint.SERVER, "web/servlet", new ServletStatsProvider(null, null, this.logger));
        StatsProviderManager.register("web-container", PluginPoint.SERVER, "web/session", new SessionStatsProvider(null, null, this.logger));
    }

    public void registerApplicationStatsProviders() {
        List la = domain.getApplications().getModules(Application.class);
        for (Application sapp : la) {
            this.addStatsForVirtualServers(sapp.getName());
        }
        List lja = domain.getApplications().getModules(J2eeApplication.class);
        for (J2eeApplication japp : lja) {
            this.addStatsForVirtualServers(japp.getName());
        }
        List lm = domain.getApplications().getModules(WebModule.class);
        for (WebModule wm : lm) {
            this.addStatsForVirtualServers(wm.getName());
        }
    }

    private void addStatsForVirtualServers(String appName) {
        for (ApplicationRef ar : this.server.getApplicationRef()) {
            if (!appName.equals(ar.getRef())) continue;
            String vsL = ar.getVirtualServers();
            if (vsL != null) {
                for (String str : vsL.split(",")) {
                    ArrayList<Object> statspList = this.statsProviderToAppMap.get(appName);
                    if (statspList == null) {
                        statspList = new ArrayList<Object>();
                    }
                    JspStatsProvider jspStatsProvider = new JspStatsProvider(appName, str, this.logger);
                    StatsProviderManager.register("web-container", PluginPoint.SERVER, "applications/" + appName + "/" + str, jspStatsProvider);
                    statspList.add(jspStatsProvider);
                    ServletStatsProvider servletStatsProvider = new ServletStatsProvider(appName, str, this.logger);
                    StatsProviderManager.register("web-container", PluginPoint.SERVER, "applications/" + appName + "/" + str, servletStatsProvider);
                    statspList.add(servletStatsProvider);
                    SessionStatsProvider sessionStatsProvider = new SessionStatsProvider(appName, str, this.logger);
                    StatsProviderManager.register("web-container", PluginPoint.SERVER, "applications/" + appName + "/" + str, sessionStatsProvider);
                    statspList.add(sessionStatsProvider);
                    WebRequestStatsProvider websp = new WebRequestStatsProvider(appName, str, this.logger);
                    StatsProviderManager.register("web-container", PluginPoint.SERVER, "applications/" + appName + "/" + str, websp);
                    statspList.add(websp);
                    this.statsProviderToAppMap.put(appName, statspList);
                }
            } else {
                this.addStatsForUserVirtualServers(appName);
            }
            return;
        }
    }

    private void addStatsForUserVirtualServers(String appName) {
        for (VirtualServer vs : httpService.getVirtualServer()) {
            if (vs.getId().equals("__asadmin")) continue;
            ArrayList<Object> statspList = this.statsProviderToAppMap.get(appName);
            if (statspList == null) {
                statspList = new ArrayList<Object>();
            }
            JspStatsProvider jspStatsProvider = new JspStatsProvider(appName, vs.getId(), this.logger);
            StatsProviderManager.register("web-container", PluginPoint.SERVER, "applications/" + appName + "/" + vs.getId(), jspStatsProvider);
            statspList.add(jspStatsProvider);
            ServletStatsProvider servletStatsProvider = new ServletStatsProvider(appName, vs.getId(), this.logger);
            StatsProviderManager.register("web-container", PluginPoint.SERVER, "applications/" + appName + "/" + vs.getId(), servletStatsProvider);
            statspList.add(servletStatsProvider);
            SessionStatsProvider sessionStatsProvider = new SessionStatsProvider(appName, vs.getId(), this.logger);
            StatsProviderManager.register("web-container", PluginPoint.SERVER, "applications/" + appName + "/" + vs.getId(), sessionStatsProvider);
            statspList.add(sessionStatsProvider);
            WebRequestStatsProvider websp = new WebRequestStatsProvider(appName, vs.getId(), this.logger);
            StatsProviderManager.register("web-container", PluginPoint.SERVER, "applications/" + appName + "/" + vs.getId(), websp);
            statspList.add(websp);
            this.statsProviderToAppMap.put(appName, statspList);
        }
    }

    public static String getAppName(String contextRoot) {
        if (contextRoot == null) {
            return null;
        }
        List lm = domain.getApplications().getModules(WebModule.class);
        for (WebModule wm : lm) {
            if (!contextRoot.equals(wm.getContextRoot())) continue;
            return wm.getName();
        }
        List la = domain.getApplications().getModules(Application.class);
        for (Application sapp : la) {
            if (!contextRoot.equals(sapp.getContextRoot())) continue;
            return sapp.getName();
        }
        return null;
    }

    public static String getVirtualServerName(String hostName, String listenerPort) {
        try {
            if (hostName == null) {
                return null;
            }
            if (hostName.equals("localhost")) {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            NetworkListener listener = null;
            for (NetworkListener hl : networkConfig.getNetworkListeners().getNetworkListener()) {
                if (!hl.getPort().equals(listenerPort)) continue;
                listener = hl;
                break;
            }
            VirtualServer virtualServer = null;
            for (VirtualServer vs : httpService.getVirtualServer()) {
                if (!vs.getHosts().contains(hostName) || !vs.getNetworkListeners().contains(listener.getName())) continue;
                virtualServer = vs;
                break;
            }
            return virtualServer.getId();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(WebStatsProviderBootstrap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        for (PropertyChangeEvent event : events) {
            if (!event.getPropertyName().equals("application-ref")) continue;
            String propName = event.getPropertyName();
            String appName = null;
            if (event.getNewValue() != null) {
                appName = ((ApplicationRef)event.getNewValue()).getRef();
                this.addStatsForVirtualServers(appName);
            } else if (event.getOldValue() != null) {
                appName = ((ApplicationRef)event.getOldValue()).getRef();
                List statsProviders = this.statsProviderToAppMap.get(appName);
                for (Object statsProvider : statsProviders) {
                    StatsProviderManager.unregister(statsProvider);
                }
                this.statsProviderToAppMap.remove(appName);
            }
            this.logger.finest("[Monitor] (Un)Deploy event received - name = " + propName + " : Value = " + appName);
        }
        return null;
    }

    static {
        httpService = null;
        networkConfig = null;
    }
}

