/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.queries.DirectMapUsableContainerPolicy;
import org.eclipse.persistence.internal.queries.InterfaceContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ReadQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectMapContainerPolicy
extends InterfaceContainerPolicy
implements DirectMapUsableContainerPolicy {
    protected DatabaseField keyField;
    protected DatabaseField valueField;
    protected Converter keyConverter;
    protected String keyConverterClassName;
    protected Converter valueConverter;

    public DirectMapContainerPolicy() {
    }

    public DirectMapContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    @Override
    public void addAdditionalFieldsToQuery(ReadQuery selectionQuery, Expression baseExpression) {
        if (baseExpression == null) {
            ((SQLSelectStatement)((DataReadQuery)selectionQuery).getSQLStatement()).addField((DatabaseField)this.keyField.clone());
            ((SQLSelectStatement)((DataReadQuery)selectionQuery).getSQLStatement()).addTable((DatabaseTable)this.keyField.getTable().clone());
        } else {
            ((SQLSelectStatement)((DataReadQuery)selectionQuery).getSQLStatement()).addField(baseExpression.getTable(this.keyField.getTable()).getField(this.keyField));
        }
    }

    @Override
    public void addFieldsForMapKey(AbstractRecord joinRow) {
        joinRow.put(this.keyField, (Object)null);
    }

    @Override
    public boolean addInto(Object key, Object value, Object container, AbstractSession session) {
        try {
            ((Map)container).put(key, value);
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotAddElement(key, container, ex1);
        }
        return true;
    }

    @Override
    public boolean addInto(Object element, Object container, AbstractSession session) {
        Object key = null;
        Object value = null;
        if (element instanceof AbstractRecord) {
            AbstractRecord record = (AbstractRecord)element;
            key = record.get(this.keyField);
            value = record.get(this.valueField);
            return this.addInto(key, value, container, session);
        }
        if (element instanceof Association) {
            Association record = (Association)element;
            key = record.getKey();
            value = record.getValue();
            return this.addInto(key, value, container, session);
        }
        return super.addInto(element, container, session);
    }

    @Override
    public Object buildContainerFromVector(Vector vector, AbstractSession session) {
        Map container = (Map)this.containerInstance(vector.size());
        Enumeration e = vector.elements();
        while (e.hasMoreElements()) {
            AbstractRecord row = (AbstractRecord)e.nextElement();
            Object key = row.get(this.keyField);
            Object value = row.get(this.valueField);
            if (this.getKeyConverter() != null) {
                key = this.getKeyConverter().convertDataValueToObjectValue(key, session);
            }
            if (this.valueConverter != null) {
                value = this.valueConverter.convertDataValueToObjectValue(value, session);
            }
            if (key == null) continue;
            container.put(key, value);
        }
        return container;
    }

    @Override
    public Object buildKey(AbstractRecord row, ObjectBuildingQuery query, AbstractSession session) {
        Object key = row.get(this.keyField);
        if (this.keyConverter != null) {
            key = this.keyConverter.convertDataValueToObjectValue(key, session);
        }
        return key;
    }

    @Override
    public void clear(Object container) {
        try {
            ((Map)container).clear();
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "clear()");
        }
    }

    @Override
    public boolean compareContainers(Object firstObjectMap, Object secondObjectMap) {
        if (this.sizeFor(firstObjectMap) != this.sizeFor(secondObjectMap)) {
            return false;
        }
        Object firstIterator = this.iteratorFor(firstObjectMap);
        while (this.hasNext(firstIterator)) {
            Map.Entry entry = (Map.Entry)this.nextEntry(firstIterator);
            Object key = entry.getKey();
            if (((Map)firstObjectMap).get(key).equals(((Map)secondObjectMap).get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean compareKeys(Object sourceValue, AbstractSession session) {
        if (((UnitOfWorkImpl)session).isClassReadOnly(sourceValue.getClass())) {
            return true;
        }
        Object backUpVersion = ((UnitOfWorkImpl)session).getBackupClone(sourceValue, this.getElementDescriptor());
        return this.keyFrom(backUpVersion, session).equals(this.keyFrom(sourceValue, session));
    }

    @Override
    protected boolean contains(Object element, Object container) {
        return ((Map)container).containsValue(element);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.keyConverter != null) {
            if (this.keyConverter instanceof TypeConversionConverter) {
                ((TypeConversionConverter)this.keyConverter).convertClassNamesToClasses(classLoader);
            } else if (this.keyConverter instanceof ObjectTypeConverter) {
                ((ObjectTypeConverter)this.keyConverter).convertClassNamesToClasses(classLoader);
            }
        }
        if (this.keyConverterClassName != null) {
            Converter keyConverter;
            block13: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        Class keyConverterClass;
                        try {
                            keyConverterClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.keyConverterClassName, true, classLoader));
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, exception.getException());
                        }
                        try {
                            keyConverter = (Converter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(keyConverterClass));
                            break block13;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, exception.getException());
                        }
                    }
                    Class keyConverterClass = PrivilegedAccessHelper.getClassForName(this.keyConverterClassName, true, classLoader);
                    keyConverter = (Converter)PrivilegedAccessHelper.newInstanceFromClass(keyConverterClass);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, exc);
                }
                catch (Exception e) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, e);
                }
            }
            this.keyConverter = keyConverter;
        }
    }

    @Override
    public QueryKey createQueryKeyForMapKey() {
        return null;
    }

    @Override
    public DatabaseField getDirectKeyField(CollectionMapping baseMapping) {
        return this.keyField;
    }

    @Override
    public Class getInterfaceType() {
        return ClassConstants.Map_Class;
    }

    @Override
    public List<DatabaseField> getIdentityFieldsForMapKey() {
        ArrayList<DatabaseField> list = new ArrayList<DatabaseField>(1);
        list.add(this.keyField);
        return list;
    }

    @Override
    public boolean hasNext(Object iterator) {
        return ((MapContainerPolicy.MapContainerPolicyIterator)iterator).hasNext();
    }

    @Override
    public Map getKeyMappingDataForWriteQuery(Object object, AbstractSession session) {
        Object keyValue = ((Map.Entry)object).getKey();
        HashMap fields = new HashMap();
        if (this.keyConverter != null) {
            keyValue = this.keyConverter.convertObjectValueToDataValue(keyValue, session);
        }
        fields.put(this.keyField, keyValue);
        return fields;
    }

    @Override
    public Object getKeyType() {
        return this.keyField.getType();
    }

    @Override
    public boolean isDirectMapPolicy() {
        return true;
    }

    @Override
    public boolean isMapKeyAttribute() {
        return true;
    }

    @Override
    public void initialize(AbstractSession session, DatabaseTable keyTable) {
        if (this.getDirectKeyField(null) == null) {
            throw DescriptorException.directKeyNotSet(this.elementDescriptor);
        }
        this.getDirectKeyField(null).setTable(keyTable);
        this.getDirectKeyField(null).setIndex(1);
    }

    @Override
    public Object iteratorFor(Object container) {
        return new MapContainerPolicy.MapContainerPolicyIterator((Map)container);
    }

    @Override
    public Object keyFromIterator(Object iterator) {
        return ((MapContainerPolicy.MapContainerPolicyIterator)iterator).getCurrentKey();
    }

    @Override
    public Object keyFromEntry(Object entry) {
        if (entry instanceof Map.Entry) {
            return ((Map.Entry)entry).getKey();
        }
        return null;
    }

    @Override
    protected Object next(Object iterator) {
        return ((MapContainerPolicy.MapContainerPolicyIterator)iterator).next().getValue();
    }

    @Override
    public Object nextEntry(Object iterator) {
        return ((MapContainerPolicy.MapContainerPolicyIterator)iterator).next();
    }

    @Override
    public Object nextEntry(Object iterator, AbstractSession session) {
        return this.nextEntry(iterator);
    }

    @Override
    public Object unwrapIteratorResult(Object object) {
        if (object instanceof Map.Entry) {
            return ((Map.Entry)object).getValue();
        }
        return object;
    }

    @Override
    public boolean removeFrom(Object key, Object element, Object container, AbstractSession session) {
        try {
            Object returnValue = null;
            returnValue = key != null ? ((Map)container).remove(key) : ((Map)container).remove(this.keyFrom(element, session));
            return returnValue != null;
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "remove(Object element)");
        }
    }

    public boolean removeFromWithIdentity(Object element, Object container, AbstractSession session) {
        boolean found = false;
        Vector knownKeys = new Vector(1);
        try {
            for (Object key : ((Map)container).keySet()) {
                if (((Map)container).get(key) != element) continue;
                knownKeys.addElement(key);
                found = true;
            }
            if (found) {
                for (int index = 0; index < knownKeys.size(); ++index) {
                    ((Map)container).remove(knownKeys.elementAt(index));
                }
            }
            return found;
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "remove(Object element)");
        }
    }

    @Override
    public void setDescriptorForKeyMapping(ClassDescriptor descriptor) {
        this.elementDescriptor = descriptor;
    }

    public void setKeyField(DatabaseField field) {
        this.keyField = field;
    }

    @Override
    public void setKeyField(DatabaseField field, ClassDescriptor descriptor) {
        this.setKeyField(field);
    }

    @Override
    public void setValueField(DatabaseField field, Converter converter) {
        this.valueField = field;
        this.valueConverter = converter;
    }

    @Override
    public int sizeFor(Object container) {
        return ((Map)container).size();
    }

    @Override
    public void validateElementAndRehashIfRequired(Object sourceValue, Object targetMap, AbstractSession session, Object targetVersionOfSource) {
        Object backupValue;
        if (session.isUnitOfWork() && !this.keyFrom(backupValue = ((UnitOfWorkImpl)session).getBackupClone(sourceValue, this.getElementDescriptor()), session).equals(this.keyFrom(sourceValue, session))) {
            this.removeFrom(backupValue, targetMap, session);
            this.addInto(targetVersionOfSource, targetMap, session);
        }
    }

    @Override
    public boolean isValidContainer(Object container) {
        return container instanceof Map;
    }

    @Override
    public Converter getKeyConverter() {
        return this.keyConverter;
    }

    @Override
    public void setKeyConverter(Converter keyConverter, DirectMapMapping mapping) {
        this.keyConverter = keyConverter;
    }

    @Override
    public void setKeyConverterClassName(String keyConverterClassName, DirectMapMapping mapping) {
        this.keyConverterClassName = keyConverterClassName;
    }
}

