/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace;

import com.sun.btrace.BTraceRuntime;
import com.sun.btrace.aggregation.Aggregation;
import com.sun.btrace.aggregation.AggregationFunction;
import com.sun.btrace.aggregation.AggregationKey;
import java.io.Serializable;
import java.lang.management.MemoryUsage;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import sun.reflect.Reflection;

public final class BTraceUtils {
    private BTraceUtils() {
    }

    public static boolean isInteruppted() {
        return Thread.currentThread().isInterrupted();
    }

    public static void jstack() {
        BTraceUtils.jstack(-1);
    }

    public static void jstack(int numFrames) {
        if (numFrames == 0) {
            return;
        }
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        BTraceRuntime.stackTrace(st, 5, numFrames);
    }

    public static void jstackAll() {
        BTraceUtils.jstackAll(-1);
    }

    public static void jstackAll(int numFrames) {
        BTraceRuntime.stackTraceAll(numFrames);
    }

    public static String jstackStr() {
        return BTraceUtils.jstackStr(-1);
    }

    public static String jstackStr(int numFrames) {
        if (numFrames == 0) {
            return "";
        }
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        return BTraceRuntime.stackTraceStr(st, 5, numFrames);
    }

    public static String jstackAllStr() {
        return BTraceUtils.jstackAllStr(-1);
    }

    public static String jstackAllStr(int numFrames) {
        if (numFrames == 0) {
            return "";
        }
        return BTraceRuntime.stackTraceAllStr(numFrames);
    }

    public static void jstack(Throwable exception) {
        BTraceUtils.jstack(exception, -1);
    }

    public static void jstack(Throwable exception, int numFrames) {
        if (numFrames == 0) {
            return;
        }
        StackTraceElement[] st = exception.getStackTrace();
        BTraceUtils.println(exception);
        BTraceRuntime.stackTrace("\t", st, 0, numFrames);
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            BTraceUtils.println("Caused by:");
            st = cause.getStackTrace();
            BTraceRuntime.stackTrace("\t", st, 0, numFrames);
        }
    }

    public static String jstackStr(Throwable exception) {
        return BTraceUtils.jstackStr(exception, -1);
    }

    public static String jstackStr(Throwable exception, int numFrames) {
        if (numFrames == 0) {
            return "";
        }
        StackTraceElement[] st = exception.getStackTrace();
        StringBuffer buf = new StringBuffer();
        buf.append(BTraceUtils.str(exception));
        buf.append(BTraceRuntime.stackTraceStr("\t", st, 0, numFrames));
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            buf.append("Caused by:");
            st = cause.getStackTrace();
            buf.append(BTraceRuntime.stackTraceStr("\t", st, 0, numFrames));
        }
        return buf.toString();
    }

    public static Thread currentThread() {
        return Thread.currentThread();
    }

    public static long threadId(Thread thread) {
        return thread.getId();
    }

    public static Thread.State threadState(Thread thread) {
        return thread.getState();
    }

    public static boolean holdsLock(Object obj) {
        return Thread.holdsLock(obj);
    }

    public static void deadlocks() {
        BTraceUtils.deadlocks(true);
    }

    public static void deadlocks(boolean stackTrace) {
        BTraceRuntime.deadlocks(stackTrace);
    }

    public static String name(Thread thread) {
        return thread.getName();
    }

    public static ClassLoader loader(Class clazz) {
        return clazz.getClassLoader();
    }

    public static ClassLoader parentLoader(ClassLoader loader) {
        return loader.getParent();
    }

    public static String str(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj.getClass().getClassLoader() == null) {
            return obj.toString();
        }
        return BTraceUtils.identityStr(obj);
    }

    public static String identityStr(Object obj) {
        int hashCode = System.identityHashCode(obj);
        return obj.getClass().getName() + "@" + Integer.toHexString(hashCode);
    }

    public static int hash(Object obj) {
        if (obj.getClass().getClassLoader() == null) {
            return obj.hashCode();
        }
        return System.identityHashCode(obj);
    }

    public static int identityHashCode(Object obj) {
        return System.identityHashCode(obj);
    }

    public static boolean compare(Object obj1, Object obj2) {
        return BTraceRuntime.compare(obj1, obj2);
    }

    public static Class classOf(Object obj) {
        return obj.getClass();
    }

    public static Class declaringClass(Field field) {
        return field.getDeclaringClass();
    }

    public static String name(Class clazz) {
        return clazz.getName();
    }

    public static String name(Field field) {
        return field.getName();
    }

    public static Class type(Field field) {
        return field.getType();
    }

    public static int accessFlags(Class clazz) {
        return clazz.getModifiers();
    }

    public static int accessFlags(Field field) {
        return field.getModifiers();
    }

    public static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class classForName(String name) {
        ClassLoader callerLoader = Reflection.getCallerClass((int)1).getClassLoader();
        return BTraceUtils.classForName(name, callerLoader);
    }

    public static Class classForName(String name, ClassLoader cl) {
        try {
            return Class.forName(name, false, cl);
        }
        catch (ClassNotFoundException exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static boolean isAssignableFrom(Class<?> a, Class<?> b) {
        return a.isAssignableFrom(b);
    }

    public static boolean isInstance(Class clazz, Object obj) {
        return clazz.isInstance(obj);
    }

    public static Class getSuperclass(Class clazz) {
        return clazz.getSuperclass();
    }

    public static boolean isInterface(Class clazz) {
        return clazz.isInterface();
    }

    public static boolean isArray(Class clazz) {
        return clazz.isArray();
    }

    public static boolean isPrimitive(Class clazz) {
        return clazz.isPrimitive();
    }

    public static Class getComponentType(Class clazz) {
        return clazz.getComponentType();
    }

    public static Field field(Class clazz, String name, boolean throwException) {
        return BTraceUtils.getField(clazz, name, throwException);
    }

    public static Field field(Class clazz, String name) {
        return BTraceUtils.field(clazz, name, true);
    }

    public static Field field(String clazz, String name, boolean throwException) {
        ClassLoader callerLoader = Reflection.getCallerClass((int)1).getClassLoader();
        return BTraceUtils.field(BTraceUtils.classForName(clazz, callerLoader), name, throwException);
    }

    public static Field field(String clazz, String name) {
        return BTraceUtils.field(clazz, name, true);
    }

    public static byte getByte(Field field) {
        BTraceUtils.checkStatic(field);
        try {
            return field.getByte(null);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static byte getByte(Field field, Object obj) {
        try {
            return field.getByte(obj);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static short getShort(Field field) {
        BTraceUtils.checkStatic(field);
        try {
            return field.getShort(null);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static short getShort(Field field, Object obj) {
        try {
            return field.getShort(obj);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static int getInt(Field field) {
        BTraceUtils.checkStatic(field);
        try {
            return field.getInt(null);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static int getInt(Field field, Object obj) {
        try {
            return field.getInt(obj);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static long getLong(Field field) {
        BTraceUtils.checkStatic(field);
        try {
            return field.getLong(null);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static long getLong(Field field, Object obj) {
        try {
            return field.getLong(obj);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static float getFloat(Field field) {
        BTraceUtils.checkStatic(field);
        try {
            return field.getFloat(null);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static float getFloat(Field field, Object obj) {
        try {
            return field.getFloat(obj);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static double getDouble(Field field) {
        BTraceUtils.checkStatic(field);
        try {
            return field.getDouble(null);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static double getDouble(Field field, Object obj) {
        try {
            return field.getDouble(obj);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static boolean getBoolean(Field field) {
        BTraceUtils.checkStatic(field);
        try {
            return field.getBoolean(null);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static boolean getBoolean(Field field, Object obj) {
        try {
            return field.getBoolean(obj);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static char getChar(Field field) {
        BTraceUtils.checkStatic(field);
        try {
            return field.getChar(null);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static char getChar(Field field, Object obj) {
        try {
            return field.getChar(obj);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static Object get(Field field) {
        BTraceUtils.checkStatic(field);
        try {
            return field.get(null);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static Object get(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (Exception exp) {
            throw BTraceUtils.translate(exp);
        }
    }

    public static WeakReference weakRef(Object obj) {
        return new WeakReference<Object>(obj);
    }

    public static SoftReference softRef(Object obj) {
        return new SoftReference<Object>(obj);
    }

    public static Object deref(Reference ref) {
        if (ref.getClass().getClassLoader() == null) {
            return ref.get();
        }
        throw new IllegalArgumentException();
    }

    public static Class probeClass() {
        return Reflection.getCallerClass((int)3);
    }

    @Deprecated
    public static String probeMethod() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length >= 4) {
            return stack[3].getMethodName();
        }
        return null;
    }

    public static int probeLine() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length >= 4) {
            return stack[3].getLineNumber();
        }
        return -1;
    }

    public static void printMap(Map map) {
        BTraceRuntime.printMap(map);
    }

    public static void printStringMap(String name, Map<String, String> data) {
        BTraceRuntime.printStringMap(name, data);
    }

    public static void printNumberMap(String name, Map<String, ? extends Number> data) {
        BTraceRuntime.printNumberMap(name, data);
    }

    public static void printNumber(String name, Number value) {
        BTraceRuntime.printNumber(name, value);
    }

    public static void printArray(Object[] array) {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (Object obj : array) {
            buf.append(BTraceUtils.str(obj));
            buf.append(", ");
        }
        buf.append(']');
        BTraceUtils.println(buf.toString());
    }

    public static void printFields(Object obj) {
        BTraceUtils.printFields(obj, false);
    }

    public static void printFields(Object obj, boolean classNamePrefix) {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        BTraceUtils.addFieldValues(buf, obj, obj.getClass(), classNamePrefix);
        buf.append('}');
        BTraceUtils.println(buf.toString());
    }

    public static void printStaticFields(Class clazz) {
        BTraceUtils.printStaticFields(clazz, false);
    }

    public static void printStaticFields(Class clazz, boolean classNamePrefix) {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        BTraceUtils.addStaticFieldValues(buf, clazz, classNamePrefix);
        buf.append('}');
        BTraceUtils.println(buf.toString());
    }

    public static void print(Object obj) {
        BTraceRuntime.print(BTraceUtils.str(obj));
    }

    public static void print(boolean b) {
        BTraceUtils.print((Object)b);
    }

    public static void print(char c) {
        BTraceUtils.print(Character.valueOf(c));
    }

    public static void print(int i) {
        BTraceUtils.print((Object)i);
    }

    public static void print(long l) {
        BTraceUtils.print((Object)l);
    }

    public static void print(float f) {
        BTraceUtils.print(Float.valueOf(f));
    }

    public static void print(double d) {
        BTraceUtils.print((Object)d);
    }

    public static void println(Object obj) {
        BTraceRuntime.println(BTraceUtils.str(obj));
    }

    public static void println(boolean b) {
        BTraceUtils.println((Object)b);
    }

    public static void println(char c) {
        BTraceUtils.println(Character.valueOf(c));
    }

    public static void println(int i) {
        BTraceUtils.println((Object)i);
    }

    public static void println(long l) {
        BTraceUtils.println((Object)l);
    }

    public static void println(float f) {
        BTraceUtils.println(Float.valueOf(f));
    }

    public static void println(double d) {
        BTraceUtils.println((Object)d);
    }

    public static void println() {
        BTraceRuntime.println();
    }

    public static long vmStartTime() {
        return BTraceRuntime.vmStartTime();
    }

    public static long vmUptime() {
        return BTraceRuntime.vmUptime();
    }

    public static long timeMillis() {
        return System.currentTimeMillis();
    }

    public static long timeNanos() {
        return System.nanoTime();
    }

    public static boolean startsWith(String s, String start) {
        return s.startsWith(start);
    }

    public static boolean endsWith(String s, String end) {
        return s.endsWith(end);
    }

    public static String strcat(String str1, String str2) {
        return BTraceUtils.concat(str1, str2);
    }

    public static String concat(String str1, String str2) {
        return str1.concat(str2);
    }

    public static int compareTo(String str1, String str2) {
        return str1.compareTo(str2);
    }

    public static int strcmp(String str1, String str2) {
        return str1.compareTo(str2);
    }

    public static int compareToIgnoreCase(String str1, String str2) {
        return str1.compareToIgnoreCase(str2);
    }

    public static int stricmp(String str1, String str2) {
        return str1.compareToIgnoreCase(str2);
    }

    public static int strstr(String str1, String str2) {
        return str1.indexOf(str2);
    }

    public static int indexOf(String str1, String str2) {
        return str1.indexOf(str2);
    }

    public static int lastIndexOf(String str1, String str2) {
        return str1.lastIndexOf(str2);
    }

    public static String substr(String str, int start, int length) {
        return str.substring(start, length);
    }

    public static String substr(String str, int start) {
        return str.substring(start);
    }

    public static int length(String str) {
        return str.length();
    }

    public static int strlen(String str) {
        return str.length();
    }

    public static Pattern regexp(String regex) {
        return Pattern.compile(regex);
    }

    public static Pattern pattern(String regex) {
        return BTraceUtils.regexp(regex);
    }

    public static Pattern regexp(String regex, int flags) {
        return Pattern.compile(regex, flags);
    }

    public static Pattern pattern(String regex, int flags) {
        return BTraceUtils.regexp(regex, flags);
    }

    public static boolean matches(Pattern regex, String input) {
        return regex.matcher(input).matches();
    }

    public static boolean matches(String regex, String input) {
        return Pattern.matches(regex, input);
    }

    public static double random() {
        return Math.random();
    }

    public static strictfp double log(double a) {
        return Math.log(a);
    }

    public static strictfp double log10(double a) {
        return Math.log10(a);
    }

    public static strictfp double exp(double a) {
        return Math.exp(a);
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public static boolean isNaN(float f) {
        return Float.isNaN(f);
    }

    public static boolean isInfinite(double d) {
        return Double.isInfinite(d);
    }

    public static boolean isInfinite(float f) {
        return Float.isInfinite(f);
    }

    public static boolean parseBoolean(String s) {
        return Boolean.parseBoolean(s);
    }

    public static byte parseByte(String s) {
        return Byte.parseByte(s);
    }

    public static short parseShort(String s) {
        return Short.parseShort(s);
    }

    public static int parseInt(String s) {
        return Integer.parseInt(s);
    }

    public static long parseLong(String s) {
        return Long.parseLong(s);
    }

    public static float parseFloat(String s) {
        return Float.parseFloat(s);
    }

    public static double parseDouble(String s) {
        return Double.parseDouble(s);
    }

    public static Boolean box(boolean b) {
        return b;
    }

    public static Character box(char c) {
        return Character.valueOf(c);
    }

    public static Byte box(byte b) {
        return b;
    }

    public static Short box(short s) {
        return s;
    }

    public static Integer box(int i) {
        return i;
    }

    public static Long box(long l) {
        return l;
    }

    public static Float box(float f) {
        return Float.valueOf(f);
    }

    public static Double box(double d) {
        return d;
    }

    public static boolean unbox(Boolean b) {
        return b;
    }

    public static char unbox(Character ch) {
        return ch.charValue();
    }

    public static byte unbox(Byte b) {
        return b;
    }

    public static short unbox(Short s) {
        return s;
    }

    public static int unbox(Integer i) {
        return i;
    }

    public static long unbox(Long l) {
        return l;
    }

    public static float unbox(Float f) {
        return f.floatValue();
    }

    public static double unbox(Double d) {
        return d;
    }

    public static String str(boolean b) {
        return Boolean.toString(b);
    }

    public static String str(char c) {
        return Character.toString(c);
    }

    public static String str(int i) {
        return Integer.toString(i);
    }

    public static String toHexString(int i) {
        return Integer.toHexString(i);
    }

    public static String str(long l) {
        return Long.toString(l);
    }

    public static String toHexString(long l) {
        return Long.toHexString(l);
    }

    public static String str(float f) {
        return Float.toString(f);
    }

    public static String str(double d) {
        return Double.toString(d);
    }

    public static void exit(int exitCode) {
        BTraceRuntime.exit(exitCode);
    }

    public static void exit() {
        BTraceUtils.exit(0);
    }

    public static long perfInt(String name) {
        return BTraceRuntime.perfInt(name);
    }

    public static long perfLong(String name) {
        return BTraceRuntime.perfLong(name);
    }

    public static String perfString(String name) {
        return BTraceRuntime.perfString(name);
    }

    public static <K, V> Map<K, V> newHashMap() {
        return BTraceRuntime.newHashMap();
    }

    public static <K, V> Map<K, V> newWeakMap() {
        return BTraceRuntime.newWeakMap();
    }

    public static <V> Deque<V> newDeque() {
        return BTraceRuntime.newDeque();
    }

    public static <K, V> V get(Map<K, V> map, Object key) {
        return BTraceRuntime.get(map, key);
    }

    public static <K, V> boolean containsKey(Map<K, V> map, Object key) {
        return BTraceRuntime.containsKey(map, key);
    }

    public static <K, V> boolean containsValue(Map<K, V> map, Object value) {
        return BTraceRuntime.containsKey(map, value);
    }

    public static <K, V> V put(Map<K, V> map, K key, V value) {
        return BTraceRuntime.put(map, key, value);
    }

    public static <K, V> V remove(Map<K, V> map, Object key) {
        return BTraceRuntime.remove(map, key);
    }

    public static <K, V> void clear(Map<K, V> map) {
        BTraceRuntime.clear(map);
    }

    public static <K, V> int size(Map<K, V> map) {
        return BTraceRuntime.size(map);
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return BTraceRuntime.isEmpty(map);
    }

    public static <E> int size(Collection<E> coll) {
        return BTraceRuntime.size(coll);
    }

    public static <E> boolean isEmpty(Collection<E> coll) {
        return BTraceRuntime.isEmpty(coll);
    }

    public static <E> boolean contains(Collection<E> coll, Object obj) {
        return BTraceRuntime.contains(coll, obj);
    }

    public static boolean contains(Object[] array, Object value) {
        for (Object each : array) {
            if (!BTraceUtils.compare(each, value)) continue;
            return true;
        }
        return false;
    }

    public static <V> void push(Deque<V> queue, V value) {
        BTraceRuntime.push(queue, value);
    }

    public static <V> V poll(Deque<V> queue) {
        return BTraceRuntime.poll(queue);
    }

    public static <V> V peek(Deque<V> queue) {
        return BTraceRuntime.peek(queue);
    }

    public static String $(int n) {
        return BTraceRuntime.$(n);
    }

    public static int getpid() {
        int pid = -1;
        try {
            pid = Integer.parseInt(BTraceUtils.$(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pid;
    }

    public static int $length() {
        return BTraceRuntime.$length();
    }

    public static AtomicInteger newAtomicInteger(int initialValue) {
        return BTraceRuntime.newAtomicInteger(initialValue);
    }

    public static int get(AtomicInteger ai) {
        return BTraceRuntime.get(ai);
    }

    public static void set(AtomicInteger ai, int newValue) {
        BTraceRuntime.set(ai, newValue);
    }

    public static void lazySet(AtomicInteger ai, int newValue) {
        BTraceRuntime.lazySet(ai, newValue);
    }

    public static boolean compareAndSet(AtomicInteger ai, int expect, int update) {
        return BTraceRuntime.compareAndSet(ai, expect, update);
    }

    public static boolean weakCompareAndSet(AtomicInteger ai, int expect, int update) {
        return BTraceRuntime.weakCompareAndSet(ai, expect, update);
    }

    public static int getAndIncrement(AtomicInteger ai) {
        return BTraceRuntime.getAndIncrement(ai);
    }

    public static int getAndDecrement(AtomicInteger ai) {
        return BTraceRuntime.getAndDecrement(ai);
    }

    public static int incrementAndGet(AtomicInteger ai) {
        return BTraceRuntime.incrementAndGet(ai);
    }

    public static int decrementAndGet(AtomicInteger ai) {
        return BTraceRuntime.decrementAndGet(ai);
    }

    public static int getAndAdd(AtomicInteger ai, int delta) {
        return BTraceRuntime.getAndAdd(ai, delta);
    }

    public static int addAndGet(AtomicInteger ai, int delta) {
        return BTraceRuntime.addAndGet(ai, delta);
    }

    public static int getAndSet(AtomicInteger ai, int newValue) {
        return BTraceRuntime.getAndSet(ai, newValue);
    }

    public static AtomicLong newAtomicLong(long initialValue) {
        return BTraceRuntime.newAtomicLong(initialValue);
    }

    public static long get(AtomicLong al) {
        return BTraceRuntime.get(al);
    }

    public static void set(AtomicLong al, long newValue) {
        BTraceRuntime.set(al, newValue);
    }

    public static void lazySet(AtomicLong al, long newValue) {
        BTraceRuntime.lazySet(al, newValue);
    }

    public static boolean compareAndSet(AtomicLong al, long expect, long update) {
        return BTraceRuntime.compareAndSet(al, expect, update);
    }

    public static boolean weakCompareAndSet(AtomicLong al, long expect, long update) {
        return BTraceRuntime.weakCompareAndSet(al, expect, update);
    }

    public static long getAndIncrement(AtomicLong al) {
        return BTraceRuntime.getAndIncrement(al);
    }

    public static long getAndDecrement(AtomicLong al) {
        return BTraceRuntime.getAndDecrement(al);
    }

    public static long incrementAndGet(AtomicLong al) {
        return BTraceRuntime.incrementAndGet(al);
    }

    public static long decrementAndGet(AtomicLong al) {
        return BTraceRuntime.decrementAndGet(al);
    }

    public static long getAndAdd(AtomicLong al, long delta) {
        return BTraceRuntime.getAndAdd(al, delta);
    }

    public static long addAndGet(AtomicLong al, long delta) {
        return BTraceRuntime.addAndGet(al, delta);
    }

    public static long getAndSet(AtomicLong al, long newValue) {
        return BTraceRuntime.getAndSet(al, newValue);
    }

    public static int dtraceProbe(String str1, String str2) {
        return BTraceUtils.dtraceProbe(str1, str2, -1, -1);
    }

    public static int dtraceProbe(String str1, String str2, int i1) {
        return BTraceUtils.dtraceProbe(str1, str2, i1, -1);
    }

    public static int dtraceProbe(String str1, String str2, int i1, int i2) {
        return BTraceRuntime.dtraceProbe(str1, str2, i1, i2);
    }

    public static String property(String key) {
        return BTraceRuntime.property(key);
    }

    public static Properties properties() {
        return BTraceRuntime.properties();
    }

    public static void printProperties() {
        BTraceRuntime.printMap(BTraceUtils.properties());
    }

    public static String getenv(String name) {
        return BTraceRuntime.getenv(name);
    }

    public static Map<String, String> getenv() {
        return BTraceRuntime.getenv();
    }

    public static void printEnv() {
        BTraceRuntime.printMap(BTraceUtils.getenv());
    }

    public static long availableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static long freeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long totalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long maxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static MemoryUsage heapUsage() {
        return BTraceRuntime.heapUsage();
    }

    public static MemoryUsage nonHeapUsage() {
        return BTraceRuntime.nonHeapUsage();
    }

    public static long init(MemoryUsage mu) {
        return mu.getInit();
    }

    public static long committed(MemoryUsage mu) {
        return mu.getCommitted();
    }

    public static long max(MemoryUsage mu) {
        return mu.getMax();
    }

    public static long used(MemoryUsage mu) {
        return mu.getUsed();
    }

    public static long finalizationCount() {
        return BTraceRuntime.finalizationCount();
    }

    public static List<String> vmArguments() {
        return BTraceRuntime.getInputArguments();
    }

    public static void printVmArguments() {
        BTraceUtils.println(BTraceUtils.vmArguments());
    }

    public static String vmVersion() {
        return BTraceRuntime.getVmVersion();
    }

    public static boolean isBootClassPathSupported() {
        return BTraceRuntime.isBootClassPathSupported();
    }

    public static String bootClassPath() {
        return BTraceRuntime.getBootClassPath();
    }

    public static String classPath() {
        return BTraceUtils.property("java.class.path");
    }

    public static String libraryPath() {
        return BTraceUtils.property("java.library.path");
    }

    public static long threadCount() {
        return BTraceRuntime.getThreadCount();
    }

    public static long peakThreadCount() {
        return BTraceRuntime.getPeakThreadCount();
    }

    public static long totalStartedThreadCount() {
        return BTraceRuntime.getTotalStartedThreadCount();
    }

    public static long daemonThreadCount() {
        return BTraceRuntime.getDaemonThreadCount();
    }

    public static long currentThreadCpuTime() {
        return BTraceRuntime.getCurrentThreadCpuTime();
    }

    public static long currentThreadUserTime() {
        return BTraceRuntime.getCurrentThreadUserTime();
    }

    @Deprecated
    public static long getSystemNanoTime() {
        return System.nanoTime();
    }

    public static long sizeof(Object objectToSize) {
        return BTraceRuntime.sizeof(objectToSize);
    }

    public static void dumpHeap(String fileName) {
        BTraceUtils.dumpHeap(fileName, true);
    }

    public static void dumpHeap(String fileName, boolean live) {
        BTraceRuntime.dumpHeap(fileName, live);
    }

    public static void gc() {
        System.gc();
    }

    public static void runFinalization() {
        System.runFinalization();
    }

    public static void serialize(Serializable obj, String fileName) {
        BTraceRuntime.serialize(obj, fileName);
    }

    public static String toXML(Object obj) {
        return BTraceRuntime.toXML(obj);
    }

    public static void writeXML(Object obj, String fileName) {
        BTraceRuntime.writeXML(obj, fileName);
    }

    public static int speculation() {
        return BTraceRuntime.speculation();
    }

    public static void speculate(int id) {
        BTraceRuntime.speculate(id);
    }

    public static void commit(int id) {
        BTraceRuntime.commit(id);
    }

    public static void discard(int id) {
        BTraceRuntime.discard(id);
    }

    public static Aggregation newAggregation(AggregationFunction type) {
        return BTraceRuntime.newAggregation(type);
    }

    public static AggregationKey newAggregationKey(Object element1) {
        return BTraceRuntime.newAggregationKey(element1);
    }

    public static AggregationKey newAggregationKey(Object element1, Object element2) {
        return BTraceRuntime.newAggregationKey(element1, element2);
    }

    public static AggregationKey newAggregationKey(Object element1, Object element2, Object element3) {
        return BTraceRuntime.newAggregationKey(element1, element2, element3);
    }

    public static AggregationKey newAggregationKey(Object element1, Object element2, Object element3, Object element4) {
        return BTraceRuntime.newAggregationKey(element1, element2, element3, element4);
    }

    public static void addToAggregation(Aggregation aggregation, long value) {
        BTraceRuntime.addToAggregation(aggregation, value);
    }

    public static void addToAggregation(Aggregation aggregation, AggregationKey key, long value) {
        BTraceRuntime.addToAggregation(aggregation, key, value);
    }

    public static void clearAggregation(Aggregation aggregation) {
        BTraceRuntime.clearAggregation(aggregation);
    }

    public static void truncateAggregation(Aggregation aggregation, int count) {
        BTraceRuntime.truncateAggregation(aggregation, count);
    }

    public static void printAggregation(String name, Aggregation aggregation) {
        BTraceRuntime.printAggregation(name, aggregation);
    }

    private static void checkStatic(Field field) {
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException(field.getName() + " is not a static field");
        }
    }

    private static Field getField(final Class clazz, final String name, final boolean throwError) {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field field = clazz.getDeclaredField(name);
                    field.setAccessible(true);
                    return field;
                }
                catch (Exception exp) {
                    if (throwError) {
                        throw BTraceUtils.translate(exp);
                    }
                    return null;
                }
            }
        });
    }

    private static Field[] getAllFields(final Class clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                try {
                    Field[] fields;
                    for (Field f : fields = clazz.getDeclaredFields()) {
                        f.setAccessible(true);
                    }
                    return fields;
                }
                catch (Exception exp) {
                    throw BTraceUtils.translate(exp);
                }
            }
        });
    }

    private static void addFieldValues(StringBuilder buf, Object obj, Class clazz, boolean classNamePrefix) {
        Field[] fields;
        for (Field f : fields = BTraceUtils.getAllFields(clazz)) {
            int modifiers = f.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            if (classNamePrefix) {
                buf.append(f.getDeclaringClass().getName());
                buf.append('.');
            }
            buf.append(f.getName());
            buf.append('=');
            try {
                buf.append(BTraceUtils.str(f.get(obj)));
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
            buf.append(", ");
        }
        Class sc = clazz.getSuperclass();
        if (sc != null) {
            BTraceUtils.addFieldValues(buf, obj, sc, classNamePrefix);
        }
    }

    private static void addStaticFieldValues(StringBuilder buf, Class clazz, boolean classNamePrefix) {
        Field[] fields;
        for (Field f : fields = BTraceUtils.getAllFields(clazz)) {
            int modifiers = f.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            if (classNamePrefix) {
                buf.append(f.getDeclaringClass().getName());
                buf.append('.');
            }
            buf.append(f.getName());
            buf.append('=');
            try {
                buf.append(BTraceUtils.str(f.get(null)));
            }
            catch (Exception exp) {
                throw BTraceUtils.translate(exp);
            }
            buf.append(", ");
        }
        Class sc = clazz.getSuperclass();
        if (sc != null) {
            BTraceUtils.addStaticFieldValues(buf, sc, classNamePrefix);
        }
    }

    private static RuntimeException translate(Exception exp) {
        if (exp instanceof RuntimeException) {
            return (RuntimeException)exp;
        }
        return new RuntimeException(exp);
    }
}

