/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.transaction.JavaEETransactionImpl;
import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.api.TransactionImport;
import java.rmi.RemoteException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.Xid;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class TransactionManagerHelper
implements TransactionManager,
TransactionImport {
    @Inject
    private transient JavaEETransactionManager transactionManager;
    @Inject
    private transient InvocationManager invocationManager;

    public void begin() throws NotSupportedException, SystemException {
        this.transactionManager.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.transactionManager.commit();
    }

    public int getStatus() throws SystemException {
        return this.transactionManager.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.transactionManager.getTransaction();
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.transactionManager.resume(tobj);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.transactionManager.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.transactionManager.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.transactionManager.setTransactionTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        return this.transactionManager.suspend();
    }

    public void recreate(Xid xid, long timeout) {
        JavaEETransactionManager tm = this.transactionManager;
        try {
            tm.recreate(xid, timeout);
        }
        catch (WorkException ex) {
            throw new IllegalStateException(ex);
        }
        this.servletPreInvokeTx();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release(Xid xid) {
        Object rethrow = null;
        JavaEETransactionManager tm = this.transactionManager;
        this.servletPostInvokeTx(false);
        try {
            try {
                tm.release(xid);
            }
            catch (WorkException ex) {
                throw new IllegalStateException(ex);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (tm instanceof JavaEETransactionManagerSimplified) {
                ((JavaEETransactionManagerSimplified)tm).clearThreadTx();
            }
            if (rethrow != null) {
                throw rethrow;
            }
            throw throwable;
        }
        if (tm instanceof JavaEETransactionManagerSimplified) {
            ((JavaEETransactionManagerSimplified)tm).clearThreadTx();
        }
        if (rethrow != null) {
            throw rethrow;
        }
    }

    public XATerminator getXATerminator() {
        return this.transactionManager.getXATerminator();
    }

    public void servletPreInvokeTx() {
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv != null && inv.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION) {
            try {
                this.transactionManager.enlistComponentResources();
            }
            catch (RemoteException re) {
                throw new IllegalStateException(re);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void servletPostInvokeTx(boolean suspend) {
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv == null) return;
        if (inv.getInvocationType() != ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION) return;
        try {
            try {
                this.transactionManager.delistComponentResources(suspend);
            }
            catch (RemoteException re) {
                throw new IllegalStateException(re);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            inv.setTransaction(null);
            throw throwable;
        }
        inv.setTransaction(null);
    }

    public int getTransactionRemainingTimeout() throws SystemException {
        int timeout = 0;
        Transaction txn = this.getTransaction();
        if (txn == null) {
            throw new IllegalStateException("no current transaction");
        }
        if (txn instanceof JavaEETransactionImpl) {
            timeout = ((JavaEETransactionImpl)((Object)txn)).getRemainingTimeout();
        }
        return timeout;
    }
}

