/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.transaction.TransactionManagerHelper;
import com.sun.enterprise.transaction.TransactionSynchronizationRegistryImpl;
import com.sun.enterprise.transaction.UserTransactionImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.api.naming.NamingObjectsProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class TransactionNamingProxy
implements NamedNamingObjectProxy,
NamingObjectsProvider,
PostConstruct {
    @Inject
    private Habitat habitat;
    @Inject
    private GlassfishNamingManager namingManager;
    @Inject
    private ProcessEnvironment processEnv;
    private static Logger logger = LogDomains.getLogger(TransactionNamingProxy.class, (String)"javax.enterprise.resource.jta");
    private static final String USER_TX = "java:comp/UserTransaction";
    private static final String USER_TX_NO_JAVA_COMP = "UserTransaction";
    private static final String TRANSACTION_SYNC_REGISTRY = "java:comp/TransactionSynchronizationRegistry";
    private static final String TRANSACTION_MGR = "java:pm/TransactionManager";
    private static final String APPSERVER_TRANSACTION_MGR = "java:appserver/TransactionManager";

    public void postConstruct() {
        if (this.processEnv.getProcessType().isServer()) {
            try {
                this.namingManager.publishObject(USER_TX_NO_JAVA_COMP, (Object)new UserTransactionProxy(), true);
            }
            catch (NamingException e) {
                logger.warning("Can't bind \"UserTransaction\" in JNDI");
            }
        }
    }

    public Object handle(String name) throws NamingException {
        if (USER_TX.equals(name)) {
            return this.habitat.getComponent(UserTransactionImpl.class);
        }
        if (TRANSACTION_SYNC_REGISTRY.equals(name)) {
            return this.habitat.getComponent(TransactionSynchronizationRegistryImpl.class);
        }
        if (APPSERVER_TRANSACTION_MGR.equals(name)) {
            return this.habitat.getComponent(TransactionManagerHelper.class);
        }
        return null;
    }

    private class UserTransactionProxy
    implements NamingObjectProxy {
        private UserTransactionProxy() {
        }

        public Object create(Context ic) throws NamingException {
            return TransactionNamingProxy.this.habitat.getComponent(UserTransactionImpl.class);
        }
    }
}

