/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModulesRegistry;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.monitor.StatsProviderManagerDelegateImpl;
import org.glassfish.admin.monitor.StatsProviderRegistry;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.monitoring.ContainerMonitoring;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.glassfish.internal.api.Init;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@Scoped(value=Singleton.class)
public class MonitoringBootstrap
implements Init,
PostConstruct,
PreDestroy,
EventListener,
ModuleLifecycleListener,
ConfigListener {
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    private Domain domain;
    @Inject
    ModulesRegistry registry;
    @Inject
    protected ProbeProviderFactory probeProviderFactory;
    @Inject
    protected ProbeClientMediator pcm;
    @Inject
    Events events;
    @Inject(optional=true)
    MonitoringService monitoringService = null;
    @Inject
    private ProbeRegistry probeRegistry;
    Map<String, Module> map = Collections.synchronizedMap(new WeakHashMap());
    private static final String INSTALL_ROOT_URI_PROPERTY_NAME = "com.sun.aas.installRootURI";
    private final String PROBE_PROVIDER_CLASS_NAMES = "probe-provider-class-names";
    private final String PROBE_PROVIDER_XML_FILE_NAMES = "probe-provider-xml-file-names";
    private final String DELIMITER = ",";
    private StatsProviderManagerDelegateImpl spmd;
    private boolean ddebug = false;
    private boolean monitoringEnabled;
    private boolean hasDiscoveredXMLProviders = false;

    public void postConstruct() {
        this.monitoringEnabled = this.monitoringService != null ? Boolean.parseBoolean(this.monitoringService.getMonitoringEnabled()) : false;
        if (!this.monitoringEnabled) {
            return;
        }
        this.events.register((EventListener)this);
        boolean isDiscoverXMLProbeProviders = false;
        this.enableMonitoringForProbeProviders(isDiscoverXMLProbeProviders);
    }

    private void discoverProbeProviders() {
        for (Module m : this.registry.getModules()) {
            this.moduleStarted(m);
        }
    }

    public void preDestroy() {
        ProbeRegistry.cleanup();
        if (this.spmd != null) {
            this.spmd = new StatsProviderManagerDelegateImpl(this.pcm, this.probeRegistry, this.mrdr, this.domain, this.monitoringService);
            StatsProviderManager.setStatsProviderManagerDelegate(this.spmd);
        }
    }

    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.discoverXMLProviders();
        }
    }

    public void setStatsProviderManagerDelegate() {
        if (this.spmd != null) {
            return;
        }
        this.spmd = new StatsProviderManagerDelegateImpl(this.pcm, this.probeRegistry, this.mrdr, this.domain, this.monitoringService);
        StatsProviderManager.setStatsProviderManagerDelegate(this.spmd);
        this.printd(" StatsProviderManagerDelegate is assigned ********************");
        AMXGlassfish amxg = AMXGlassfish.DEFAULT;
        amxg.listenForDomainRoot(ManagementFactory.getPlatformMBeanServer(), this.spmd);
    }

    public void moduleResolved(Module module) {
        this.printd(" In module resolved, but not registering, module = " + module.getName());
    }

    public synchronized void moduleStarted(Module module) {
        if (module == null) {
            return;
        }
        String str = module.getName();
        if (!this.map.containsKey(str)) {
            this.map.put(str, module);
            this.addProvider(module);
        }
    }

    public synchronized void moduleStopped(Module module) {
        if (module == null) {
            return;
        }
        String str = module.getName();
    }

    private void addProvider(Module module) {
        String mname = module.getName();
        ClassLoader mcl = module.getClassLoader();
        ModuleDefinition md = module.getModuleDefinition();
        Manifest mf = null;
        if (md != null) {
            mf = md.getManifest();
        }
        if (mf != null) {
            Attributes attrs = mf.getMainAttributes();
            String cnames = null;
            String xnames = null;
            if (attrs != null) {
                StringTokenizer st;
                cnames = attrs.getValue("probe-provider-class-names");
                if (cnames != null) {
                    this.printd("**************probe providers = " + cnames);
                }
                if (cnames != null) {
                    st = new StringTokenizer(cnames, ",");
                    while (st.hasMoreTokens()) {
                        try {
                            this.processProbeProviderClass(mcl.loadClass(st.nextToken()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if ((xnames = attrs.getValue("probe-provider-xml-file-names")) != null) {
                    this.printd("xnames = " + xnames);
                    st = new StringTokenizer(xnames, ",");
                    while (st.hasMoreTokens()) {
                        this.processProbeProviderXML(mcl, st.nextToken(), true);
                    }
                }
            }
        }
    }

    private void discoverXMLProviders() {
        if (this.hasDiscoveredXMLProviders) {
            return;
        }
        try {
            URI xmlProviderDirStr = new URI(System.getProperty(INSTALL_ROOT_URI_PROPERTY_NAME) + "/" + "lib" + "/" + "monitor");
            this.printd("ProviderXML's Dir = " + xmlProviderDirStr.getPath());
            File xmlProviderDir = new File(xmlProviderDirStr.getPath());
            this.printd("ProviderXML's Dir exists = " + xmlProviderDir.exists());
            this.printd("ProviderXML's Dir path - " + xmlProviderDir.getAbsolutePath());
            this.loadXMLProviders(xmlProviderDir);
            this.hasDiscoveredXMLProviders = true;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadXMLProviders(File xmlProvidersDir) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        File[] files = xmlProvidersDir.listFiles(filter);
        if (files == null) {
            return;
        }
        HashMap<String, File> providerMap = new HashMap<String, File>();
        for (File file : files) {
            this.printd("Found the provider xml - " + file.getAbsolutePath());
            int index = file.getName().indexOf("-:");
            if (index == -1) continue;
            String moduleName = file.getName().substring(0, index);
            providerMap.put(moduleName, file);
            this.printd(" The provider xml belongs to - \"" + moduleName + "\"");
            for (Module module : this.map.values()) {
                if (!module.getName().contains("grizzly")) continue;
                this.printd(" module = \"" + module.getName() + "\"");
            }
            if (!this.map.containsKey(moduleName)) {
                Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, "Couldn't find the module, when loading the monitoring providers from XML directory : " + moduleName);
                continue;
            }
            this.printd(" Module found (containsKey)");
            Module module = this.map.get(moduleName);
            if (module == null) {
                Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, "Couldn't find the module, when loading the monitoring providers from XML directory : " + moduleName);
                continue;
            }
            ClassLoader mcl = module.getClassLoader();
            this.printd("ModuleClassLoader = " + mcl);
            this.printd("XML File path = " + file.getAbsolutePath());
            this.processProbeProviderXML(mcl, file.getAbsolutePath(), false);
        }
    }

    private void removeProvider(Module module) {
        this.printd("removeProvider ...");
    }

    private void processProbeProviderClass(Class cls) {
        this.printd("processProbeProviderClass for " + cls);
        try {
            this.probeProviderFactory.getProbeProvider(cls);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void processProbeProviderXML(ClassLoader mcl, String xname, boolean inBundle) {
        this.probeProviderFactory.processXMLProbeProviders(mcl, xname, inBundle);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        this.printd(" spmd = " + this.spmd);
        StatsProviderRegistry spr = this.spmd == null ? null : this.spmd.getStatsProviderRegistry();
        this.printd("spr = " + spr);
        for (PropertyChangeEvent event : propertyChangeEvents) {
            boolean oldEnabled;
            boolean newEnabled;
            if (event == null) continue;
            String propName = event.getPropertyName();
            Object oldVal = event.getOldValue();
            Object newVal = event.getNewValue();
            if (newVal == null || newVal.equals(oldVal) || !this.ok(propName)) continue;
            if (event.getSource() instanceof ModuleMonitoringLevels) {
                this.printd("Event received from " + event.getSource().getClass().getName() + " New Level = " + newVal + " Old Level=" + oldVal);
                newEnabled = this.parseLevelsBoolean(newVal.toString());
                boolean bl = oldVal == null ? !newEnabled : (oldEnabled = this.parseLevelsBoolean(oldVal.toString()));
                if (newEnabled == oldEnabled || spr == null) continue;
                this.handleLevelChange(propName, newEnabled);
                continue;
            }
            if (event.getSource() instanceof ContainerMonitoring) {
                boolean oldEnabled2;
                ContainerMonitoring cm = (ContainerMonitoring)event.getSource();
                boolean newEnabled2 = this.parseLevelsBoolean(newVal.toString());
                boolean bl = oldVal == null ? !newEnabled2 : (oldEnabled2 = this.parseLevelsBoolean(oldVal.toString()));
                if (newEnabled2 == oldEnabled2 || spr == null) continue;
                this.handleLevelChange(cm.getName(), newEnabled2);
                continue;
            }
            if (!(event.getSource() instanceof MonitoringService)) continue;
            newEnabled = Boolean.parseBoolean(newVal.toString());
            boolean bl = oldVal == null ? !newEnabled : (oldEnabled = Boolean.parseBoolean(oldVal.toString()));
            if (newEnabled == oldEnabled) continue;
            this.handleServiceChange(spr, propName, newEnabled);
        }
        return null;
    }

    private void handleLevelChange(String propName, boolean enabled) {
        this.printd("In handleLevelChange(), spmd = " + this.spmd + "  Enabled=" + enabled);
        if (!this.ok(propName)) {
            return;
        }
        if (this.spmd == null) {
            return;
        }
        if (enabled) {
            this.spmd.enableStatsProviders(propName);
        } else {
            this.spmd.disableStatsProviders(propName);
        }
    }

    private void handleServiceChange(StatsProviderRegistry spr, String propName, boolean enabled) {
        if (!this.ok(propName)) {
            return;
        }
        if (propName.equals("mbean-enabled")) {
            if (spr == null) {
                return;
            }
            if (enabled) {
                this.spmd.registerAllGmbal();
            } else {
                this.spmd.unregisterAllGmbal();
            }
        } else if (propName.equals("dtrace-enabled")) {
            this.probeProviderFactory.dtraceEnabledChanged(enabled);
        } else if (propName.equals("monitoring-enabled")) {
            this.probeProviderFactory.monitoringEnabledChanged(enabled);
            if (enabled) {
                this.enableMonitoringForProbeProviders(true);
                this.spmd.updateAllStatsProviders();
            } else {
                this.disableMonitoringForProbeProviders();
                this.spmd.disableAllStatsProviders();
            }
        }
    }

    private void enableMonitoringForProbeProviders(boolean isDiscoverXMLProviders) {
        this.discoverProbeProviders();
        this.registry.register((ModuleLifecycleListener)this);
        if (isDiscoverXMLProviders) {
            this.discoverXMLProviders();
        }
        this.setStatsProviderManagerDelegate();
    }

    private void disableMonitoringForProbeProviders() {
        this.registry.unregister((ModuleLifecycleListener)this);
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private boolean parseLevelsBoolean(String s) {
        return !this.ok(s) || !s.equals("OFF");
    }

    private void printd(String pstring) {
        if (this.ddebug) {
            System.out.println(" APK : " + pstring);
        }
    }
}

