/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.config.serverbeans.Server;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.monitor.StatsProviderRegistry;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.amx.MBeanListener;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManagerDelegate;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.gmbal.ManagedObjectManagerFactory;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scoped(value=Singleton.class)
public class StatsProviderManagerDelegateImpl
extends MBeanListener.CallbackImpl
implements StatsProviderManagerDelegate {
    protected ProbeClientMediator pcm;
    MonitoringService monitoringService = null;
    private final MonitoringRuntimeDataRegistry mrdr;
    private final ProbeRegistry probeRegistry;
    private final Domain domain;
    private final TreeNode serverNode;
    private static final ObjectName MONITORING_ROOT = AMXGlassfish.DEFAULT.monitoringRoot();
    static final ObjectName MONITORING_SERVER = AMXGlassfish.DEFAULT.serverMon(AMXGlassfish.DEFAULT.dasName());
    private static final String DOMAIN = MONITORING_SERVER.getDomain();
    private static final String PP = MONITORING_SERVER.getKeyProperty("pp");
    private static final String TYPE = MONITORING_SERVER.getKeyProperty("type");
    private static final String NAME = MONITORING_SERVER.getKeyProperty("name");
    private static final String PARENT_PATH = PP + "/" + TYPE + "[" + NAME + "]";
    private static final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private boolean AMXReady = false;
    private StatsProviderRegistry statsProviderRegistry;
    boolean ddebug = false;

    StatsProviderManagerDelegateImpl(ProbeClientMediator pcm, ProbeRegistry probeRegistry, MonitoringRuntimeDataRegistry mrdr, Domain domain, MonitoringService monitoringService) {
        this.pcm = pcm;
        this.mrdr = mrdr;
        this.domain = domain;
        this.monitoringService = monitoringService;
        this.probeRegistry = probeRegistry;
        this.serverNode = this.constructServerPP();
        this.statsProviderRegistry = new StatsProviderRegistry(mrdr);
    }

    @Override
    public void register(String configElement, PluginPoint pp, String subTreePath, Object statsProvider) {
        StatsProviderRegistry.StatsProviderRegistryElement spre;
        this.printd("registering a statsProvider ");
        if (this.getMonitoringEnabled() && this.getEnabledValue(configElement)) {
            this.printd(" enabled is true ");
            spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
            if (spre == null) {
                this.statsProviderRegistry.registerStatsProvider(configElement, pp, subTreePath, null, null, null, statsProvider, subTreePath, null);
                spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
            }
            this.enableStatsProvider(spre);
        } else {
            this.printd(" enabled is false ");
            this.statsProviderRegistry.registerStatsProvider(configElement, pp, subTreePath, null, null, null, statsProvider, subTreePath, null);
            spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
        }
        this.printd(spre.toString());
        this.printd("=========================================================");
    }

    @Override
    public void unregister(Object statsProvider) {
        try {
            Collection<ProbeClientMethodHandle> handles;
            List nodeList;
            StatsProviderRegistry.StatsProviderRegistryElement spre = this.statsProviderRegistry.getStatsProviderRegistryElement(statsProvider);
            if (spre == null) {
                throw new Exception("Invalid statsProvider, cannot unregister");
            }
            String parentNodePath = spre.getParentTreeNodePath();
            List<String> childNodeNames = spre.getChildTreeNodeNames();
            TreeNode rootNode = this.mrdr.get("server");
            if (rootNode != null && parentNodePath != null && (nodeList = rootNode.getNodes(parentNodePath, false, true)).size() > 0) {
                TreeNode parentNode = (TreeNode)nodeList.get(0);
                Collection childNodes = parentNode.getChildNodes();
                for (TreeNode childNode : childNodes) {
                    if (!childNodeNames.contains(childNode.getName())) continue;
                    parentNode.removeChild(childNode);
                }
                if (!parentNode.hasChildNodes()) {
                    this.removeParentNode(parentNode);
                }
            }
            if ((handles = spre.getHandles()) != null) {
                for (ProbeClientMethodHandle handle : handles) {
                    handle.disable();
                }
            }
            if (spre.getManagedObjectManager() != null) {
                this.unregisterGmbal(spre);
            }
            this.statsProviderRegistry.unregisterStatsProvider(statsProvider);
        }
        catch (Exception ex) {
            Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void removeParentNode(TreeNode parentNode) {
        TreeNode superParentNode = parentNode.getParent();
        if (superParentNode != null) {
            superParentNode.removeChild(parentNode);
            if (!superParentNode.hasChildNodes()) {
                this.removeParentNode(superParentNode);
            }
        }
    }

    public void updateAllStatsProviders() {
        for (String configElement : this.statsProviderRegistry.getConfigElementList()) {
            List<StatsProviderRegistry.StatsProviderRegistryElement> spreList = this.statsProviderRegistry.getStatsProviderRegistryElement(configElement);
            for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
                boolean isConfigEnabled = this.getEnabledValue(configElement);
                if (isConfigEnabled == spre.isEnabled) continue;
                if (isConfigEnabled) {
                    this.enableStatsProvider(spre);
                    continue;
                }
                this.disableStatsProvider(spre);
            }
        }
    }

    public void disableAllStatsProviders() {
        for (String configElement : this.statsProviderRegistry.getConfigElementList()) {
            List<StatsProviderRegistry.StatsProviderRegistryElement> spreList = this.statsProviderRegistry.getStatsProviderRegistryElement(configElement);
            for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
                if (!spre.isEnabled) continue;
                this.disableStatsProvider(spre);
            }
        }
    }

    public void enableStatsProviders(String configElement) {
        if (!this.getMonitoringEnabled()) {
            return;
        }
        this.printd("Enabling all the statsProviders for - " + configElement);
        List<StatsProviderRegistry.StatsProviderRegistryElement> spreList = this.statsProviderRegistry.getStatsProviderRegistryElement(configElement);
        if (spreList == null) {
            return;
        }
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
            if (spre.isEnabled()) continue;
            this.enableStatsProvider(spre);
        }
    }

    public void disableStatsProviders(String configElement) {
        this.printd("Disabling all the statsProviders for - " + configElement);
        List<StatsProviderRegistry.StatsProviderRegistryElement> spreList = this.statsProviderRegistry.getStatsProviderRegistryElement(configElement);
        if (spreList == null) {
            return;
        }
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
            if (!spre.isEnabled()) continue;
            this.disableStatsProvider(spre);
        }
    }

    private boolean getMonitoringEnabled() {
        return Boolean.parseBoolean(this.monitoringService.getMonitoringEnabled());
    }

    private void enableStatsProvider(StatsProviderRegistry.StatsProviderRegistryElement spre) {
        String subTreePath;
        Object statsProvider = spre.getStatsProvider();
        this.printd("Enabling the statsProvider - " + statsProvider.getClass().getName());
        if (spre.getParentTreeNodePath() == null) {
            PluginPoint pp = spre.getPluginPoint();
            subTreePath = spre.getSubTreePath();
            TreeNode ppNode = this.getPluginPointNode(pp, this.serverNode);
            TreeNode parentNode = this.createSubTree(ppNode, subTreePath);
            List<String> childNodeNames = this.createTreeForStatsProvider(parentNode, statsProvider);
            spre.setParentTreeNodePath(parentNode.getCompletePathName());
            spre.setChildNodeNames(childNodeNames);
        } else {
            this.updateTreeNodes(spre, true);
        }
        if (spre.getHandles() == null) {
            Collection<ProbeClientMethodHandle> handles = this.registerStatsProviderToFlashlight(statsProvider);
            spre.setHandles(handles);
        } else {
            for (ProbeClientMethodHandle handle : spre.getHandles()) {
                if (handle.isEnabled()) continue;
                handle.enable();
            }
        }
        ManagedObjectManager mom = null;
        if (this.AMXReady && this.getMbeanEnabledValue()) {
            subTreePath = spre.getSubTreePath();
            mom = this.registerGmbal(statsProvider, subTreePath);
            spre.setManagedObjectManager(mom);
        }
        String configElement = spre.getConfigStr();
        spre.setEnabled(true);
    }

    private void disableStatsProvider(StatsProviderRegistry.StatsProviderRegistryElement spre) {
        this.printd("Disabling the statsProvider - " + spre.getStatsProvider().getClass().getName());
        this.updateTreeNodes(spre, false);
        for (ProbeClientMethodHandle handle : spre.getHandles()) {
            if (handle.isEnabled()) continue;
            handle.disable();
        }
        this.unregisterGmbal(spre);
        spre.setEnabled(false);
    }

    public void registerAllGmbal() {
        this.printd("Registering all the statsProviders whose enabled flag is 'on' with Gmbal");
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : this.statsProviderRegistry.getSpreList()) {
            if (!spre.isEnabled()) continue;
            ManagedObjectManager mom = this.registerGmbal(spre.getStatsProvider(), spre.getMBeanName());
            spre.setManagedObjectManager(mom);
        }
    }

    public void unregisterAllGmbal() {
        this.printd("Unregistering all the statsProviders whose enabled flag is 'off' with Gmbal");
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : this.statsProviderRegistry.getSpreList()) {
            if (!spre.isEnabled()) continue;
            this.unregisterGmbal(spre);
        }
    }

    private void updateTreeNodes(StatsProviderRegistry.StatsProviderRegistryElement spre, boolean enable) {
        String parentNodePath = spre.getParentTreeNodePath();
        List<String> childNodeNames = spre.getChildTreeNodeNames();
        TreeNode rootNode = this.mrdr.get("server");
        if (rootNode != null) {
            List nodeList = rootNode.getNodes(parentNodePath, false, true);
            TreeNode parentNode = (TreeNode)nodeList.get(0);
            Collection childNodes = parentNode.getChildNodes();
            boolean hasUpdatedNode = false;
            for (TreeNode childNode : childNodes) {
                if (!childNodeNames.contains(childNode.getName()) || childNode.isEnabled() == enable) continue;
                this.printd((enable ? "En" : "Dis") + "abling the child node - " + childNode.getCompletePathName());
                childNode.setEnabled(enable);
                hasUpdatedNode = true;
            }
            if (!hasUpdatedNode) {
                return;
            }
            if (enable) {
                this.enableTreeNode(parentNode);
            } else {
                this.disableTreeNode(parentNode);
            }
        }
    }

    private void enableTreeNode(TreeNode treeNode) {
        if (!treeNode.isEnabled()) {
            treeNode.setEnabled(true);
            if (treeNode.getParent() != null) {
                this.enableTreeNode(treeNode.getParent());
            }
        }
    }

    private void disableTreeNode(TreeNode treeNode) {
        if (treeNode.isEnabled()) {
            boolean isAnyChildEnabled = false;
            Collection childNodes = treeNode.getChildNodes();
            this.printd("Parent Node = " + treeNode.getName() + "  childNodes.size()=" + childNodes.size());
            if (childNodes != null) {
                for (TreeNode childNode : childNodes) {
                    if (!childNode.isEnabled()) continue;
                    isAnyChildEnabled = true;
                    break;
                }
            }
            if (!isAnyChildEnabled) {
                treeNode.setEnabled(false);
                if (treeNode.getParent() != null) {
                    this.disableTreeNode(treeNode.getParent());
                }
            }
        }
    }

    private List<String> createTreeForStatsProvider(TreeNode parentNode, Object statsProvider) {
        ArrayList<String> childNodeNames = new ArrayList<String>();
        for (Method m : statsProvider.getClass().getDeclaredMethods()) {
            String methodNameLower;
            ManagedAttribute ma = m.getAnnotation(ManagedAttribute.class);
            if (ma == null) continue;
            String methodName = m.getName();
            String id = ma.id();
            if ((id == null || id.isEmpty()) && (methodNameLower = methodName.toLowerCase()).startsWith("get") && methodNameLower.length() > 3) {
                id = methodNameLower.substring(3);
            }
            TreeNode attrNode = TreeNodeFactory.createMethodInvoker(id, statsProvider, id, m);
            parentNode.addChild(attrNode);
            childNodeNames.add(attrNode.getName());
        }
        return childNodeNames;
    }

    private Collection<ProbeClientMethodHandle> registerStatsProviderToFlashlight(Object statsProvider) {
        Collection handles = null;
        try {
            handles = this.pcm.registerListener(statsProvider);
        }
        catch (Exception e) {
            Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.SEVERE, "flashlight registration failed", e);
        }
        return handles;
    }

    private TreeNode createSubTree(TreeNode parent, String subTreePath) {
        StringTokenizer st = new StringTokenizer(subTreePath, "/");
        TreeNode parentNode = parent;
        while (st.hasMoreTokens()) {
            TreeNode subTreeNode;
            parentNode = subTreeNode = this.createSubTreeNode(parentNode, st.nextToken());
        }
        return parentNode;
    }

    private TreeNode createSubTreeNode(TreeNode parent, String child) {
        TreeNode childNode = parent.getNode(child);
        if (childNode == null) {
            childNode = TreeNodeFactory.createTreeNode(child, null, child);
            parent.addChild(childNode);
        }
        return childNode;
    }

    @Override
    public boolean hasListeners(String probeStr) {
        boolean hasListeners = false;
        FlashlightProbe probe = this.probeRegistry.getProbe(probeStr);
        if (probe != null) {
            return probe.isEnabled();
        }
        return hasListeners;
    }

    @Override
    public void mbeanRegistered(ObjectName objectName, MBeanListener listener) {
        super.mbeanRegistered(objectName, listener);
        this.AMXReady = true;
        this.statsProviderRegistry.setAMXReady(true);
        if (this.getMbeanEnabledValue()) {
            for (StatsProviderRegistry.StatsProviderRegistryElement spre : this.statsProviderRegistry.getSpreList()) {
                if (!spre.isEnabled()) continue;
                ManagedObjectManager mom = this.registerGmbal(spre.getStatsProvider(), spre.getMBeanName());
                spre.setManagedObjectManager(mom);
            }
        }
    }

    StatsProviderRegistry getStatsProviderRegistry() {
        return this.statsProviderRegistry;
    }

    private ManagedObjectManager registerGmbal(Object statsProvider, String mbeanName) {
        ManagedObjectManager mom = null;
        try {
            mom = ManagedObjectManagerFactory.createFederated(MONITORING_SERVER);
            if (mom != null) {
                mom.stripPackagePrefix();
                if (mbeanName != null && !mbeanName.isEmpty()) {
                    mom.createRoot(statsProvider, mbeanName);
                } else {
                    mom.createRoot(statsProvider);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.SEVERE, "gmbal registration failed", e);
        }
        return mom;
    }

    private void unregisterGmbal(StatsProviderRegistry.StatsProviderRegistryElement spre) {
        ManagedObjectManager mom = spre.getManagedObjectManager();
        if (mom != null) {
            mom.unregister(spre.getStatsProvider());
            try {
                mom.close();
            }
            catch (IOException ioe) {
                Logger.getLogger(StatsProviderRegistry.class.getName()).log(Level.SEVERE, null, ioe);
            }
            spre.setManagedObjectManager(null);
        }
    }

    private TreeNode getPluginPointNode(PluginPoint pp, TreeNode serverNode) {
        if (pp.getName().equals(serverNode.getName())) {
            return serverNode;
        }
        String subTreePath = pp.getPath();
        if (subTreePath.startsWith("server")) {
            subTreePath = subTreePath.substring(subTreePath.indexOf("/") + 1, subTreePath.length());
        }
        return this.createSubTree(serverNode, subTreePath);
    }

    private TreeNode constructServerPP() {
        TreeNode srvrNode = this.mrdr.get("server");
        if (srvrNode != null) {
            return srvrNode;
        }
        Server srvr = null;
        List ls = this.domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            srvr = sr;
            break;
        }
        srvrNode = TreeNodeFactory.createTreeNode("server", null, "server");
        this.mrdr.add("server", srvrNode);
        return srvrNode;
    }

    private boolean getEnabledValue(String configElement) {
        boolean enabled = false;
        String level = this.monitoringService.getMonitoringLevel(configElement);
        if (level != null) {
            if (level.equals("HIGH") || level.equals("LOW")) {
                enabled = true;
            }
        } else {
            Logger.getLogger(StatsProviderManagerDelegateImpl.class.getName()).log(Level.WARNING, "module-monitoring-level or container-monitoring config element for " + configElement + " does not exist.");
        }
        return enabled;
    }

    private boolean getMbeanEnabledValue() {
        return Boolean.parseBoolean(this.monitoringService.getMbeanEnabled());
    }

    public boolean isStatsProviderRegistered(Object statsProvider, String subTreePath) {
        boolean isStatsProviderRegistered = false;
        Collection<StatsProviderRegistry.StatsProviderRegistryElement> spreList = this.statsProviderRegistry.getSpreList();
        for (StatsProviderRegistry.StatsProviderRegistryElement spre : spreList) {
            if (!spre.getStatsProvider().equals(statsProvider) || !spre.getMBeanName().equals(statsProvider)) continue;
            isStatsProviderRegistered = true;
        }
        return isStatsProviderRegistered;
    }

    public boolean isMBeanRegistered(Object statsProvider, String subTreePath) {
        return this.isMBeanRegistered(this.getObjectName(statsProvider, subTreePath));
    }

    public boolean isMBeanRegistered(ObjectName objectName) {
        return mbeanServer.isRegistered(objectName);
    }

    public ObjectName getObjectName(Object statsProvider, String subTreePath) {
        String typeValue = this.getTypeValue(statsProvider);
        String nameValue = this.getNameValue(subTreePath);
        return AMXGlassfish.DEFAULT.newObjectName(PARENT_PATH, typeValue, nameValue);
    }

    public String getTypeValue(Object statsProvider) {
        return statsProvider.getClass().getSimpleName();
    }

    public String getNameValue(String subTreePath) {
        return subTreePath;
    }

    private void printd(String str) {
        if (this.ddebug) {
            System.out.println("APK : " + str);
        }
    }
}

