/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="version")
@Scoped(value=PerLookup.class)
public class VersionCommand
extends CLICommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(VersionCommand.class);

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        VersionCommand.addOption(opts, "verbose", 'v', "BOOLEAN", false, "false");
        VersionCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 0;
        this.processProgramOptions();
    }

    protected int executeCommand() throws CommandException {
        try {
            RemoteCommand cmd = new RemoteCommand("version", this.programOpts, this.env);
            String version = this.getBooleanOption("verbose") ? cmd.executeAndReturnOutput("version", "--verbose") : cmd.executeAndReturnOutput("version");
            logger.printMessage(strings.get("version.remote", new Object[]{version}));
        }
        catch (Exception e) {
            this.printRemoteException(e);
            this.invokeLocal();
        }
        return 0;
    }

    private void invokeLocal() {
        logger.printMessage(strings.get("version.local", new Object[]{Version.getFullVersion()}));
        if (this.getBooleanOption("verbose")) {
            logger.printMessage(strings.get("version.local.java", new Object[]{System.getProperty("java.version")}));
        }
    }

    private void printRemoteException(Exception e) {
        if (CLIConstants.debug()) {
            logger.printMessage(strings.get("remote.version.failed.debug", new Object[]{this.programOpts.getHost(), this.programOpts.getPort() + ""}));
        } else {
            logger.printMessage(strings.get("remote.version.failed.non-debug", new Object[]{this.programOpts.getHost(), this.programOpts.getPort() + ""}));
        }
        logger.printDebugMessage(e.getMessage());
    }
}

