/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.UnproxyableResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.DeploymentException;
import org.jboss.webbeans.InconsistentSpecializationException;
import org.jboss.webbeans.NullableDependencyException;
import org.jboss.webbeans.UnserializableDependencyException;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.AbstractProducerBean;
import org.jboss.webbeans.bean.DecoratorBean;
import org.jboss.webbeans.bean.DisposalMethodBean;
import org.jboss.webbeans.bean.NewEnterpriseBean;
import org.jboss.webbeans.bean.NewSimpleBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.bootstrap.api.Service;
import org.jboss.webbeans.introspector.WBAnnotated;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;
import org.jboss.webbeans.resolution.ResolvableWBClass;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Proxies;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator
implements Service {
    private void validateBean(Bean<?> bean, BeanManagerImpl beanManager) {
        for (InjectionPoint ij : bean.getInjectionPoints()) {
            this.validateInjectionPoint(ij, beanManager);
        }
        boolean normalScoped = beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isNormal();
        if (normalScoped && !Beans.isBeanProxyable(bean)) {
            throw new UnproxyableResolutionException("Normal scoped bean " + bean + " is not proxyable");
        }
    }

    private void validateRIBean(RIBean<?> bean, BeanManagerImpl beanManager, Collection<RIBean<?>> specializedBeans) {
        this.validateBean(bean, beanManager);
        if (!(bean instanceof NewSimpleBean) && !(bean instanceof NewEnterpriseBean)) {
            AbstractClassBean classBean;
            RIBean<?> abstractBean = bean;
            if (abstractBean.isSpecializing()) {
                if (specializedBeans.contains(abstractBean.getSpecializedBean())) {
                    throw new InconsistentSpecializationException("Two beans cannot specialize the same bean: " + bean);
                }
                specializedBeans.add(abstractBean.getSpecializedBean());
            }
            if (Beans.isPassivationCapableBean(bean) && bean instanceof AbstractClassBean && (classBean = (AbstractClassBean)bean).hasDecorators()) {
                for (Decorator<?> decorator : classBean.getDecorators()) {
                    if (!Reflections.isSerializable(decorator.getBeanClass())) {
                        throw new UnserializableDependencyException("The bean " + bean + " declares a passivating scope but has non-serializable decorator: " + decorator);
                    }
                    for (InjectionPoint ij : decorator.getInjectionPoints()) {
                        Bean resolvedBean = beanManager.resolve(beanManager.getInjectableBeans(ij));
                        this.validateInjectionPointPassivationCapable(ij, resolvedBean, beanManager);
                    }
                }
            }
        }
    }

    public void validateInjectionPoint(InjectionPoint ij, BeanManagerImpl beanManager) {
        if (ij.getAnnotated().getAnnotation(New.class) != null && ij.getQualifiers().size() > 1) {
            throw new DefinitionException("The injection point " + ij + " is annotated with @New which cannot be combined with other binding types");
        }
        if (ij.getType().equals(InjectionPoint.class) && ij.getBean() == null) {
            throw new DefinitionException("Cannot inject an Injection point into a class which isn't a bean " + ij);
        }
        if (ij.getType().equals(InjectionPoint.class) && !Dependent.class.equals(ij.getBean().getScope())) {
            throw new DefinitionException("Cannot inject an InjectionPoint into a non @Dependent scoped bean " + ij);
        }
        if (ij.getType() instanceof TypeVariable) {
            throw new DefinitionException("Cannot declare an injection point with a type variable " + ij);
        }
        if (ij.getType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)ij.getType();
            for (Type type : parameterizedType.getActualTypeArguments()) {
            }
        }
        Validator.checkFacadeInjectionPoint(ij, Instance.class);
        Validator.checkFacadeInjectionPoint(ij, Event.class);
        Annotation[] bindings = ij.getQualifiers().toArray(new Annotation[0]);
        WBAnnotated annotatedItem = ResolvableWBClass.of(ij.getType(), bindings, beanManager);
        Set resolvedBeans = beanManager.getBeanResolver().resolve(beanManager.getInjectableBeans(ij));
        if (resolvedBeans.isEmpty()) {
            throw new DeploymentException("The injection point " + ij + " with binding types " + Names.annotationsToString(ij.getQualifiers()) + " in " + ij.getBean() + " has unsatisfied dependencies with binding types ");
        }
        if (resolvedBeans.size() > 1) {
            throw new DeploymentException("The injection point " + ij + " with binding types " + Names.annotationsToString(ij.getQualifiers()) + " in " + ij.getBean() + " has ambiguous dependencies " + resolvedBeans);
        }
        Bean resolvedBean = resolvedBeans.iterator().next();
        if (beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(resolvedBean.getScope()).isNormal() && !Proxies.isTypeProxyable(ij.getType())) {
            throw new UnproxyableResolutionException("The injection point " + ij + " has non-proxyable dependencies");
        }
        if (Reflections.isPrimitive(annotatedItem.getJavaClass()) && resolvedBean.isNullable()) {
            throw new NullableDependencyException("The injection point " + ij + " has nullable dependencies");
        }
        if (ij.getBean() != null && Beans.isPassivatingScope(ij.getBean(), beanManager) && !ij.isTransient() && !Beans.isPassivationCapableBean(resolvedBean)) {
            this.validateInjectionPointPassivationCapable(ij, resolvedBean, beanManager);
        }
    }

    public void validateInjectionPointPassivationCapable(InjectionPoint ij, Bean<?> resolvedBean, BeanManagerImpl beanManager) {
        if (!ij.isTransient() && !Beans.isPassivationCapableBean(resolvedBean)) {
            if (resolvedBean.getScope().equals(Dependent.class) && resolvedBean instanceof AbstractProducerBean) {
                throw new IllegalProductException("The bean " + ij.getBean() + " declares a passivating scope but the producer returned a non-serializable bean for injection: " + resolvedBean);
            }
            throw new UnserializableDependencyException("The bean " + ij.getBean() + " declares a passivating scope but has non-serializable dependency: " + resolvedBean);
        }
    }

    public void validateDeployment(BeanManagerImpl manager, BeanDeployerEnvironment environment) {
        this.validateBeans(manager.getDecorators(), new ArrayList(), manager);
        this.validateBeans(manager.getBeans(), new ArrayList(), manager);
        this.validateEnabledDecoratorClasses(manager);
        this.validateEnabledPolicies(manager);
        this.validateDisposalMethods(environment);
        this.validateBeanNames(manager);
    }

    public void validateBeans(Collection<? extends Bean<?>> beans, Collection<RIBean<?>> specializedBeans, BeanManagerImpl manager) {
        for (Bean<?> bean : beans) {
            if (bean instanceof RIBean) {
                this.validateRIBean((RIBean)bean, manager, specializedBeans);
                continue;
            }
            this.validateBean(bean, manager);
        }
    }

    public void validateBeanNames(BeanManagerImpl beanManager) {
        SetMultimap<String, Bean<?>> namedAccessibleBeans = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<Bean<?>>>(){

            @Override
            public Set<Bean<?>> get() {
                return new HashSet();
            }
        });
        for (Bean<?> bean : beanManager.getAccessibleBeans()) {
            if (bean.getName() == null) continue;
            namedAccessibleBeans.put(bean.getName(), bean);
        }
        ArrayList<String> accessibleNamespaces = new ArrayList<String>();
        for (String namespace : beanManager.getAccessibleNamespaces()) {
            accessibleNamespaces.add(namespace);
        }
        for (String name : namedAccessibleBeans.keySet()) {
            Set resolvedBeans = beanManager.getBeanResolver().resolve(namedAccessibleBeans.get(name));
            if (resolvedBeans.size() > 1) {
                throw new DeploymentException("An unresolvable ambiguous EL name exists for " + name + "; found " + resolvedBeans);
            }
            if (!accessibleNamespaces.contains(name)) continue;
            throw new DeploymentException("The bean name " + name + " is used as a prefix for another bean");
        }
    }

    private void validateEnabledDecoratorClasses(BeanManagerImpl beanManager) {
        HashSet decoratorBeanClasses = new HashSet();
        for (DecoratorBean<?> decoratorBean : beanManager.getDecorators()) {
            decoratorBeanClasses.add(decoratorBean.getType());
        }
        for (Class clazz : beanManager.getEnabledDecoratorClasses()) {
            if (beanManager.getEnabledDecoratorClasses().indexOf(clazz) < beanManager.getEnabledDecoratorClasses().lastIndexOf(clazz)) {
                throw new DeploymentException("Enabled decorator class" + clazz + " specified twice");
            }
            if (decoratorBeanClasses.contains(clazz)) continue;
            throw new DeploymentException("Enabled decorator class " + clazz + " is not the bean class of at least one decorator bean (detected decorator beans " + decoratorBeanClasses + ")");
        }
    }

    private void validateEnabledPolicies(BeanManagerImpl beanManager) {
        ArrayList<Class<? extends Annotation>> seenPolicies = new ArrayList<Class<? extends Annotation>>();
        for (Class<? extends Annotation> clazz : beanManager.getEnabledPolicyStereotypes()) {
            if (!clazz.isAnnotationPresent(Alternative.class)) {
                throw new DeploymentException("Enabled policy sterotype " + clazz + " is not annotated @Policy");
            }
            if (seenPolicies.contains(clazz)) {
                throw new DeploymentException("Cannot enable the same policy sterotype " + clazz + " in beans.xml");
            }
            seenPolicies.add(clazz);
        }
        for (Class<Annotation> clazz : beanManager.getEnabledPolicyClasses()) {
            if (!clazz.isAnnotationPresent(Alternative.class)) {
                throw new DeploymentException("Enabled policy bean class " + clazz + " is not annotated @Policy");
            }
            if (seenPolicies.contains(clazz)) {
                throw new DeploymentException("Cannot enable the same policy bean class " + clazz + " in beans.xml");
            }
            seenPolicies.add(clazz);
        }
    }

    private void validateDisposalMethods(BeanDeployerEnvironment environment) {
        Set<DisposalMethodBean<?>> beans = environment.getUnresolvedDisposalBeans();
        if (!beans.isEmpty()) {
            throw new DefinitionException("The following Disposal methods where not declared but not resolved to a producer method" + beans);
        }
    }

    private static void checkFacadeInjectionPoint(InjectionPoint injectionPoint, Class<?> type) {
        if (injectionPoint.getAnnotated().getBaseType().equals(type)) {
            if (injectionPoint.getType() instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)injectionPoint.getType();
                if (parameterizedType.getActualTypeArguments()[0] instanceof TypeVariable) {
                    throw new DefinitionException("An injection point of type " + type + " cannot have a type variable type parameter " + injectionPoint);
                }
                if (parameterizedType.getActualTypeArguments()[0] instanceof WildcardType) {
                    throw new DefinitionException("An injection point of type " + type + " cannot have a wildcard type parameter " + injectionPoint);
                }
            } else {
                throw new DefinitionException("An injection point of type " + type + " must have a type parameter " + injectionPoint);
            }
        }
    }
}

