/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.inject.Inject;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.DecoratorBean;
import org.jboss.webbeans.bean.DisposalMethodBean;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bean.NewEnterpriseBean;
import org.jboss.webbeans.bean.NewSimpleBean;
import org.jboss.webbeans.bean.ProducerFieldBean;
import org.jboss.webbeans.bean.ProducerMethodBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bean.SimpleBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.bootstrap.ProcessObserverMethodImpl;
import org.jboss.webbeans.ejb.EJBApiAbstraction;
import org.jboss.webbeans.ejb.InternalEjbDescriptor;
import org.jboss.webbeans.event.ObserverFactory;
import org.jboss.webbeans.event.ObserverMethodImpl;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBField;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.jsf.JsfApiAbstraction;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.ServletApiAbstraction;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBeanDeployer {
    private static final LogProvider log = Logging.getLogProvider(AbstractBeanDeployer.class);
    private final BeanManagerImpl manager;
    private final BeanDeployerEnvironment environment;
    private final List<Throwable> definitionErrors = new ArrayList<Throwable>();

    public AbstractBeanDeployer(BeanManagerImpl manager, BeanDeployerEnvironment environment) {
        this.manager = manager;
        this.environment = environment;
    }

    protected BeanManagerImpl getManager() {
        return this.manager;
    }

    public AbstractBeanDeployer deploy() {
        Set<RIBean<?>> beans = this.getEnvironment().getBeans();
        for (DecoratorBean<?> decoratorBean : this.getEnvironment().getDecorators()) {
            decoratorBean.initialize(this.getEnvironment());
            this.manager.addDecorator(decoratorBean);
            log.debug("Bean: " + decoratorBean);
        }
        for (RIBean rIBean : beans) {
            rIBean.initialize(this.getEnvironment());
            this.manager.addBean(rIBean);
            log.debug("Bean: " + rIBean);
        }
        for (ObserverMethodImpl observerMethodImpl : this.getEnvironment().getObservers()) {
            log.debug("Observer : " + observerMethodImpl);
            if (observerMethodImpl instanceof ObserverMethodImpl) {
                observerMethodImpl.initialize();
            }
            this.manager.addObserver(observerMethodImpl);
        }
        return this;
    }

    protected <T> void createSubBeans(AbstractClassBean<T> bean) {
        this.createProducerMethods(bean, (WBClass<?>)bean.getAnnotatedItem());
        this.createProducerFields(bean, (WBClass<?>)bean.getAnnotatedItem());
        if (this.manager.isBeanEnabled(bean)) {
            this.createObserverMethods((RIBean)bean, (WBClass)bean.getAnnotatedItem());
        }
        this.createDisposalMethods(bean, (WBClass<?>)bean.getAnnotatedItem());
    }

    protected void createProducerMethods(AbstractClassBean<?> declaringBean, WBClass<?> annotatedClass) {
        for (WBMethod<?, ?> method : annotatedClass.getDeclaredWBAnnotatedMethods(Produces.class)) {
            this.createProducerMethod(declaringBean, method);
        }
    }

    protected void createDisposalMethods(AbstractClassBean<?> declaringBean, WBClass<?> annotatedClass) {
        for (WBMethod<?, ?> method : annotatedClass.getWBDeclaredMethodsWithAnnotatedParameters(Disposes.class)) {
            DisposalMethodBean<?> disposalBean = DisposalMethodBean.of(this.manager, method, declaringBean);
            disposalBean.initialize(this.getEnvironment());
            this.getEnvironment().addBean(disposalBean);
        }
    }

    protected <T> void createProducerMethod(AbstractClassBean<?> declaringBean, WBMethod<T, ?> annotatedMethod) {
        ProducerMethodBean<T> bean = ProducerMethodBean.of(annotatedMethod, declaringBean, this.manager);
        this.getEnvironment().addBean(bean);
    }

    protected <T> void createProducerField(AbstractClassBean<?> declaringBean, WBField<T, ?> field) {
        ProducerFieldBean<T> bean = ProducerFieldBean.of(field, declaringBean, this.manager);
        this.getEnvironment().addBean(bean);
    }

    protected void createProducerFields(AbstractClassBean<?> declaringBean, WBClass<?> annotatedClass) {
        for (WBField<?, ?> field : annotatedClass.getDeclaredAnnotatedWBFields(Produces.class)) {
            this.createProducerField(declaringBean, field);
        }
    }

    protected <X> void createObserverMethods(RIBean<X> declaringBean, WBClass<X> annotatedClass) {
        for (WBMethod<?, X> method : annotatedClass.getWBDeclaredMethodsWithAnnotatedParameters(Observes.class)) {
            this.createObserverMethod(declaringBean, method);
        }
    }

    protected <X, T> void createObserverMethod(RIBean<X> declaringBean, WBMethod<T, X> method) {
        ObserverMethodImpl observer = ObserverFactory.create(method, declaringBean, this.manager);
        ProcessObserverMethod event = this.createProcessObserverMethodEvent(observer, method);
        this.manager.fireEvent(event, new Annotation[0]);
        this.getEnvironment().addObserver(observer);
    }

    private <X, T> ProcessObserverMethod<X, T> createProcessObserverMethodEvent(ObserverMethod<X, T> observer, AnnotatedMethod<X> method) {
        return new ProcessObserverMethodImpl<X, T>(method, observer, this.definitionErrors){};
    }

    protected <T> void createSimpleBean(WBClass<T> annotatedClass) {
        SimpleBean<T> bean = SimpleBean.of(annotatedClass, this.manager);
        this.getEnvironment().addBean(bean);
        this.createSubBeans(bean);
        this.getEnvironment().addBean(NewSimpleBean.of(annotatedClass, this.manager));
    }

    protected <T> void createDecorator(WBClass<T> annotatedClass) {
        DecoratorBean<T> bean = DecoratorBean.of(annotatedClass, this.manager);
        this.getEnvironment().addBean(bean);
    }

    protected <T> void createEnterpriseBean(InternalEjbDescriptor<T> ejbDescriptor) {
        EnterpriseBean<T> bean = EnterpriseBean.of(ejbDescriptor, this.manager);
        this.getEnvironment().addBean(bean);
        this.createSubBeans(bean);
        this.getEnvironment().addBean(NewEnterpriseBean.of(ejbDescriptor, this.manager));
    }

    protected boolean isTypeManagedBeanOrDecorator(WBClass<?> clazz) {
        Class javaClass = clazz.getJavaClass();
        EJBApiAbstraction ejbApiAbstraction = this.manager.getServices().get(EJBApiAbstraction.class);
        JsfApiAbstraction jsfApiAbstraction = this.manager.getServices().get(JsfApiAbstraction.class);
        ServletApiAbstraction servletApiAbstraction = this.manager.getServices().get(ServletApiAbstraction.class);
        return !clazz.isNonStaticMemberClass() && !Reflections.isParamerterizedTypeWithWildcard(javaClass) && !servletApiAbstraction.SERVLET_CLASS.isAssignableFrom(javaClass) && !servletApiAbstraction.FILTER_CLASS.isAssignableFrom(javaClass) && !servletApiAbstraction.SERVLET_CONTEXT_LISTENER_CLASS.isAssignableFrom(javaClass) && !servletApiAbstraction.HTTP_SESSION_LISTENER_CLASS.isAssignableFrom(javaClass) && !servletApiAbstraction.SERVLET_REQUEST_LISTENER_CLASS.isAssignableFrom(javaClass) && !ejbApiAbstraction.ENTERPRISE_BEAN_CLASS.isAssignableFrom(javaClass) && !jsfApiAbstraction.UICOMPONENT_CLASS.isAssignableFrom(javaClass) && AbstractBeanDeployer.hasSimpleWebBeanConstructor(clazz);
    }

    private static boolean hasSimpleWebBeanConstructor(WBClass<?> type) {
        return type.getNoArgsWBConstructor() != null || type.getAnnotatedWBConstructors(Inject.class).size() > 0;
    }

    public BeanDeployerEnvironment getEnvironment() {
        return this.environment;
    }
}

