/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.DecoratorBean;
import org.jboss.webbeans.bean.DisposalMethodBean;
import org.jboss.webbeans.bean.NewBean;
import org.jboss.webbeans.bean.ProducerFieldBean;
import org.jboss.webbeans.bean.ProducerMethodBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bean.builtin.AbstractBuiltInBean;
import org.jboss.webbeans.bean.builtin.ExtensionBean;
import org.jboss.webbeans.ejb.EjbDescriptors;
import org.jboss.webbeans.event.ObserverMethodImpl;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.resolution.ResolvableFactory;
import org.jboss.webbeans.resolution.TypeSafeDisposerResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployerEnvironment {
    private final Map<WBClass<?>, AbstractClassBean<?>> classBeanMap = new HashMap();
    private final Map<WBMethod<?, ?>, ProducerMethodBean<?>> producerMethodBeanMap = new HashMap();
    private final Set<RIBean<?>> beans;
    private final Set<ObserverMethodImpl<?, ?>> observers;
    private final List<DisposalMethodBean<?>> allDisposalBeans = new ArrayList();
    private final Set<DisposalMethodBean<?>> resolvedDisposalBeans = new HashSet();
    private final Set<DecoratorBean<?>> decorators;
    private final EjbDescriptors ejbDescriptors;
    private final TypeSafeDisposerResolver disposalMethodResolver;

    public BeanDeployerEnvironment(EjbDescriptors ejbDescriptors, BeanManagerImpl manager) {
        this.beans = new HashSet();
        this.decorators = new HashSet();
        this.observers = new HashSet();
        this.ejbDescriptors = ejbDescriptors;
        this.disposalMethodResolver = new TypeSafeDisposerResolver(manager, this.allDisposalBeans);
    }

    public ProducerMethodBean<?> getProducerMethod(WBMethod<?, ?> method) {
        if (!this.producerMethodBeanMap.containsKey(method)) {
            return null;
        }
        ProducerMethodBean<?> bean = this.producerMethodBeanMap.get(method);
        bean.initialize(this);
        return bean;
    }

    public AbstractClassBean<?> getClassBean(WBClass<?> clazz) {
        if (!this.classBeanMap.containsKey(clazz)) {
            return null;
        }
        AbstractClassBean<?> bean = this.classBeanMap.get(clazz);
        bean.initialize(this);
        return bean;
    }

    public void addBean(ProducerMethodBean<?> bean) {
        this.producerMethodBeanMap.put((WBMethod<?, ?>)bean.getAnnotatedItem(), bean);
        this.beans.add(bean);
    }

    public void addBean(ProducerFieldBean<?> bean) {
        this.beans.add(bean);
    }

    public void addBean(ExtensionBean bean) {
        this.beans.add(bean);
    }

    public void addBean(AbstractBuiltInBean<?> bean) {
        this.beans.add(bean);
    }

    public void addBean(AbstractClassBean<?> bean) {
        if (!(bean instanceof NewBean)) {
            this.classBeanMap.put((WBClass<?>)bean.getAnnotatedItem(), bean);
        }
        this.beans.add(bean);
    }

    public void addBean(DecoratorBean<?> bean) {
        this.decorators.add(bean);
    }

    public void addBean(DisposalMethodBean<?> bean) {
        this.allDisposalBeans.add(bean);
    }

    public void addObserver(ObserverMethodImpl<?, ?> observer) {
        this.observers.add(observer);
    }

    public Set<RIBean<?>> getBeans() {
        return Collections.unmodifiableSet(this.beans);
    }

    public Set<DecoratorBean<?>> getDecorators() {
        return Collections.unmodifiableSet(this.decorators);
    }

    public Set<ObserverMethodImpl<?, ?>> getObservers() {
        return Collections.unmodifiableSet(this.observers);
    }

    public Set<DisposalMethodBean<?>> getUnresolvedDisposalBeans() {
        HashSet beans = new HashSet(this.allDisposalBeans);
        beans.removeAll(this.resolvedDisposalBeans);
        return Collections.unmodifiableSet(beans);
    }

    public EjbDescriptors getEjbDescriptors() {
        return this.ejbDescriptors;
    }

    public Set<DisposalMethodBean<?>> resolveDisposalBeans(Set<Type> types, Set<Annotation> bindings, AbstractClassBean<?> declaringBean) {
        Set beans = this.disposalMethodResolver.resolve(ResolvableFactory.of(types, bindings, declaringBean));
        this.resolvedDisposalBeans.addAll(beans);
        return Collections.unmodifiableSet(beans);
    }
}

