/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.conversation;

import java.io.Serializable;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.webbeans.conversation.ConversationIdGenerator;
import org.jboss.webbeans.conversation.ConversationInactivityTimeout;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

@RequestScoped
@Named(value="javax.enterprise.context.conversation")
@Default
public class ConversationImpl
implements Conversation,
Serializable {
    private static final long serialVersionUID = 5262382965141841363L;
    private static LogProvider log = Logging.getLogProvider(ConversationImpl.class);
    private String id;
    private String originalId;
    private boolean longRunning;
    private long timeout;

    public ConversationImpl() {
    }

    public ConversationImpl(ConversationImpl conversation) {
        this.id = conversation.getUnderlyingId();
        this.longRunning = conversation.isLongRunning();
        this.timeout = conversation.getTimeout();
    }

    @Inject
    public void init(ConversationIdGenerator conversationIdGenerator, @ConversationInactivityTimeout long timeout) {
        this.id = conversationIdGenerator.nextId();
        this.timeout = timeout;
        this.longRunning = false;
        log.debug("Created a new conversation " + this);
    }

    public void begin() {
        if (this.isLongRunning()) {
            throw new IllegalStateException("Attempt to call begin() on a long-running conversation");
        }
        log.debug("Promoted conversation " + this.id + " to long-running");
        this.longRunning = true;
    }

    public void begin(String id) {
        if (this.originalId == null) {
            this.originalId = id;
        }
        this.id = id;
        this.begin();
    }

    public void end() {
        if (!this.isLongRunning()) {
            throw new IllegalStateException("Attempt to call end() on a transient conversation");
        }
        log.debug("Demoted conversation " + this.id + " to transient");
        this.longRunning = false;
    }

    public String getId() {
        if (this.isLongRunning()) {
            return this.id;
        }
        return null;
    }

    public String getUnderlyingId() {
        return this.id;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isLongRunning() {
        return this.longRunning;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void switchTo(ConversationImpl conversation) {
        log.debug("Switched conversation from " + this);
        this.id = conversation.getUnderlyingId();
        this.longRunning = conversation.isLongRunning();
        this.timeout = conversation.getTimeout();
        log.debug(" to " + this);
    }

    public String toString() {
        return "ID: " + this.id + ", long-running: " + this.longRunning + ", timeout: " + this.timeout + "ms";
    }

    public void setLongRunning(boolean longRunning) {
        log.debug("Set conversation " + this.id + " to long-running: " + longRunning);
        this.longRunning = longRunning;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConversationImpl) {
            ConversationImpl that = (ConversationImpl)obj;
            return this.id == null || that.getUnderlyingId() == null ? false : this.id.equals(that.getUnderlyingId());
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? super.hashCode() : this.id.hashCode();
    }

    public boolean isTransient() {
        return !this.isLongRunning();
    }
}

