/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.WBAnnotated;
import org.jboss.webbeans.util.Proxies;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWBAnnotated<T, S>
implements WBAnnotated<T, S> {
    private String toString;
    private final AnnotationStore annotationStore;
    private final Class<T> rawType;
    private final Type[] actualTypeArguments;
    private final Type type;
    private final Set<Type> flattenedTypes;
    private final Set<Type> interfaceOnlyFlattenedTypes;
    private final boolean proxyable;
    private final boolean _parameterizedType;

    public AbstractWBAnnotated(AnnotationStore annotatedItemHelper, Class<T> rawType, Type type) {
        this.annotationStore = annotatedItemHelper;
        this.rawType = rawType;
        this.type = type;
        this.actualTypeArguments = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments() : new Type[0];
        this._parameterizedType = Reflections.isParameterizedType(rawType);
        this.flattenedTypes = new Reflections.HierarchyDiscovery(type).getFlattenedTypes();
        this.interfaceOnlyFlattenedTypes = new HashSet<Type>();
        for (Type t : rawType.getGenericInterfaces()) {
            this.interfaceOnlyFlattenedTypes.addAll(new Reflections.HierarchyDiscovery(t).getFlattenedTypes());
        }
        this.proxyable = Proxies.isTypesProxyable(this.flattenedTypes);
    }

    public AbstractWBAnnotated(AnnotationStore annotatedItemHelper) {
        this.annotationStore = annotatedItemHelper;
        this.rawType = null;
        this.type = null;
        this.actualTypeArguments = new Type[0];
        this._parameterizedType = false;
        this.flattenedTypes = null;
        this.interfaceOnlyFlattenedTypes = null;
        this.proxyable = false;
    }

    public AnnotationStore getAnnotationStore() {
        return this.annotationStore;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.getAnnotationStore().getAnnotation(annotationType);
    }

    @Override
    public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return this.getAnnotationStore().getMetaAnnotations(metaAnnotationType);
    }

    @Override
    public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return this.getAnnotationStore().getDeclaredMetaAnnotations(metaAnnotationType);
    }

    @Override
    public Annotation[] getMetaAnnotationsAsArray(Class<? extends Annotation> metaAnnotationType) {
        return this.getMetaAnnotations(metaAnnotationType).toArray(new Annotation[0]);
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return this.getAnnotationStore().getAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotatedType) {
        return this.getAnnotationStore().isAnnotationPresent(annotatedType);
    }

    public boolean equals(Object other) {
        if (other instanceof WBAnnotated) {
            WBAnnotated that = (WBAnnotated)other;
            return ((Object)this.getAnnotations()).equals(that.getAnnotations()) && this.getJavaClass().equals(that.getJavaClass());
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(WBAnnotated<?, ?> that) {
        return this.isAssignableFrom(that.getJavaClass(), that.getActualTypeArguments());
    }

    @Override
    public boolean isAssignableFrom(Class<?> type, Type[] actualTypeArguments) {
        return Reflections.isAssignableFrom(this.getJavaClass(), this.getActualTypeArguments(), type, actualTypeArguments);
    }

    public boolean isAssignableFrom(Type type) {
        return Reflections.isAssignableFrom(this.getBaseType(), type);
    }

    public int hashCode() {
        return this.getJavaClass().hashCode();
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Abstract annotated item " + this.getName();
        return this.toString;
    }

    @Override
    @Deprecated
    public Set<Annotation> getQualifiers() {
        return this.getAnnotationStore().getBindings();
    }

    @Override
    @Deprecated
    public Annotation[] getBindingsAsArray() {
        return this.getAnnotationStore().getBindingsAsArray();
    }

    @Override
    public boolean isProxyable() {
        return this.proxyable;
    }

    @Override
    public Class<T> getJavaClass() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Set<Type> getInterfaceOnlyFlattenedTypeHierarchy() {
        return Collections.unmodifiableSet(this.interfaceOnlyFlattenedTypes);
    }

    public abstract S getDelegate();

    @Override
    public boolean isDeclaredAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotationStore().isDeclaredAnnotationPresent(annotationType);
    }

    @Override
    public boolean isParameterizedType() {
        return this._parameterizedType;
    }

    @Override
    public Type getBaseType() {
        return this.type;
    }

    @Override
    public Set<Type> getTypeClosure() {
        return Collections.unmodifiableSet(this.flattenedTypes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface WrappableAnnotatedItem<T, S>
    extends WBAnnotated<T, S> {
        public AnnotationStore getAnnotationStore();
    }
}

