/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.WBAnnotation;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.introspector.jlr.WBClassImpl;
import org.jboss.webbeans.introspector.jlr.WBMethodImpl;
import org.jboss.webbeans.resources.ClassTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBAnnotationImpl<T extends Annotation>
extends WBClassImpl<T>
implements WBAnnotation<T> {
    private final SetMultimap<Class<? extends Annotation>, WBMethod<?, ?>> annotatedMembers;
    private final Class<T> clazz;
    private final Set<WBMethod<?, ?>> members;
    private final Map<String, WBMethod<?, ?>> namedMembers;
    private String toString;

    public static <A extends Annotation> WBAnnotation<A> of(Class<A> annotationType, ClassTransformer classTransformer) {
        return new WBAnnotationImpl<A>(annotationType, classTransformer);
    }

    protected WBAnnotationImpl(Class<T> annotationType, ClassTransformer classTransformer) {
        super(annotationType, annotationType, null, AnnotationStore.of(annotationType, classTransformer.getTypeStore().get(annotationType), classTransformer.getTypeStore().get(annotationType), classTransformer.getTypeStore()), classTransformer);
        this.clazz = annotationType;
        this.members = new HashSet();
        this.annotatedMembers = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBMethod<?, ?>>>(){

            @Override
            public Set<WBMethod<?, ?>> get() {
                return new HashSet();
            }
        });
        this.namedMembers = new HashMap();
        for (Method member : this.clazz.getDeclaredMethods()) {
            WBMethodImpl annotatedMethod = WBMethodImpl.of(member, this, classTransformer);
            this.members.add(annotatedMethod);
            for (Annotation annotation : annotatedMethod.getAnnotations()) {
                this.annotatedMembers.put(annotation.annotationType(), annotatedMethod);
            }
            this.namedMembers.put(annotatedMethod.getName(), annotatedMethod);
        }
    }

    @Override
    public Set<WBMethod<?, ?>> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    @Override
    public Set<WBMethod<?, ?>> getAnnotatedMembers(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedMembers.get(annotationType));
    }

    @Override
    public <A> WBMethod<A, ?> getMember(String memberName, WBClass<A> expectedType) {
        return this.namedMembers.get(memberName);
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        return this.toString;
    }

    @Override
    public Class<T> getDelegate() {
        return this.clazz;
    }
}

