/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.ConstructorSignature;
import org.jboss.webbeans.introspector.MethodSignature;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBConstructor;
import org.jboss.webbeans.introspector.WBField;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.introspector.jlr.AbstractWBAnnotated;
import org.jboss.webbeans.introspector.jlr.WBConstructorImpl;
import org.jboss.webbeans.introspector.jlr.WBFieldImpl;
import org.jboss.webbeans.introspector.jlr.WBMethodImpl;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBClassImpl<T>
extends AbstractWBAnnotated<T, Class<T>>
implements WBClass<T> {
    private final WBClass<?> superclass;
    private final String name;
    private final String _simpleName;
    private final boolean _public;
    private final boolean _private;
    private static List<Class<?>> NO_ARGUMENTS = Collections.emptyList();
    private final Set<WBField<?, ?>> fields;
    private final SetMultimap<Class<? extends Annotation>, WBField<?, ?>> annotatedFields;
    private final SetMultimap<Class<? extends Annotation>, WBField<?, ?>> metaAnnotatedFields;
    private final Set<WBField<?, ?>> declaredFields;
    private final Map<String, WBField<?, ?>> declaredFieldsByName;
    private final SetMultimap<Class<? extends Annotation>, WBField<?, ?>> declaredAnnotatedFields;
    private final SetMultimap<Class<? extends Annotation>, WBField<?, ?>> declaredMetaAnnotatedFields;
    private final Set<WBMethod<?, ?>> methods;
    private final Map<MethodSignature, WBMethod<?, ?>> declaredMethodsBySignature;
    private final Map<MethodSignature, WBMethod<?, ?>> methodsBySignature;
    private final SetMultimap<Class<? extends Annotation>, WBMethod<?, ?>> annotatedMethods;
    private final SetMultimap<Class<? extends Annotation>, WBMethod<?, ?>> methodsByAnnotatedParameters;
    private final Set<WBMethod<?, ?>> declaredMethods;
    private final SetMultimap<Class<? extends Annotation>, WBMethod<?, ?>> declaredAnnotatedMethods;
    private final SetMultimap<Class<? extends Annotation>, WBMethod<?, T>> declaredMethodsByAnnotatedParameters;
    private final Set<WBConstructor<T>> constructors;
    private final Map<ConstructorSignature, WBConstructor<?>> declaredConstructorsBySignature;
    private final SetMultimap<Class<? extends Annotation>, WBConstructor<T>> annotatedConstructors;
    private final Map<List<Class<?>>, WBConstructor<T>> constructorsByArgumentMap;
    private final SetMultimap<Class<? extends Annotation>, WBConstructor<?>> constructorsByAnnotatedParameters;
    private String toString;
    private final boolean _nonStaticMemberClass;
    private final boolean _abstract;
    private final boolean _enum;

    public static <T> WBClass<T> of(Class<T> clazz, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(clazz.getAnnotations(), clazz.getDeclaredAnnotations(), classTransformer.getTypeStore());
        return new WBClassImpl<T>(clazz, clazz, null, annotationStore, classTransformer);
    }

    public static <T> WBClass<T> of(AnnotatedType<T> annotatedType, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(annotatedType.getAnnotations(), annotatedType.getAnnotations(), classTransformer.getTypeStore());
        return new WBClassImpl<T>(annotatedType.getJavaClass(), annotatedType.getBaseType(), annotatedType, annotationStore, classTransformer);
    }

    /*
     * WARNING - void declaration
     */
    protected WBClassImpl(Class<T> rawType, Type type, AnnotatedType<T> annotatedType, AnnotationStore annotationStore, ClassTransformer classTransformer) {
        super(annotationStore, rawType, type);
        this.name = rawType.getName();
        this._simpleName = rawType.getSimpleName();
        this.superclass = rawType.getSuperclass() != null ? classTransformer.loadClass(rawType.getSuperclass()) : null;
        this._public = Modifier.isFinal(rawType.getModifiers());
        this._private = Modifier.isPrivate(rawType.getModifiers());
        this.fields = new HashSet();
        this.annotatedFields = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBField<?, ?>>>(){

            @Override
            public Set<WBField<?, ?>> get() {
                return new HashSet();
            }
        });
        this.metaAnnotatedFields = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBField<?, ?>>>(){

            @Override
            public Set<WBField<?, ?>> get() {
                return new HashSet();
            }
        });
        this.declaredFields = new HashSet();
        this.declaredFieldsByName = new HashMap();
        this.declaredAnnotatedFields = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBField<?, ?>>>(){

            @Override
            public Set<WBField<?, ?>> get() {
                return new HashSet();
            }
        });
        this.declaredMetaAnnotatedFields = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBField<?, ?>>>(){

            @Override
            public Set<WBField<?, ?>> get() {
                return new HashSet();
            }
        });
        this._nonStaticMemberClass = Reflections.isNonStaticInnerClass(rawType);
        this._abstract = Reflections.isAbstract(rawType);
        this._enum = rawType.isEnum();
        HashMap<Field, AnnotatedField<T>> annotatedTypeFields = new HashMap<Field, AnnotatedField<T>>();
        if (annotatedType != null) {
            for (AnnotatedField<T> annotatedField : annotatedType.getFields()) {
                annotatedTypeFields.put(annotatedField.getJavaMember(), annotatedField);
            }
        }
        for (Class<T> c = rawType; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                WBFieldImpl annotatedField = null;
                annotatedField = annotatedTypeFields.containsKey(field) ? WBFieldImpl.of((AnnotatedField)annotatedTypeFields.get(field), this.getDeclaringWBClass(field, classTransformer), classTransformer) : WBFieldImpl.of(field, this.getDeclaringWBClass(field, classTransformer), classTransformer);
                this.fields.add(annotatedField);
                if (c == rawType) {
                    this.declaredFields.add(annotatedField);
                    this.declaredFieldsByName.put(annotatedField.getName(), annotatedField);
                }
                for (Annotation annotation : annotatedField.getAnnotations()) {
                    this.annotatedFields.put(annotation.annotationType(), annotatedField);
                    if (c == rawType) {
                        this.declaredAnnotatedFields.put(annotation.annotationType(), annotatedField);
                    }
                    for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                        this.metaAnnotatedFields.put(metaAnnotation.annotationType(), annotatedField);
                        if (c != rawType) continue;
                        this.declaredMetaAnnotatedFields.put(metaAnnotation.annotationType(), annotatedField);
                    }
                }
            }
        }
        this.constructors = new HashSet<WBConstructor<T>>();
        this.constructorsByArgumentMap = new HashMap();
        this.annotatedConstructors = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBConstructor<T>>>(){

            @Override
            public Set<WBConstructor<T>> get() {
                return new HashSet();
            }
        });
        this.constructorsByAnnotatedParameters = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBConstructor<?>>>(){

            @Override
            public Set<WBConstructor<?>> get() {
                return new HashSet();
            }
        });
        HashMap<Constructor<T>, AnnotatedConstructor<T>> annotatedTypeConstructors = new HashMap<Constructor<T>, AnnotatedConstructor<T>>();
        if (annotatedType != null) {
            for (AnnotatedConstructor<T> annotated : annotatedType.getConstructors()) {
                annotatedTypeConstructors.put(annotated.getJavaMember(), annotated);
            }
        }
        this.declaredConstructorsBySignature = new HashMap();
        for (AccessibleObject accessibleObject : rawType.getDeclaredConstructors()) {
            WBConstructor annotatedConstructor = null;
            if (annotatedTypeConstructors.containsKey(accessibleObject)) {
                WBClass declaringClass = this.getDeclaringWBClass((Member)((Object)accessibleObject), classTransformer);
                annotatedConstructor = WBConstructorImpl.of((AnnotatedConstructor)annotatedTypeConstructors.get(accessibleObject), declaringClass, classTransformer);
            } else {
                AccessibleObject c = accessibleObject;
                annotatedConstructor = WBConstructorImpl.of(c, this.getDeclaringWBClass((Member)((Object)c), classTransformer), classTransformer);
            }
            if (!accessibleObject.isAccessible()) {
                ((Constructor)accessibleObject).setAccessible(true);
            }
            this.constructors.add(annotatedConstructor);
            this.constructorsByArgumentMap.put(Arrays.asList(((Constructor)accessibleObject).getParameterTypes()), annotatedConstructor);
            this.declaredConstructorsBySignature.put(annotatedConstructor.getSignature(), annotatedConstructor);
            for (Annotation annotation : annotatedConstructor.getAnnotations()) {
                if (!this.annotatedConstructors.containsKey(annotation.annotationType())) {
                    this.annotatedConstructors.putAll(annotation.annotationType(), new HashSet());
                }
                this.annotatedConstructors.get(annotation.annotationType()).add(annotatedConstructor);
            }
            for (Class clazz : WBConstructor.MAPPED_PARAMETER_ANNOTATIONS) {
                if (annotatedConstructor.getAnnotatedWBParameters(clazz).size() <= 0) continue;
                this.constructorsByAnnotatedParameters.put(clazz, annotatedConstructor);
            }
        }
        this.methods = new HashSet();
        this.annotatedMethods = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBMethod<?, ?>>>(){

            @Override
            public Set<WBMethod<?, ?>> get() {
                return new HashSet();
            }
        });
        this.methodsByAnnotatedParameters = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBMethod<?, ?>>>(){

            @Override
            public Set<WBMethod<?, ?>> get() {
                return new HashSet();
            }
        });
        this.declaredMethods = new HashSet();
        this.declaredAnnotatedMethods = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBMethod<?, ?>>>(){

            @Override
            public Set<WBMethod<?, ?>> get() {
                return new HashSet();
            }
        });
        this.declaredMethodsByAnnotatedParameters = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WBMethod<?, T>>>(){

            @Override
            public Set<WBMethod<?, T>> get() {
                return new HashSet();
            }
        });
        this.declaredMethodsBySignature = new HashMap();
        this.methodsBySignature = new HashMap();
        HashMap<Method, AnnotatedMethod<T>> annotatedTypeMethods = new HashMap<Method, AnnotatedMethod<T>>();
        if (annotatedType != null) {
            for (AnnotatedMethod<T> annotated : annotatedType.getMethods()) {
                annotatedTypeMethods.put(annotated.getJavaMember(), annotated);
            }
        }
        for (Class<T> c = rawType; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                void var14_34;
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                Object var14_31 = null;
                if (annotatedTypeMethods.containsKey(method)) {
                    WBMethodImpl wBMethodImpl = WBMethodImpl.of((AnnotatedMethod)annotatedTypeMethods.get(method), this, classTransformer);
                } else {
                    WBMethodImpl wBMethodImpl = WBMethodImpl.of(method, this.getDeclaringWBClass(method, classTransformer), classTransformer);
                }
                this.methods.add((WBMethod<?, ?>)var14_34);
                this.methodsBySignature.put(var14_34.getSignature(), (WBMethod<?, ?>)var14_34);
                if (c == rawType) {
                    this.declaredMethods.add((WBMethod<?, ?>)var14_34);
                    this.declaredMethodsBySignature.put(var14_34.getSignature(), (WBMethod<?, ?>)var14_34);
                }
                for (Annotation annotation : var14_34.getAnnotations()) {
                    this.annotatedMethods.put((Class<Annotation>)annotation.annotationType(), (WBMethod<?, ?>)var14_34);
                    if (c != rawType) continue;
                    this.declaredAnnotatedMethods.put((Class<Annotation>)annotation.annotationType(), (WBMethod<?, ?>)var14_34);
                }
                for (Class clazz : WBMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                    if (var14_34.getAnnotatedWBParameters(clazz).size() <= 0) continue;
                    this.methodsByAnnotatedParameters.put((Class<Annotation>)((Class<? extends Annotation>)clazz), (WBMethod<?, ?>)var14_34);
                    if (c != rawType) continue;
                    this.declaredMethodsByAnnotatedParameters.put((Class<Annotation>)((Class<? extends Annotation>)clazz), (WBMethod<?, T>)var14_34);
                }
            }
        }
    }

    private <X> WBClass<X> getDeclaringWBClass(Member member, ClassTransformer transformer) {
        if (member.getDeclaringClass().equals(this.getJavaClass())) {
            return this;
        }
        return transformer.loadClass(member.getDeclaringClass());
    }

    public Class<? extends T> getAnnotatedClass() {
        return this.getJavaClass();
    }

    @Override
    public Class<T> getDelegate() {
        return this.getJavaClass();
    }

    @Override
    public Set<WBField<?, ?>> getWBFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Set<WBField<?, ?>> getDeclaredFields() {
        return Collections.unmodifiableSet(this.declaredFields);
    }

    @Override
    public <F> WBField<F, ?> getDeclaredWBField(String fieldName, WBClass<F> expectedType) {
        return this.declaredFieldsByName.get(fieldName);
    }

    @Override
    public Set<WBField<?, ?>> getDeclaredAnnotatedWBFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredAnnotatedFields.get(annotationType));
    }

    @Override
    public Set<WBConstructor<T>> getWBConstructors() {
        return Collections.unmodifiableSet(this.constructors);
    }

    @Override
    public WBConstructor<T> getDeclaredWBConstructor(ConstructorSignature signature) {
        return this.declaredConstructorsBySignature.get(signature);
    }

    @Override
    public Set<WBField<?, ?>> getMetaAnnotatedWBFields(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(this.metaAnnotatedFields.get(metaAnnotationType));
    }

    @Override
    public Set<WBField<?, ?>> getAnnotatedWBFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedFields.get(annotationType));
    }

    @Override
    public boolean isNonStaticMemberClass() {
        return this._nonStaticMemberClass;
    }

    @Override
    public boolean isAbstract() {
        return this._abstract;
    }

    @Override
    public boolean isEnum() {
        return this._enum;
    }

    @Override
    public Set<WBMethod<?, ?>> getAnnotatedWBMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedMethods.get(annotationType));
    }

    @Override
    public Set<WBMethod<?, ?>> getDeclaredWBAnnotatedMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredAnnotatedMethods.get(annotationType));
    }

    @Override
    public Set<WBConstructor<T>> getAnnotatedWBConstructors(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedConstructors.get(annotationType));
    }

    @Override
    public WBConstructor<T> getNoArgsWBConstructor() {
        return this.constructorsByArgumentMap.get(NO_ARGUMENTS);
    }

    @Override
    public Set<WBMethod<?, ?>> getWBMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.methodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public Set<WBConstructor<?>> getWBConstructorsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.constructorsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public Set<WBMethod<?, T>> getWBDeclaredMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredMethodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public WBMethod<?, ?> getWBMethod(Method methodDescriptor) {
        for (WBMethod<?, ?> annotatedMethod : this.methods) {
            if (!annotatedMethod.getName().equals(methodDescriptor.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), methodDescriptor.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public Set<WBMethod<?, ?>> getWBMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    @Override
    public WBMethod<?, ?> getDeclaredWBMethod(Method method) {
        for (WBMethod<?, ?> annotatedMethod : this.declaredMethods) {
            if (!annotatedMethod.getName().equals(method.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), method.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public <M> WBMethod<M, ?> getDeclaredWBMethod(MethodSignature signature, WBClass<M> expectedReturnType) {
        return this.declaredMethodsBySignature.get(signature);
    }

    @Override
    public <M> WBMethod<M, ?> getWBMethod(MethodSignature signature) {
        return this.methodsBySignature.get(signature);
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Annotated class " + Names.classToString(this.getDelegate());
        return this.toString;
    }

    @Override
    public String getSimpleName() {
        return this._simpleName;
    }

    @Override
    public boolean isStatic() {
        return Reflections.isStatic(this.getDelegate());
    }

    @Override
    public boolean isFinal() {
        return Reflections.isFinal(this.getDelegate());
    }

    @Override
    public boolean isPublic() {
        return this._public;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public WBClass<?> getWBSuperclass() {
        return this.superclass;
    }

    @Override
    public boolean isEquivalent(Class<?> clazz) {
        return this.getDelegate().equals(clazz);
    }

    @Override
    public boolean isPrivate() {
        return this._private;
    }

    @Override
    public <U> WBClass<? extends U> asWBSubclass(WBClass<U> clazz) {
        return this;
    }

    @Override
    public <S> S cast(Object object) {
        return (S)object;
    }

    @Override
    public Set<AnnotatedConstructor<T>> getConstructors() {
        return this.constructors;
    }

    @Override
    public Set<AnnotatedField<? super T>> getFields() {
        return this.fields;
    }

    @Override
    public Set<AnnotatedMethod<? super T>> getMethods() {
        return this.methods;
    }
}

