/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.resolution;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bean.DecoratorBean;
import org.jboss.webbeans.resolution.Resolvable;
import org.jboss.webbeans.resolution.TypeSafeBeanResolver;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeDecoratorResolver
extends TypeSafeBeanResolver<DecoratorBean<?>> {
    public TypeSafeDecoratorResolver(BeanManagerImpl manager, Iterable<DecoratorBean<?>> decorators) {
        super(manager, decorators);
    }

    @Override
    protected boolean matches(Resolvable resolvable, DecoratorBean<?> bean) {
        return Reflections.isAssignableFrom(bean.getDelegateTypes(), resolvable.getTypeClosure()) && Beans.containsAllBindings(bean.getDelegateQualifiers(), resolvable.getQualifiers(), this.getManager()) && this.getManager().getEnabledDecoratorClasses().contains(bean.getType());
    }

    @Override
    protected Set<DecoratorBean<?>> sortResult(Set<DecoratorBean<?>> matchedDecorators) {
        TreeSet sortedBeans = new TreeSet(new Comparator<DecoratorBean<?>>(){

            @Override
            public int compare(DecoratorBean<?> o1, DecoratorBean<?> o2) {
                List<Class<?>> enabledDecorators = TypeSafeDecoratorResolver.this.getManager().getEnabledDecoratorClasses();
                int p1 = enabledDecorators.indexOf(o1.getType());
                int p2 = enabledDecorators.indexOf(o2.getType());
                return p1 - p2;
            }
        });
        sortedBeans.addAll(matchedDecorators);
        return sortedBeans;
    }
}

