/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.servlet;

import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.context.ContextLifecycle;
import org.jboss.webbeans.context.RequestContext;
import org.jboss.webbeans.context.SessionContext;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.webbeans.conversation.ConversationManager;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.HttpRequestSessionBeanStore;
import org.jboss.webbeans.servlet.HttpSessionBeanStore;
import org.jboss.webbeans.servlet.HttpSessionManager;
import org.jboss.webbeans.servlet.ServletHelper;

public class ServletLifecycle {
    private final ContextLifecycle lifecycle;
    public static final String REQUEST_ATTRIBUTE_NAME = ServletLifecycle.class.getName() + ".requestBeanStore";
    private static LogProvider log = Logging.getLogProvider(ServletLifecycle.class);

    public ServletLifecycle(ContextLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void beginSession(HttpSession session) {
    }

    public void endSession(HttpSession session) {
        SessionContext sessionContext = CurrentManager.rootManager().getServices().get(SessionContext.class);
        RequestContext requestContext = CurrentManager.rootManager().getServices().get(RequestContext.class);
        ConversationManager conversationManager = ServletHelper.getModuleBeanManager(session.getServletContext()).getInstanceByType(ConversationManager.class, new Annotation[0]);
        if (sessionContext.isActive()) {
            this.lifecycle.endSession(session.getId(), sessionContext.getBeanStore(), conversationManager);
        } else if (requestContext.isActive()) {
            this.lifecycle.endSession(session.getId(), this.restoreSessionContext(session), conversationManager);
        } else {
            ConcurrentHashMapBeanStore mockRequest = new ConcurrentHashMapBeanStore();
            this.lifecycle.beginRequest("endSession-" + session.getId(), mockRequest);
            this.lifecycle.endSession(session.getId(), this.restoreSessionContext(session), conversationManager);
            this.lifecycle.endRequest("endSession-" + session.getId(), mockRequest);
        }
    }

    protected BeanStore restoreSessionContext(HttpServletRequest request) {
        HttpRequestSessionBeanStore sessionBeanStore = new HttpRequestSessionBeanStore(request);
        HttpSession session = request.getSession(false);
        this.lifecycle.restoreSession(session == null ? "Inactive session" : session.getId(), sessionBeanStore);
        if (session != null) {
            ServletHelper.getModuleBeanManager(session.getServletContext()).getInstanceByType(HttpSessionManager.class, new Annotation[0]).setSession(session);
        }
        return sessionBeanStore;
    }

    protected BeanStore restoreSessionContext(HttpSession session) {
        HttpSessionBeanStore beanStore = new HttpSessionBeanStore(session);
        this.lifecycle.restoreSession(session.getId(), beanStore);
        ServletHelper.getModuleBeanManager(session.getServletContext()).getInstanceByType(HttpSessionManager.class, new Annotation[0]).setSession(session);
        return beanStore;
    }

    public void beginRequest(HttpServletRequest request) {
        if (request.getAttribute(REQUEST_ATTRIBUTE_NAME) == null) {
            ConcurrentHashMapBeanStore beanStore = new ConcurrentHashMapBeanStore();
            request.setAttribute(REQUEST_ATTRIBUTE_NAME, (Object)beanStore);
            this.lifecycle.beginRequest(request.getRequestURI(), beanStore);
            this.restoreSessionContext(request);
        }
    }

    public void endRequest(HttpServletRequest request) {
        if (request.getAttribute(REQUEST_ATTRIBUTE_NAME) != null) {
            BeanStore beanStore = (BeanStore)request.getAttribute(REQUEST_ATTRIBUTE_NAME);
            if (beanStore == null) {
                throw new IllegalStateException("Cannot obtain request scoped beans from the request");
            }
            this.lifecycle.endRequest(request.getRequestURI(), beanStore);
            request.removeAttribute(REQUEST_ATTRIBUTE_NAME);
            SessionContext sessionContext = CurrentManager.rootManager().getServices().get(SessionContext.class);
            sessionContext.setActive(false);
            sessionContext.setBeanStore(null);
        }
    }
}

