/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolStatsProviderBootstrap;
import com.sun.enterprise.resource.pool.monitor.ConnectorConnPoolProbeProvider;
import com.sun.enterprise.resource.pool.monitor.JdbcConnPoolProbeProvider;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
public class ConnectionPoolProbeProviderUtil {
    private ConnectorConnPoolProbeProvider connectorConnPoolProvider = null;
    private JdbcConnPoolProbeProvider jdbcConnPoolProvider = null;
    private Logger _logger = LogDomains.getLogger(ConnectionPoolProbeProviderUtil.class, (String)"javax.enterprise.resource.resourceadapter");
    @Inject
    private Habitat habitat;

    public void createProbeProviders() {
        try {
            this.connectorConnPoolProvider = new ConnectorConnPoolProbeProvider();
            if (this.connectorConnPoolProvider == null) {
                this._logger.log(Level.WARNING, "Unable to create probe provider for interface " + ConnectorConnPoolProbeProvider.class.getName() + ", using no-op provider");
            }
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, "Unable to create probe provider for interface " + ConnectorConnPoolProbeProvider.class.getName() + ", using no-op provider", e);
        }
        try {
            this.jdbcConnPoolProvider = new JdbcConnPoolProbeProvider();
            if (this.jdbcConnPoolProvider == null) {
                this._logger.log(Level.WARNING, "Unable to create probe provider for interface " + JdbcConnPoolProbeProvider.class.getName() + ", using no-op provider");
            }
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, "Unable to create probe provider for interface " + JdbcConnPoolProbeProvider.class.getName() + ", using no-op provider", e);
        }
        if (ConnectorRuntime.getRuntime().isServer()) {
            this.getConnPoolBootstrap().registerProvider();
        }
    }

    private ConnectionPoolStatsProviderBootstrap getConnPoolBootstrap() {
        return (ConnectionPoolStatsProviderBootstrap)this.habitat.getComponent(ConnectionPoolStatsProviderBootstrap.class);
    }

    public ConnectorConnPoolProbeProvider getConnectorConnPoolProvider() {
        return this.connectorConnPoolProvider;
    }

    public JdbcConnPoolProbeProvider getJdbcConnPoolProvider() {
        return this.jdbcConnPoolProvider;
    }
}

