/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.enterprise.connectors.work.WorkCoordinator;
import com.sun.enterprise.connectors.work.context.WorkContextHandler;
import com.sun.enterprise.connectors.work.monitor.WorkManagementProbeProvider;
import com.sun.enterprise.connectors.work.monitor.WorkManagementStatsProvider;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;

public final class CommonWorkManager
implements WorkManager {
    private static WorkManager wm = null;
    private ThreadPoolManager tpm;
    private ThreadPool tp;
    private static final Logger logger = LogDomains.getLogger(CommonWorkManager.class, (String)"javax.enterprise.resource.resourceadapter");
    private WorkManagementProbeProvider probeProvider = null;
    private WorkManagementStatsProvider statsProvider = null;
    private String dottedNamesHierarchy;
    private StringManager localStrings = StringManager.getManager(CommonWorkManager.class);
    private ConnectorRuntime runtime;
    private String raName;

    public CommonWorkManager(String threadPoolId, ConnectorRuntime runtime, String raName) throws ConnectorRuntimeException {
        if (runtime.isServer()) {
            try {
                this.runtime = runtime;
                this.raName = raName;
                this.tp = runtime.getThreadPool(threadPoolId);
            }
            catch (NoSuchThreadPoolException e) {
                String msg = this.localStrings.getString("workmanager.threadpool_not_found");
                logger.log(Level.SEVERE, msg, threadPoolId);
                ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
                cre.initCause((Throwable)e);
                throw cre;
            }
            if (this.tp == null) {
                String msg = this.localStrings.getString("workmanager.threadpool_not_found");
                logger.log(Level.SEVERE, msg, threadPoolId);
                throw new ConnectorRuntimeException(msg);
            }
            this.registerWithMonitoringService();
        }
    }

    private void registerWithMonitoringService() {
        if (ConnectorsUtil.belongsToSystemRA((String)this.raName) && !ConnectorsUtil.isJMSRA((String)this.raName)) {
            return;
        }
        this.probeProvider = new WorkManagementProbeProvider();
        String monitoringModuleName = "connector-service";
        if (ConnectorsUtil.isJMSRA((String)this.raName)) {
            this.dottedNamesHierarchy = "jms-service/work-management";
            monitoringModuleName = "jms-service";
        } else {
            this.dottedNamesHierarchy = "connector-service/" + this.raName + "/" + "work-management";
        }
        this.statsProvider = new WorkManagementStatsProvider(this.raName);
        StatsProviderManager.register((String)monitoringModuleName, (PluginPoint)PluginPoint.SERVER, (String)this.dottedNamesHierarchy, (Object)this.statsProvider);
        logger.log(Level.FINE, "Registered work-monitoring stats [ " + this.dottedNamesHierarchy + " ]  " + "for [ " + this.raName + " ] with monitoring-stats-registry.");
    }

    private void deregisterFromMonitoringService() {
        if (ConnectorsUtil.belongsToSystemRA((String)this.raName) && !ConnectorsUtil.isJMSRA((String)this.raName)) {
            return;
        }
        if (this.statsProvider != null) {
            StatsProviderManager.unregister((Object)this.statsProvider);
            logger.log(Level.FINE, "De-registered work-monitoring stats [ " + this.dottedNamesHierarchy + " ]" + "  for [ " + this.raName + " ] from monitoring-stats-registry.");
        }
    }

    public void cleanUp() {
        if (this.runtime != null && this.runtime.isServer()) {
            this.deregisterFromMonitoringService();
        }
    }

    public void doWork(Work work) throws WorkException {
        this.doWork(work, -1L, null, null);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkContextHandler contextHandler = this.createWorkContextHandler();
        this.validateWork(work, WorkCoordinator.getExecutionContext(execContext, work), contextHandler);
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "doWork for [" + work.toString() + "] START";
            logger.log(Level.FINEST, this.debugMsg(msg));
        }
        WorkCoordinator wc = new WorkCoordinator(work, startTimeout, execContext, this.tp.getAnyWorkQueue(), workListener, this.probeProvider, this.runtime, this.raName, contextHandler);
        wc.submitWork(2);
        wc.lock();
        WorkException we = wc.getException();
        if (we != null) {
            throw we;
        }
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "doWork for [" + work.toString() + "] END";
            msg = "doWork for [" + work.toString() + "] END";
            logger.log(Level.FINEST, this.debugMsg(msg));
        }
    }

    public long startWork(Work work) throws WorkException {
        return this.startWork(work, -1L, null, null);
    }

    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkContextHandler contextHandler = this.createWorkContextHandler();
        this.validateWork(work, WorkCoordinator.getExecutionContext(execContext, work), contextHandler);
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "startWork for [" + work.toString() + "] START";
            logger.log(Level.FINEST, this.debugMsg(msg));
        }
        long acceptanceTime = System.currentTimeMillis();
        WorkCoordinator wc = new WorkCoordinator(work, startTimeout, execContext, this.tp.getAnyWorkQueue(), workListener, this.probeProvider, this.runtime, this.raName, contextHandler);
        wc.submitWork(1);
        wc.lock();
        WorkException we = wc.getException();
        if (we != null) {
            throw we;
        }
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "startWork for [" + work.toString() + "] END";
            logger.log(Level.FINEST, this.debugMsg(msg));
        }
        long startTime = System.currentTimeMillis();
        return startTime - acceptanceTime;
    }

    private WorkContextHandler createWorkContextHandler() {
        WorkContextHandler contextHandler = new WorkContextHandler(this.runtime);
        return contextHandler;
    }

    public void scheduleWork(Work work) throws WorkException {
        this.scheduleWork(work, -1L, null, null);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkContextHandler contextHandler = this.createWorkContextHandler();
        this.validateWork(work, WorkCoordinator.getExecutionContext(execContext, work), contextHandler);
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "scheduleWork for [" + work.toString() + "] START";
            logger.log(Level.FINEST, this.debugMsg(msg));
        }
        WorkCoordinator wc = new WorkCoordinator(work, startTimeout, execContext, this.tp.getAnyWorkQueue(), workListener, this.probeProvider, this.runtime, this.raName, contextHandler);
        wc.submitWork(3);
        wc.lock();
        WorkException we = wc.getException();
        if (we != null) {
            throw we;
        }
        if (logger.isLoggable(Level.FINEST)) {
            String msg = "scheduleWork for [" + work.toString() + "] END";
            logger.log(Level.FINEST, this.debugMsg(msg));
        }
    }

    private void validateWork(Work workToBeValidated, ExecutionContext context, WorkContextHandler contextHandler) throws WorkCompletedException, WorkRejectedException {
        contextHandler.validateWork(workToBeValidated, context);
    }

    private String debugMsg(String message) {
        String msg = "[Thread " + Thread.currentThread().getName() + "] -- " + message;
        return msg;
    }
}

