/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.util.Map;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.PluralAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapAttributeImpl<X, K, V>
extends PluralAttributeImpl<X, Map<K, V>, V>
implements MapAttribute<X, K, V> {
    private Type<K> keyType;

    protected MapAttributeImpl(ManagedTypeImpl<X> managedType, CollectionMapping mapping) {
        this(managedType, mapping, false);
    }

    protected MapAttributeImpl(ManagedTypeImpl<X> managedType, CollectionMapping mapping, boolean validationEnabled) {
        super(managedType, mapping, validationEnabled);
        MapContainerPolicy policy = (MapContainerPolicy)mapping.getContainerPolicy();
        Object policyKeyType = policy.getKeyType();
        TypeImpl<K> aKeyType = null;
        Class javaClass = Object.class;
        if (null == policyKeyType) {
            if (managedType.isIdentifiableType()) {
                if (policy.getElementDescriptor() != null && policy.getElementDescriptor().getCMPPolicy() != null) {
                    javaClass = policy.getElementDescriptor().getCMPPolicy().getPKClass();
                } else if (null == policy.getElementDescriptor() && policy.isMappedKeyMapPolicy()) {
                    MapKeyMapping mapKeyMapping = ((MappedKeyMapContainerPolicy)policy).getKeyMapping();
                    RelationalDescriptor descriptor = (RelationalDescriptor)((DatabaseMapping)mapKeyMapping).getDescriptor();
                    if (null == descriptor) {
                        throw new IllegalArgumentException("Unsupported operation on " + managedType);
                    }
                    if (null == descriptor.getCMPPolicy()) {
                        javaClass = ((DatabaseMapping)mapKeyMapping).getAttributeClassification();
                        if (null == javaClass) {
                            javaClass = Object.class;
                        }
                    } else {
                        javaClass = descriptor.getCMPPolicy().getPKClass();
                    }
                }
            } else {
                System.out.println("_embeddableType: " + this + " mapping: " + mapping);
            }
        } else {
            javaClass = policyKeyType instanceof ClassDescriptor ? ((ClassDescriptor)policyKeyType).getJavaClass() : (Class)policyKeyType;
        }
        aKeyType = this.getMetamodel().getType(javaClass);
        this.keyType = aKeyType;
    }

    @Override
    public PluralAttribute.CollectionType getCollectionType() {
        return PluralAttribute.CollectionType.MAP;
    }

    public Class<K> getKeyJavaType() {
        return this.keyType.getJavaType();
    }

    public Type<K> getKeyType() {
        return this.keyType;
    }

    public String toString() {
        return "MapAttributeImpl[" + this.getMapping() + "]";
    }
}

