/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluralAttributeImpl<X, C, V>
extends AttributeImpl<X, C>
implements PluralAttribute<X, C, V> {
    protected Type<V> elementType;

    protected PluralAttributeImpl(ManagedTypeImpl<X> managedType, CollectionMapping mapping, boolean validationEnabled) {
        super(managedType, (DatabaseMapping)mapping);
        ClassDescriptor elementDesc = mapping.getContainerPolicy().getElementDescriptor();
        if (elementDesc != null) {
            this.elementType = this.getMetamodel().getType(elementDesc.getJavaClass());
        } else {
            Class<Object> attributeClass;
            if (mapping.isDirectCollectionMapping() || mapping.isAbstractCompositeDirectCollectionMapping()) {
                attributeClass = null;
                if (mapping.isDirectCollectionMapping()) {
                    attributeClass = ((DirectCollectionMapping)mapping).getDirectField().getType();
                }
                if (null == attributeClass && validationEnabled) {
                    attributeClass = Object.class;
                    AbstractSessionLog.getLog().log(1, "metamodel_attribute_class_type_is_null", (Object)this);
                }
                this.elementType = this.getMetamodel().getType(attributeClass);
            } else {
                attributeClass = mapping.getReferenceClass();
                if (null == attributeClass && validationEnabled) {
                    attributeClass = Object.class;
                    AbstractSessionLog.getLog().log(1, "metamodel_attribute_class_type_is_null", (Object)this);
                } else {
                    this.elementType = this.getMetamodel().getType(attributeClass);
                }
            }
            if (mapping.isMapKeyMapping()) {
                MapContainerPolicy policy = (MapContainerPolicy)mapping.getContainerPolicy();
                Class attributeClass2 = policy.getElementClass();
                if (null == attributeClass2 && validationEnabled) {
                    AbstractSessionLog.getLog().log(1, "metamodel_attribute_class_type_is_null", (Object)this);
                }
                this.elementType = this.getMetamodel().getType(policy.getElementClass());
            }
        }
    }

    public Class<V> getBindableJavaType() {
        return this.elementType.getJavaType();
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.PLURAL_ATTRIBUTE;
    }

    public CollectionMapping getCollectionMapping() {
        return (CollectionMapping)this.getMapping();
    }

    public abstract PluralAttribute.CollectionType getCollectionType();

    public Type<V> getElementType() {
        return this.elementType;
    }

    @Override
    public Class<C> getJavaType() {
        return this.elementType.getJavaType();
    }

    @Override
    public boolean isPlural() {
        return true;
    }
}

