/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnitReader;
import org.eclipse.persistence.internal.jpa.modelgen.visitors.TypeVisitor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class CanonicalModelProcessor
extends AbstractProcessor {
    protected static MetadataMirrorFactory m_factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCanonicalModelClass(Element element, ClassAccessor accessor) throws IOException {
        Writer writer = null;
        try {
            String qualifiedName = accessor.getAccessibleObjectName();
            JavaFileObject file = this.processingEnv.getFiler().createSourceFile(qualifiedName + "_", element);
            String packageName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
            String originalClassName = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
            String underScoreClassName = originalClassName + "_";
            writer = file.openWriter();
            writer.append("package " + packageName + ";\n\n");
            HashSet<String> attributeTypes = new HashSet<String>();
            ArrayList<String> attributes = new ArrayList<String>();
            HashSet<String> typeImports = new HashSet<String>();
            for (MappingAccessor mappingAccessor : accessor.getDescriptor().getAccessors()) {
                if (mappingAccessor.isTransient()) continue;
                MetadataAnnotatedElement annotatedElement = mappingAccessor.getAnnotatedElement();
                MetadataClass rawClass = annotatedElement.getRawClass(mappingAccessor.getDescriptor());
                String attributeType = AttributeType.SingularAttribute.name();
                String types = originalClassName;
                if (mappingAccessor.isBasic()) {
                    types = types + ", " + this.getUnqualifiedType(this.getBoxedType(annotatedElement), typeImports);
                    attributeType = AttributeType.SingularAttribute.name();
                } else {
                    if (rawClass.isList()) {
                        attributeType = AttributeType.ListAttribute.name();
                    } else if (rawClass.isSet()) {
                        attributeType = AttributeType.SetAttribute.name();
                    } else if (rawClass.isMap()) {
                        attributeType = AttributeType.MapAttribute.name();
                    } else if (rawClass.isCollection()) {
                        attributeType = AttributeType.CollectionAttribute.name();
                    }
                    if (mappingAccessor.isMapAccessor()) {
                        if (mappingAccessor.isMappedKeyMapAccessor()) {
                            MetadataClass mapKeyClass = ((MappedKeyMapAccessor)((Object)mappingAccessor)).getMapKeyClass();
                            types = types + ", " + this.getUnqualifiedType(mapKeyClass.getName(), typeImports) + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), typeImports);
                        } else {
                            String mapKeyType = annotatedElement.isGenericCollectionType() ? annotatedElement.getGenericType().get(1) : (mappingAccessor.getReferenceDescriptor().hasIdAccessor() ? mappingAccessor.getReferenceDescriptor().getIdAccessors().get(0).getAnnotatedElement().getType() : "? extends Object");
                            types = types + ", " + this.getUnqualifiedType(mapKeyType, typeImports) + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), typeImports);
                        }
                    } else {
                        types = types + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), typeImports);
                    }
                }
                attributeTypes.add(attributeType);
                attributes.add("\tpublic static volatile " + attributeType + "<" + types + "> " + annotatedElement.getAttributeName() + ";\n");
            }
            String parent = this.writeImportStatements(attributeTypes, typeImports, accessor, writer);
            writer.append("@Generated(\"EclipseLink JPA 2.0 Canonical Model Generation\")\n");
            writer.append("@StaticMetamodel(" + originalClassName + ".class)\n");
            int modifier = accessor.getAccessibleObject().getModifiers();
            writer.append(Modifier.toString(modifier) + " class " + underScoreClassName);
            if (parent == null) {
                writer.append(" { \n\n");
            } else {
                writer.append(" extends " + parent + " {\n\n");
            }
            for (String str : attributes) {
                writer.append(str);
            }
            writer.append("\n}");
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
                writer = null;
            }
        }
    }

    protected String getBoxedType(MetadataAnnotatedElement annotatedElement) {
        PrimitiveType primitiveType = annotatedElement.getPrimitiveType();
        if (primitiveType != null) {
            return this.processingEnv.getTypeUtils().boxedClass(primitiveType).toString();
        }
        return annotatedElement.getType();
    }

    protected void generateCanonicalModelClasses(RoundEnvironment roundEnv, PersistenceUnit persistenceUnit) throws IOException {
        for (Element element : roundEnv.getRootElements()) {
            if (!persistenceUnit.containsElement(element)) continue;
            this.generateCanonicalModelClass(element, persistenceUnit.getClassAccessor(element));
        }
    }

    protected String getCanonicalType(MappingAccessor mappingAccessor) {
        MetadataClass rawClass = mappingAccessor.getAnnotatedElement().getRawClass(mappingAccessor.getDescriptor());
        if (mappingAccessor.isBasic()) {
            return AttributeType.SingularAttribute.name();
        }
        if (rawClass.isList() && mappingAccessor.isBasic()) {
            return AttributeType.ListAttribute.name();
        }
        if (rawClass.isSet()) {
            return AttributeType.SetAttribute.name();
        }
        if (rawClass.isMap()) {
            return AttributeType.MapAttribute.name();
        }
        if (rawClass.isCollection()) {
            return AttributeType.CollectionAttribute.name();
        }
        return AttributeType.SingularAttribute.name();
    }

    protected String getUnqualifiedType(String type, HashSet<String> imports) {
        if (type.contains("void")) {
            return TypeVisitor.GENERIC_TYPE;
        }
        if (type.startsWith("java.lang")) {
            return type.substring(type.lastIndexOf(".") + 1).trim();
        }
        if (type.indexOf("<") > -1) {
            String raw = type.substring(0, type.indexOf("<"));
            String generic = type.substring(type.indexOf("<") + 1, type.length() - 1);
            if (raw.contains("Map")) {
                String key = generic.substring(0, generic.indexOf(","));
                String value = generic.substring(generic.indexOf(",") + 1);
                return this.getUnqualifiedType(raw, imports) + "<" + this.getUnqualifiedType(key, imports) + ", " + this.getUnqualifiedType(value, imports) + ">";
            }
            return this.getUnqualifiedType(raw, imports) + "<" + this.getUnqualifiedType(generic, imports) + ">";
        }
        if (type.indexOf(".") > -1) {
            if (type.indexOf("[") > 1) {
                imports.add(type.substring(0, type.indexOf("[")).trim());
            } else {
                imports.add(type.trim());
            }
            return type.substring(type.lastIndexOf(".") + 1).trim();
        }
        return type.trim();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            try {
                if (m_factory == null) {
                    MetadataLogger logger = new MetadataLogger((AbstractSession)new ServerSession(new Project(new DatabaseLogin())));
                    m_factory = new MetadataMirrorFactory(logger, Thread.currentThread().getContextClassLoader());
                }
                m_factory.setEnvironments(this.processingEnv, roundEnv);
                PersistenceUnitReader puReader = new PersistenceUnitReader(m_factory, this.processingEnv.getOptions().get("persistence.xml.path"));
                for (PersistenceUnit persistenceUnit : puReader.getPersistenceUnits()) {
                    for (Element element : roundEnv.getElementsAnnotatedWith(Entity.class)) {
                        persistenceUnit.addEntityAccessor(element);
                    }
                    for (Element element : roundEnv.getElementsAnnotatedWith(Embeddable.class)) {
                        persistenceUnit.addEmbeddableAccessor(element);
                    }
                    for (Element element : roundEnv.getElementsAnnotatedWith(MappedSuperclass.class)) {
                        persistenceUnit.addMappedSuperclassAccessor(element);
                    }
                    persistenceUnit.preProcessForCanonicalModel();
                    this.generateCanonicalModelClasses(roundEnv, persistenceUnit);
                }
            }
            catch (Exception e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.toString());
                for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, stackTraceElement.toString());
                }
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    protected String writeImportStatements(HashSet<String> attributeTypes, HashSet<String> typeImports, ClassAccessor accessor, Writer writer) throws IOException {
        String unqualifiedCanonicalParent = null;
        for (String typeImport : typeImports) {
            writer.append("import " + typeImport + ";\n");
        }
        writer.append("import javax.annotation.Generated;\n");
        if (attributeTypes.contains("CollectionAttribute")) {
            writer.append("import javax.persistence.metamodel.CollectionAttribute;\n");
        }
        if (attributeTypes.contains("ListAttribute")) {
            writer.append("import javax.persistence.metamodel.ListAttribute;\n");
        }
        if (attributeTypes.contains("MapAttribute")) {
            writer.append("import javax.persistence.metamodel.MapAttribute;\n");
        }
        if (attributeTypes.contains("SetAttribute")) {
            writer.append("import javax.persistence.metamodel.SetAttribute;\n");
        }
        if (attributeTypes.contains("SingularAttribute")) {
            writer.append("import javax.persistence.metamodel.SingularAttribute;\n");
        }
        writer.append("import javax.persistence.metamodel.StaticMetamodel;\n");
        MetadataClass cls = (MetadataClass)accessor.getAnnotatedElement();
        MetadataClass parentCls = cls.getSuperclass();
        MetadataProject project = accessor.getProject();
        if (project.hasEntity(parentCls) || project.hasEmbeddable(parentCls) || project.hasMappedSuperclass(parentCls)) {
            String child;
            String childPackage;
            String parent = parentCls.getName();
            String unqualifiedParent = parent.substring(parent.lastIndexOf(".") + 1);
            String parentPackage = parent.substring(0, parent.lastIndexOf("."));
            if (!parentPackage.equals(childPackage = (child = accessor.getJavaClassName()).substring(0, child.lastIndexOf(".")))) {
                writer.append("\nimport " + parent + "_;\n");
            }
            unqualifiedCanonicalParent = unqualifiedParent + "_";
        }
        writer.append("\n");
        return unqualifiedCanonicalParent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AttributeType {
        CollectionAttribute,
        ListAttribute,
        MapAttribute,
        SetAttribute,
        SingularAttribute;

    }
}

