/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-domains")
@Scoped(value=PerLookup.class)
public final class ListDomainsCommand
extends LocalDomainCommand {
    private static final String DOMAINDIR = "domaindir";
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListDomainsCommand.class);

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet opts = new LinkedHashSet();
        ListDomainsCommand.addOption(opts, (String)DOMAINDIR, (char)'\u0000', (String)"STRING", (boolean)false, null);
        ListDomainsCommand.addOption(opts, (String)"help", (char)'?', (String)"BOOLEAN", (boolean)false, (String)"false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 0;
        this.processProgramOptions();
    }

    protected void initDomain() {
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            DomainConfig domainConfig = new DomainConfig(null, this.getDomainsRoot());
            PEDomainsManager manager = new PEDomainsManager();
            String[] domainsList = manager.listDomains(domainConfig);
            this.programOpts.setInteractive(false);
            if (domainsList.length > 0) {
                for (int i = 0; i < domainsList.length; ++i) {
                    String dn = domainsList[i];
                    String status = this.getStatus(dn);
                    String name = strings.get("list.domains.Name");
                    logger.printMessage(name + " " + dn + " " + status);
                }
            } else {
                logger.printDetailMessage(strings.get("NoDomainsToList"));
            }
        }
        catch (Exception ex) {
            throw new CommandException(ex.getLocalizedMessage());
        }
        return 0;
    }

    protected String getDomainsRoot() throws CommandException {
        String domainDir = this.getOption(DOMAINDIR);
        if (domainDir == null) {
            domainDir = this.getSystemProperty("com.sun.aas.domainsRoot");
        }
        if (domainDir == null) {
            throw new CommandException(strings.get("InvalidDomainPath", new Object[]{domainDir}));
        }
        return domainDir;
    }

    private String getStatus(String dn) {
        try {
            GFLauncher launcher = GFLauncherFactory.getInstance((GFLauncherFactory.ServerType)GFLauncherFactory.ServerType.domain);
            GFLauncherInfo li = launcher.getInfo();
            String parent = this.getOption(DOMAINDIR);
            if (parent != null) {
                li.setDomainParentDir(parent);
            }
            li.setDomainName(dn);
            launcher.setup();
            this.initializeLocalPassword(li.getInstanceRootDir());
            Set adminPorts = li.getAdminPorts();
            this.programOpts.setPort(((Integer)adminPorts.iterator().next()).intValue());
            boolean status = this.isThisDAS(SmartFile.sanitize((File)li.getInstanceRootDir()));
            if (status) {
                return strings.get("list.domains.StatusRunning");
            }
            return strings.get("list.domains.StatusNotRunning");
        }
        catch (GFLauncherException gf) {
            logger.printExceptionStackTrace((Throwable)gf);
            return strings.get("list.domains.StatusUnknown");
        }
        catch (MiniXmlParserException me) {
            logger.printExceptionStackTrace((Throwable)me);
            return strings.get("list.domains.StatusUnknown");
        }
    }
}

