/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.optional.DomainXmlVerifier;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.glassfish.api.embedded.Server;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

@Service(name="verify-domain-xml")
@Scoped(value=PerLookup.class)
public final class VerifyDomainXmlCommand
extends LocalDomainCommand {
    private static final String DOMAINDIR = "domaindir";
    private static final LocalStringsImpl strings = new LocalStringsImpl(VerifyDomainXmlCommand.class);

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet opts = new LinkedHashSet();
        VerifyDomainXmlCommand.addOption(opts, (String)DOMAINDIR, (char)'\u0000', (String)"STRING", (boolean)false, null);
        VerifyDomainXmlCommand.addOption(opts, (String)"help", (char)'?', (String)"BOOLEAN", (boolean)false, (String)"false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "domain_name";
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 1;
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        File domainXMLFile = this.getDomainXml();
        logger.printDebugMessage("Domain XML file = " + domainXMLFile);
        try {
            Server server = new Server.Builder("dummylaunch").build();
            server.start();
            Habitat habitat = server.getHabitat();
            ConfigParser parser = new ConfigParser(habitat);
            URL domainURL = domainXMLFile.toURI().toURL();
            DomDocument doc = parser.parse(domainURL);
            Dom domDomain = doc.getRoot();
            Domain domain = (Domain)domDomain.createProxy(Domain.class);
            DomainXmlVerifier validator = new DomainXmlVerifier(domain);
            validator.invokeConfigValidator();
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage());
        }
        return 0;
    }
}

