/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.metadata;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.validation.metadata.BeanMetaDataImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetaDataCache {
    private Map<Class<?>, BeanMetaDataImpl<?>> metadataProviders = new ConcurrentHashMap(10);

    public <T> BeanMetaDataImpl<T> getBeanMetaData(Class<T> beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return this.metadataProviders.get(beanClass);
    }

    public <T> void addBeanMetaData(Class<T> beanClass, BeanMetaDataImpl<T> metaData) {
        this.metadataProviders.put(beanClass, metaData);
    }
}

