/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby.rack;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.jruby.RackGrizzlyAdapter;
import com.sun.grizzly.jruby.rack.GenericApplicationFactory;
import com.sun.grizzly.jruby.rack.MerbApplicationFactory;
import com.sun.grizzly.jruby.rack.MultiThreadedRackAdapter;
import com.sun.grizzly.jruby.rack.RackAdapter;
import com.sun.grizzly.jruby.rack.RailsApplicationFactory;
import com.sun.grizzly.jruby.rack.SinatraApplicationFactory;
import com.sun.grizzly.jruby.rack.SingleThreadedRackAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Logger;
import org.glassfish.scripting.jruby.common.config.JRubyConfig;

public class RackApplicationChooser {
    public static RackAdapter getFactory(String appPath, RackGrizzlyAdapter adapter) {
        Logger theLog = adapter.getLogger();
        JRubyConfig.Framework framework = adapter.config.framework();
        String appType = framework.type();
        RackAdapter rack = RackApplicationChooser.handleFramework(adapter, appPath, appType, theLog);
        if (rack != null) {
            return rack;
        }
        rack = RackApplicationChooser.handleStartupScript(framework.initScript().getAbsolutePath(), adapter, theLog);
        if (rack != null) {
            return rack;
        }
        SelectorThread.logger().severe("Framework autodetection failed! Please set jruby.applicationType deployment property to the path to a script that will start your framework");
        throw new IllegalStateException("No framework to start!");
    }

    private static String inhale(File f, Logger theLog) {
        String app = "";
        if (f.exists()) {
            try {
                String s;
                BufferedReader in = new BufferedReader(new FileReader(f));
                while ((s = in.readLine()) != null) {
                    app = app + s + "\n";
                }
            }
            catch (IOException e) {
                theLog.severe("IO Exception determining framework for " + f.getAbsolutePath() + ": " + e);
            }
        } else {
            theLog.severe("Was told to read nonexistant file " + f.getAbsolutePath());
        }
        return app;
    }

    private static RackAdapter handleFramework(RackGrizzlyAdapter adapter, String appPath, String appType, Logger theLog) {
        System.out.println("App type is " + appType);
        if (appType.equalsIgnoreCase("rails")) {
            RailsApplicationFactory myFactory = new RailsApplicationFactory(adapter);
            if (adapter.config.isMTSafe()) {
                theLog.info("User has specified rails in threadsafe mode, initializing multithreaded rails");
                return new MultiThreadedRackAdapter(myFactory, adapter);
            }
            boolean multithreaded = false;
            String environment = "";
            if ("development".compareTo(adapter.config.environment()) == 0) {
                environment = RackApplicationChooser.inhale(new File(appPath + "/config/environments/development.rb"), theLog);
            } else if ("production".compareTo(adapter.config.environment()) == 0) {
                environment = RackApplicationChooser.inhale(new File(appPath + "/config/environments/production.rb"), theLog);
            } else if ("testing".compareTo(adapter.config.environment()) == 0) {
                environment = RackApplicationChooser.inhale(new File(appPath + "/config/environments/testing.rb"), theLog);
            }
            if (environment.matches("(?s)(?m).*^[^#]*config\\.threadsafe!.*")) {
                multithreaded = true;
            }
            if (multithreaded) {
                theLog.info("config.threadsafe sighted! All hands prepare for multithread mode!");
                return new MultiThreadedRackAdapter(myFactory, adapter);
            }
            theLog.info("Rails not in thread-safe mode, starting in single-thread mode");
            return new SingleThreadedRackAdapter(myFactory, adapter);
        }
        if (appType.equalsIgnoreCase("merb")) {
            theLog.info("Initializing merb");
            MerbApplicationFactory myFactory = new MerbApplicationFactory(adapter);
            return new MultiThreadedRackAdapter(myFactory, adapter);
        }
        if (appType.equalsIgnoreCase("sinatra")) {
            theLog.info("Initializing Sinatra");
            File script = adapter.config.framework().initScript();
            if (script != null) {
                SinatraApplicationFactory myFactory = new SinatraApplicationFactory(adapter, script.getAbsolutePath());
                return new MultiThreadedRackAdapter(myFactory, adapter);
            }
        }
        return null;
    }

    private static RackAdapter handleStartupScript(String rackUp, RackGrizzlyAdapter adapter, Logger theLog) {
        GenericApplicationFactory myFactory = new GenericApplicationFactory(rackUp, adapter);
        if (adapter.config.isMTSafe()) {
            theLog.info("Running a user-provided rackup script in thread-safe mode");
            return new MultiThreadedRackAdapter(myFactory, adapter);
        }
        theLog.info("Running a user-provided rackup script in pooled mode");
        return new SingleThreadedRackAdapter(myFactory, adapter);
    }
}

