/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.universal.GFBase64Decoder;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CommandNotFoundException;
import com.sun.enterprise.v3.admin.ParamTokenizer;
import com.sun.enterprise.v3.admin.UnacceptableValueException;
import com.sun.enterprise.v3.common.XMLContentActionReporter;
import com.sun.hk2.component.InjectionResolver;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Async;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandBuilder;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.Payload;
import org.glassfish.config.support.CommandModelImpl;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.UnsatisfiedDepedencyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class CommandRunnerImpl
implements CommandRunner {
    public static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(CommandRunnerImpl.class);
    public Logger logger = Logger.getLogger(CommandRunnerImpl.class.getName());
    private static final String ASADMIN_CMD_PREFIX = "AS_ADMIN_";
    public final InjectionManager injectionMgr = new InjectionManager();
    @Inject
    Habitat habitat;
    @Inject
    ClassLoaderHierarchy clh;

    public void postConstruct() {
        this.logger = LogDomains.getLogger(CommandRunnerImpl.class, (String)"javax.enterprise.system.tools.admin");
    }

    public ActionReport getActionReport(String name) {
        return (ActionReport)this.habitat.getComponent(ActionReport.class, name);
    }

    public void doCommand(String commandName, Properties parameters, ActionReport report) {
        this.doCommand(commandName, parameters, report, null, null);
    }

    public void doCommand(String commandName, Properties parameters, ActionReport report, Payload.Inbound inboundPayload, Payload.Outbound outboundPayload) {
        AdminCommand handler = this.getCommand(commandName, report, this.logger);
        if (handler == null) {
            return;
        }
        CommandModelImpl model = new CommandModelImpl(handler.getClass());
        this.doCommand((CommandModel)model, handler, parameters, report, inboundPayload, outboundPayload);
    }

    public void doCommand(String commandName, AdminCommand command, Properties parameters, ActionReport report) {
        CommandModelImpl model = new CommandModelImpl(command.getClass());
        this.doCommand((CommandModel)model, command, parameters, report, null, null);
    }

    public InjectionResolver<Param> getDelegatedResolver(final CommandModel model, final Object parameters) {
        return new InjectionResolver<Param>(Param.class){

            public boolean isOptional(AnnotatedElement element, Param annotation) {
                String name = model.getParamName(annotation, element);
                CommandModel.ParamModel param = model.getModelFor(name);
                return param.getParam().optional();
            }

            public Object getValue(Object component, AnnotatedElement target, Class type) throws ComponentException {
                if (target instanceof Field) {
                    Field targetField = (Field)target;
                    try {
                        Field sourceField = parameters.getClass().getField(targetField.getName());
                        targetField.setAccessible(true);
                        Object paramValue = sourceField.get(parameters);
                        if (paramValue != null) {
                            CommandRunnerImpl.this.checkAgainstAcceptableValues(target, paramValue.toString());
                        }
                        return paramValue;
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (NoSuchFieldException e) {
                        // empty catch block
                    }
                }
                return null;
            }
        };
    }

    private InjectionResolver<Param> getPropsBasedResolver(final CommandModel model, final Properties parameters) {
        return new InjectionResolver<Param>(Param.class){

            public boolean isOptional(AnnotatedElement element, Param annotation) {
                String name = model.getParamName(annotation, element);
                CommandModel.ParamModel param = model.getModelFor(name);
                return param.getParam().optional();
            }

            public Object getValue(Object component, AnnotatedElement target, Class type) throws ComponentException {
                String value;
                Param param = target.getAnnotation(Param.class);
                String paramName = CommandRunnerImpl.this.getParamName(param, target);
                if (param.primary() && (value = parameters.getProperty("DEFAULT")) != null) {
                    parameters.setProperty(paramName, value);
                    return CommandRunnerImpl.this.convertStringToObject(target, type, value);
                }
                String paramValueStr = CommandRunnerImpl.this.getParamValueString(parameters, param, target);
                CommandRunnerImpl.this.checkAgainstAcceptableValues(target, paramValueStr);
                if (paramValueStr != null) {
                    return CommandRunnerImpl.this.convertStringToObject(target, type, paramValueStr);
                }
                return CommandRunnerImpl.this.getParamField(component, target);
            }
        };
    }

    public ActionReport doCommand(String commandName, Object parameters, ActionReport report, Payload.Inbound inboundPayload, Payload.Outbound outboundPayload) {
        AdminCommand command = this.getCommand(commandName, report, this.logger);
        if (command == null) {
            return report;
        }
        CommandModelImpl model = new CommandModelImpl(command.getClass());
        InjectionResolver<Param> injectionTarget = new InjectionResolver<Param>(Param.class, (CommandModel)model, parameters){
            final /* synthetic */ CommandModel val$model;
            final /* synthetic */ Object val$parameters;
            {
                this.val$model = commandModel;
                this.val$parameters = object;
                super(x0);
            }

            public boolean isOptional(AnnotatedElement element, Param annotation) {
                String name = this.val$model.getParamName(annotation, element);
                CommandModel.ParamModel param = this.val$model.getModelFor(name);
                return param.getParam().optional();
            }

            public Object getValue(Object component, AnnotatedElement target, Class type) throws ComponentException {
                Param param = target.getAnnotation(Param.class);
                String acceptable = param.acceptableValues();
                String paramName = CommandRunnerImpl.this.getParamName(param, target);
                if (target instanceof Field) {
                    Field targetField = (Field)target;
                    try {
                        Field sourceField = this.val$parameters.getClass().getField(targetField.getName());
                        targetField.setAccessible(true);
                        Object paramValue = sourceField.get(this.val$parameters);
                        if (paramValue != null) {
                            CommandRunnerImpl.this.checkAgainstAcceptableValues(target, paramValue.toString());
                        }
                        return paramValue;
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (NoSuchFieldException e) {
                        // empty catch block
                    }
                }
                return null;
            }
        };
        return this.doCommand((CommandModel)model, command, injectionTarget, report, inboundPayload, outboundPayload);
    }

    public ActionReport doCommand(CommandModel model, final AdminCommand command, InjectionResolver<Param> injector, ActionReport report, Payload.Inbound inboundPayload, Payload.Outbound outboundPayload) {
        report.setActionDescription(model.getCommandName() + " AdminCommand");
        final AdminCommandContext context = new AdminCommandContext(LogDomains.getLogger(ServerEnvironmentImpl.class, (String)"javax.enterprise.system.tools.admin"), report, inboundPayload, outboundPayload);
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(command.getClass());
        I18n i18n = model.getI18n();
        String i18n_key = "";
        if (i18n != null) {
            i18n_key = i18n.value();
        }
        try {
            this.injectionMgr.inject((Object)command, new InjectionResolver[]{injector});
        }
        catch (UnsatisfiedDepedencyException e) {
            String errorMsg;
            Param param = (Param)e.getAnnotation(Param.class);
            CommandModel.ParamModel paramModel = null;
            for (CommandModel.ParamModel pModel : model.getParameters()) {
                if (!pModel.getParam().equals(param)) continue;
                paramModel = pModel;
                break;
            }
            String usage = this.getUsageText(command, model);
            if (paramModel != null) {
                String paramName = paramModel.getName();
                String paramDesc = this.getParamDescription(localStrings, i18n_key, paramModel);
                errorMsg = param.primary() ? adminStrings.getLocalString("commandrunner.operand.required", "Operand required.") : (param.password() ? adminStrings.getLocalString("adapter.param.missing.passwordfile", "{0} command requires the passwordfile parameter containing {1} entry.", new Object[]{model.getCommandName(), paramName}) : (paramDesc != null ? adminStrings.getLocalString("admin.param.missing", "{0} command requires the {1} parameter ({2})", new Object[]{model.getCommandName(), paramName, paramDesc}) : adminStrings.getLocalString("admin.param.missing.nodesc", "{0} command requires the {1} parameter", new Object[]{model.getCommandName(), paramName})));
            } else {
                errorMsg = adminStrings.getLocalString("admin.param.missing.nofound", "Cannot find {1} in {0} command model, file a bug", new Object[]{model.getCommandName(), e.getUnsatisfiedName()});
            }
            this.logger.severe(errorMsg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(errorMsg);
            report.setFailureCause((Throwable)e);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(usage);
            return report;
        }
        catch (ComponentException e) {
            Throwable exception = e;
            Throwable cause = e.getCause();
            if (cause != null && (cause instanceof UnacceptableValueException || cause instanceof IllegalArgumentException)) {
                exception = (Exception)cause;
            }
            this.logger.log(Level.SEVERE, "invocation.exception", exception);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(exception.getMessage());
            report.setFailureCause(exception);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(this.getUsageText(command, model));
            return report;
        }
        final AdminCommand wrappedComamnd = new AdminCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(AdminCommandContext context) {
                ClassLoader ccl;
                Thread thread = Thread.currentThread();
                ClassLoader origCL = thread.getContextClassLoader();
                if (origCL != (ccl = CommandRunnerImpl.this.clh.getCommonClassLoader())) {
                    try {
                        thread.setContextClassLoader(ccl);
                        command.execute(context);
                    }
                    finally {
                        thread.setContextClassLoader(origCL);
                    }
                } else {
                    command.execute(context);
                }
            }
        };
        Async async = command.getClass().getAnnotation(Async.class);
        if (async == null) {
            try {
                wrappedComamnd.execute(context);
            }
            catch (Throwable e) {
                System.out.println("logger = " + this.logger);
                this.logger.log(Level.SEVERE, adminStrings.getLocalString("adapter.exception", "Exception in command execution : ", new Object[]{e}), e);
                report.setMessage(e.toString());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(e);
            }
        } else {
            Thread t = new Thread(){

                public void run() {
                    try {
                        wrappedComamnd.execute(context);
                    }
                    catch (RuntimeException e) {
                        CommandRunnerImpl.this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            };
            t.setPriority(async.priority());
            t.start();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(adminStrings.getLocalString("adapter.command.launch", "Command {0} was successfully initiated asynchronously.", new Object[]{model.getCommandName()}));
        }
        return context.getActionReport();
    }

    public ActionReport doCommand(CommandModel model, AdminCommand command, Properties parameters, ActionReport report, Payload.Inbound inboundPayload, Payload.Outbound outboundPayload) {
        if (parameters.get("help") != null || parameters.get("Xhelp") != null) {
            InputStream in = this.getManPage(model.getCommandName(), command);
            String manPage = this.encodeManPage(in);
            if (manPage != null && parameters.get("help") != null) {
                report.getTopMessagePart().addProperty("MANPAGE", manPage);
            } else {
                report.getTopMessagePart().addProperty("GeneratedHelp", "true");
                this.getHelp(command, report);
            }
            return report;
        }
        try {
            if (!this.skipValidation(command)) {
                this.validateParameters(model, parameters);
            }
        }
        catch (ComponentException e) {
            Throwable exception = e;
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof UnacceptableValueException) {
                exception = (Exception)cause;
            }
            this.logger.severe(exception.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(exception.getMessage());
            report.setFailureCause(exception);
            ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
            childPart.setMessage(this.getUsageText(command, model));
            return report;
        }
        InjectionResolver<Param> injectionMgr = this.getPropsBasedResolver(model, parameters);
        return this.doCommand(model, command, injectionMgr, report, inboundPayload, outboundPayload);
    }

    private void checkAgainstAcceptableValues(AnnotatedElement target, String paramValueStr) {
        Param param = target.getAnnotation(Param.class);
        String acceptable = param.acceptableValues();
        String paramName = this.getParamName(param, target);
        if (this.ok(acceptable) && this.ok(paramValueStr)) {
            String[] ss = acceptable.split(",");
            boolean ok = false;
            for (String s : ss) {
                if (!paramValueStr.equals(s.trim())) continue;
                ok = true;
                break;
            }
            if (!ok) {
                throw new UnacceptableValueException(adminStrings.getLocalString("adapter.command.unacceptableValue", "Invalid parameter: {0}.  Its value is {1} but it isn''t one of these acceptable values: {2}", new Object[]{paramName, paramValueStr, acceptable}));
            }
        }
    }

    protected String getParamDescription(LocalStringManagerImpl localStrings, String i18nKey, CommandModel.ParamModel model) {
        I18n i18n = model.getI18n();
        String paramDesc = i18n == null ? localStrings.getLocalString(i18nKey + "." + model.getName(), "") : localStrings.getLocalString(i18n.value(), "");
        if (paramDesc == null) {
            paramDesc = "";
        }
        return paramDesc;
    }

    String getParamName(Param param, AnnotatedElement annotated) {
        if (param.name().equals("")) {
            if (annotated instanceof Field) {
                return ((Field)annotated).getName();
            }
            if (annotated instanceof Method) {
                return ((Method)annotated).getName().substring(3).toLowerCase();
            }
        } else {
            if (param.password()) {
                return ASADMIN_CMD_PREFIX + param.name().toUpperCase();
            }
            return param.name();
        }
        return "";
    }

    String getParamValueString(Properties parameters, Param param, AnnotatedElement target) {
        String paramValueStr = this.getPropertiesValue(parameters, this.getParamName(param, target), true);
        if (paramValueStr == null) {
            paramValueStr = parameters.getProperty(param.shortName());
        }
        if (paramValueStr == null) {
            String defaultValue = param.defaultValue();
            paramValueStr = defaultValue.equals("") ? null : defaultValue;
        }
        return paramValueStr;
    }

    Object getParamField(Object component, AnnotatedElement annotated) {
        try {
            if (annotated instanceof Field) {
                Field field = (Field)annotated;
                field.setAccessible(true);
                return ((Field)annotated).get(component);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    Object convertStringToObject(AnnotatedElement target, Class type, String paramValStr) {
        Param param = target.getAnnotation(Param.class);
        String[] paramValue = paramValStr;
        if (type.isAssignableFrom(String.class)) {
            paramValue = paramValStr;
        } else if (type.isAssignableFrom(Properties.class)) {
            paramValue = this.convertStringToProperties(paramValStr, param.separator());
        } else if (type.isAssignableFrom(List.class)) {
            paramValue = this.convertStringToList(paramValStr, param.separator());
        } else if (type.isAssignableFrom(Boolean.class)) {
            String paramName = this.getParamName(param, target);
            paramValue = this.convertStringToBoolean(paramName, paramValStr);
        } else if (type.isAssignableFrom(String[].class)) {
            paramValue = this.convertStringToStringArray(paramValStr, param.separator());
        } else if (type.isAssignableFrom(File.class)) {
            return new File(paramValStr);
        }
        return paramValue;
    }

    String getPropertiesValue(Properties props, String key, boolean ignoreCase) {
        GFBase64Decoder base64Decoder = new GFBase64Decoder();
        if (ignoreCase) {
            for (Object propObj : props.keySet()) {
                String propName = (String)propObj;
                if (!propName.equalsIgnoreCase(key)) continue;
                try {
                    if (propName.startsWith(ASADMIN_CMD_PREFIX)) {
                        return new String(base64Decoder.decodeBuffer(props.getProperty(propName)));
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                return props.getProperty(propName);
            }
        }
        return props.getProperty(key);
    }

    public AdminCommand getCommand(String commandName, ActionReport report, Logger logger) {
        AdminCommand command = null;
        try {
            command = (AdminCommand)this.habitat.getComponent(AdminCommand.class, commandName);
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
        if (command == null) {
            String msg;
            if (!this.ok(commandName)) {
                msg = adminStrings.getLocalString("adapter.command.nocommand", "No command was specified.");
            } else {
                msg = adminStrings.getLocalString("adapter.command.notfound", "Command {0} not found", new Object[]{commandName});
                report.setFailureCause((Throwable)new CommandNotFoundException(msg));
            }
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            LogHelper.getDefaultLogger().info(msg);
        }
        return command;
    }

    String getUsageText(AdminCommand command, CommandModel model) {
        String usage;
        StringBuffer usageText = new StringBuffer();
        I18n i18n = model.getI18n();
        String i18nKey = null;
        LocalStringManagerImpl lsm = new LocalStringManagerImpl(command.getClass());
        if (i18n != null) {
            i18nKey = i18n.value();
        }
        if (i18nKey != null && this.ok(usage = lsm.getLocalString(i18nKey + ".usagetext", ""))) {
            usageText.append(adminStrings.getLocalString("adapter.usage", "Usage: "));
            usageText.append(usage);
            return usageText.toString();
        }
        return this.generateUsageText(model);
    }

    private String generateUsageText(CommandModel model) {
        StringBuffer usageText = new StringBuffer();
        usageText.append(adminStrings.getLocalString("adapter.usage", "Usage: "));
        usageText.append(model.getCommandName());
        usageText.append(" ");
        StringBuffer operand = new StringBuffer();
        for (CommandModel.ParamModel pModel : model.getParameters()) {
            Param param = pModel.getParam();
            String paramName = pModel.getName();
            if (param.password()) continue;
            boolean optional = param.optional();
            Class ftype = pModel.getType();
            String fvalue = null;
            String fvalueString = null;
            try {
                fvalue = param.defaultValue();
                if (fvalue != null) {
                    fvalueString = fvalue.toString();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (param.primary()) {
                if (optional) {
                    operand.append("[").append(paramName).append("] ");
                    continue;
                }
                operand.append(paramName).append(" ");
                continue;
            }
            if (optional) {
                usageText.append("[");
            }
            usageText.append("--").append(paramName);
            if (this.ok(param.defaultValue())) {
                usageText.append("=").append(param.defaultValue());
                if (optional) {
                    usageText.append("] ");
                    continue;
                }
                usageText.append(" ");
                continue;
            }
            if (ftype.isAssignableFrom(String.class)) {
                if (this.ok(fvalueString)) {
                    usageText.append("=").append(fvalueString);
                    if (optional) {
                        usageText.append("] ");
                        continue;
                    }
                    usageText.append(" ");
                    continue;
                }
                usageText.append("=").append(paramName);
                if (optional) {
                    usageText.append("] ");
                    continue;
                }
                usageText.append(" ");
                continue;
            }
            if (ftype.isAssignableFrom(Boolean.class)) {
                usageText.append("=").append("true|false");
                if (optional) {
                    usageText.append("] ");
                    continue;
                }
                usageText.append(" ");
                continue;
            }
            usageText.append("=").append(paramName);
            if (optional) {
                usageText.append("] ");
                continue;
            }
            usageText.append(" ");
        }
        usageText.append(operand);
        return usageText.toString();
    }

    public void getHelp(AdminCommand command, ActionReport report) {
        CommandModel model = this.getModel(command);
        report.setActionDescription(model.getCommandName() + " help");
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(command.getClass());
        I18n i18n = command.getClass().getAnnotation(I18n.class);
        String i18nKey = "";
        if (i18n != null) {
            i18nKey = i18n.value();
        }
        if (report instanceof XMLContentActionReporter) {
            this.getMetadata(command, model, report);
        } else {
            report.setMessage(model.getCommandName() + " - " + localStrings.getLocalString(i18nKey, ""));
            report.getTopMessagePart().addProperty("SYNOPSIS", this.getUsageText(command, model));
            for (CommandModel.ParamModel param : model.getParameters()) {
                this.addParamUsage(report, localStrings, i18nKey, param);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    private void getMetadata(AdminCommand command, CommandModel model, ActionReport report) {
        String usage;
        LocalStringManagerImpl localStrings = new LocalStringManagerImpl(command.getClass());
        I18n i18n = model.getI18n();
        String i18n_key = "";
        if (i18n != null) {
            i18n_key = i18n.value();
        }
        ActionReport.MessagePart top = report.getTopMessagePart();
        ActionReport.MessagePart cmd = top.addChild();
        cmd.setChildrenType("command");
        cmd.addProperty("name", model.getCommandName());
        if (model.unknownOptionsAreOperands()) {
            cmd.addProperty("unknown-options-are-operands", "true");
        }
        if (this.ok(usage = localStrings.getLocalString(i18n_key + ".usagetext", ""))) {
            cmd.addProperty("usage", usage);
        }
        CommandModel.ParamModel primary = null;
        for (CommandModel.ParamModel p : model.getParameters()) {
            Param param = p.getParam();
            if (param.primary()) {
                primary = p;
                continue;
            }
            ActionReport.MessagePart ppart = cmd.addChild();
            ppart.setChildrenType("option");
            ppart.addProperty("name", p.getName());
            ppart.addProperty("type", CommandRunnerImpl.typeOf(p));
            ppart.addProperty("optional", Boolean.toString(param.optional()));
            String paramDesc = this.getParamDescription(localStrings, i18n_key, p);
            if (this.ok(paramDesc)) {
                ppart.addProperty("description", paramDesc);
            }
            if (this.ok(param.shortName())) {
                ppart.addProperty("short", param.shortName());
            }
            if (this.ok(param.defaultValue())) {
                ppart.addProperty("default", param.defaultValue());
            }
            if (!this.ok(param.acceptableValues())) continue;
            ppart.addProperty("acceptable-values", param.acceptableValues());
        }
        if (primary != null) {
            ActionReport.MessagePart primpart = cmd.addChild();
            primpart.setChildrenType("operand");
            primpart.addProperty("name", primary.getName());
            primpart.addProperty("type", CommandRunnerImpl.typeOf(primary));
            primpart.addProperty("min", primary.getParam().optional() ? "0" : "1");
            primpart.addProperty("max", "1");
            String desc = this.getParamDescription(localStrings, i18n_key, primary);
            if (this.ok(desc)) {
                primpart.addProperty("description", desc);
            }
        }
    }

    private static String typeOf(CommandModel.ParamModel p) {
        Class t = p.getType();
        if (t == Boolean.class) {
            return "BOOLEAN";
        }
        if (t == File.class) {
            return "FILE";
        }
        if (t == Properties.class) {
            return "PROPERTIES";
        }
        if (p.getParam().password()) {
            return "PASSWORD";
        }
        return "STRING";
    }

    public InputStream getManPage(String commandName, AdminCommand command) {
        Class<?> clazz = command.getClass();
        Package pkg = clazz.getPackage();
        String manPage = pkg.getName().replace('.', '/');
        manPage = manPage + "/" + commandName + ".1";
        ClassLoader loader = clazz.getClassLoader();
        InputStream in = loader.getResourceAsStream(manPage);
        return in;
    }

    private void addParamUsage(ActionReport report, LocalStringManagerImpl localStrings, String i18nKey, CommandModel.ParamModel model) {
        Param param = model.getParam();
        if (param != null) {
            String paramName = model.getName();
            if (param.primary()) {
                return;
            }
            if (param.primary()) {
                report.getTopMessagePart().addProperty(paramName + "_operand", this.getParamDescription(localStrings, i18nKey, model));
            } else {
                report.getTopMessagePart().addProperty(paramName, this.getParamDescription(localStrings, i18nKey, model));
            }
        }
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    void validateParameters(CommandModel model, Properties parameters) throws ComponentException {
        Enumeration<?> e = parameters.propertyNames();
        for (Object key : parameters.keySet()) {
            CommandModel.ParamModel pModel;
            if ("DEFAULT".equals(key) || ((String)key).startsWith(ASADMIN_CMD_PREFIX)) continue;
            boolean validOption = false;
            Iterator i$ = model.getParameters().iterator();
            while (i$.hasNext() && !(validOption = (pModel = (CommandModel.ParamModel)i$.next()).isParamId(key.toString()))) {
            }
            if (validOption) continue;
            throw new ComponentException(" Invalid option: " + key);
        }
    }

    Boolean convertStringToBoolean(String paramName, String s) {
        if (!this.ok(s)) {
            return true;
        }
        if (s.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return true;
        }
        if (s.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return false;
        }
        String msg = adminStrings.getLocalString("adapter.command.unacceptableBooleanValue", "Invalid parameter: {0}.  This boolean option must be set (case insensitive) to true or false.  Its value was set to {1}", new Object[]{paramName, s});
        throw new UnacceptableValueException(msg);
    }

    Properties convertStringToProperties(String propsString, char sep) {
        Properties properties = new Properties();
        if (propsString != null) {
            ParamTokenizer stoken = new ParamTokenizer(propsString, sep);
            while (stoken.hasMoreTokens()) {
                String token = stoken.nextTokenKeepEscapes();
                ParamTokenizer nameTok = new ParamTokenizer(token, '=');
                String name = null;
                String value = null;
                if (nameTok.hasMoreTokens()) {
                    name = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens()) {
                    value = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens() || name == null || value == null) {
                    throw new IllegalArgumentException(adminStrings.getLocalString("InvalidPropertySyntax", "Invalid property syntax.", new Object[]{propsString}));
                }
                properties.setProperty(name, value);
            }
        }
        return properties;
    }

    List<String> convertStringToList(String listString, char sep) {
        ArrayList<String> list = new ArrayList<String>();
        if (listString != null) {
            ParamTokenizer ptoken = new ParamTokenizer(listString, sep);
            while (ptoken.hasMoreTokens()) {
                String token = ptoken.nextToken();
                list.add(token);
            }
        }
        return list;
    }

    String[] convertStringToStringArray(String arrayString, char sep) {
        ParamTokenizer paramTok = new ParamTokenizer(arrayString, sep);
        ArrayList<String> strs = new ArrayList<String>();
        while (paramTok.hasMoreTokens()) {
            strs.add(paramTok.nextToken());
        }
        return strs.toArray(new String[strs.size()]);
    }

    boolean skipValidation(AdminCommand command) {
        try {
            Field f = command.getClass().getDeclaredField("skipParamValidation");
            f.setAccessible(true);
            if (f.getType().isAssignableFrom(Boolean.TYPE)) {
                return f.getBoolean(command);
            }
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        return false;
    }

    private String encodeManPage(InputStream in) {
        String eolToken = "%%%EOL%%%";
        try {
            String line;
            if (in == null) {
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("%%%EOL%%%");
            }
            return sb.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public CommandModel getModel(String commandName, Logger logger) {
        AdminCommand command = null;
        try {
            command = (AdminCommand)this.habitat.getComponent(AdminCommand.class, commandName);
        }
        catch (ComponentException e) {
            logger.log(Level.SEVERE, "Cannot instantiate " + commandName, e);
            return null;
        }
        return this.getModel(command);
    }

    private CommandModel getModel(AdminCommand command) {
        if (command instanceof CommandModelProvider) {
            return ((CommandModelProvider)command).getModel();
        }
        return new CommandModelImpl(command.getClass());
    }

    public void doCommand(CommandBuilder b, ActionReport report, Logger logger) {
        InjectionResolver<Param> resolver;
        AdminCommand command = this.getCommand(b.commandName, report, logger);
        if (command == null) {
            return;
        }
        CommandModel model = this.getModel(command);
        if (b.delegate == null) {
            Properties parameters = b.paramsAsProperties;
            if (parameters.get("help") != null || parameters.get("Xhelp") != null) {
                InputStream in = this.getManPage(model.getCommandName(), command);
                String manPage = this.encodeManPage(in);
                if (manPage != null && parameters.get("help") != null) {
                    report.getTopMessagePart().addProperty("MANPAGE", manPage);
                } else {
                    report.getTopMessagePart().addProperty("GeneratedHelp", "true");
                    this.getHelp(command, report);
                }
                return;
            }
            try {
                if (!this.skipValidation(command)) {
                    this.validateParameters(model, parameters);
                }
            }
            catch (ComponentException e) {
                Throwable exception = e;
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof UnacceptableValueException) {
                    exception = (Exception)cause;
                }
                logger.severe(exception.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(exception.getMessage());
                report.setFailureCause(exception);
                ActionReport.MessagePart childPart = report.getTopMessagePart().addChild();
                childPart.setMessage(this.getUsageText(command, model));
                return;
            }
            resolver = this.getPropsBasedResolver(model, b.paramsAsProperties);
        } else {
            resolver = this.getDelegatedResolver(model, b.delegate);
        }
        this.doCommand(model, command, resolver, report, b.inbound, b.outbound);
    }
}

