/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.common_impl.CompositeEnumeration;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class APIClassLoaderServiceImpl
implements PostConstruct {
    private ClassLoader APIClassLoader;
    @Inject
    ModulesRegistry mr;
    private static final String APIExporterModuleName = "GlassFish-Application-Common-Module";
    private static final String MAILCAP = "META-INF/mailcap";
    static final Logger logger = LogDomains.getLogger(APIClassLoaderServiceImpl.class, (String)"javax.enterprise.system.core.classloading");
    private Module APIModule;

    public void postConstruct() {
        try {
            this.createAPIClassLoader();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createAPIClassLoader() throws IOException {
        this.APIModule = (Module)this.mr.getModules(APIExporterModuleName).iterator().next();
        assert (this.APIModule != null);
        final ClassLoader apiModuleLoader = this.APIModule.getClassLoader();
        this.APIClassLoader = new ClassLoader(apiModuleLoader.getParent()){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return this.loadClass(name, false);
            }

            @Override
            protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    if (!name.startsWith("java.")) {
                        try {
                            c = apiModuleLoader.loadClass(name);
                        }
                        catch (ClassNotFoundException cnfe) {
                            // empty catch block
                        }
                    }
                    if (c == null) {
                        c = super.loadClass(name, resolve);
                    }
                }
                return c;
            }

            @Override
            public URL getResource(String name) {
                URL url = null;
                if (!name.startsWith("java/")) {
                    if (name.equals(APIClassLoaderServiceImpl.MAILCAP)) {
                        Module m;
                        Iterator i$ = APIClassLoaderServiceImpl.this.mr.getModules().iterator();
                        while (i$.hasNext() && (url = (m = (Module)i$.next()).getClassLoader().getResource(name)) == null) {
                        }
                    } else {
                        url = apiModuleLoader.getResource(name);
                    }
                }
                if (url == null) {
                    url = super.getResource(name);
                }
                return url;
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                ArrayList<Enumeration<URL>> enumerators = new ArrayList<Enumeration<URL>>();
                if (!name.startsWith("java/")) {
                    if (name.equals(APIClassLoaderServiceImpl.MAILCAP)) {
                        for (Module m : APIClassLoaderServiceImpl.this.mr.getModules()) {
                            enumerators.add(m.getClassLoader().getResources(name));
                        }
                    } else {
                        enumerators.add(apiModuleLoader.getResources(name));
                    }
                }
                enumerators.add(super.getResources(name));
                return new CompositeEnumeration(enumerators);
            }
        };
        logger.logp(Level.FINE, "APIClassLoaderService", "createAPIClassLoader", "APIClassLoader = {0}", new Object[]{this.APIClassLoader});
    }

    public ClassLoader getAPIClassLoader() {
        return this.APIClassLoader;
    }
}

