/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.v3.server.ServerLifecycleModule;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.Startup;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

@Service
public class LifecycleModuleService
implements Startup,
PreDestroy,
PostConstruct,
EventListener {
    @Inject
    ServerContext context;
    @Inject
    Applications apps;
    @Inject
    Events events;
    private ArrayList listeners = new ArrayList();

    public void postConstruct() {
        this.events.register((EventListener)this);
        try {
            this.onInitialization();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void preDestroy() {
        try {
            this.onTermination();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void event(EventListener.Event event) {
        try {
            if (event.is(EventTypes.SERVER_STARTUP)) {
                this.onStartup();
            } else if (event.is(EventTypes.SERVER_READY)) {
                this.onReady();
            } else if (event.is(EventTypes.PREPARE_SHUTDOWN)) {
                this.onShutdown();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void onInitialization() throws ServerLifecycleException {
        try {
            List applications = this.apps.getApplications();
            ArrayList<Application> lcms = new ArrayList<Application>();
            for (Application app : applications) {
                if (!Boolean.valueOf(app.getDeployProperties().getProperty("isLifecycle")).booleanValue()) continue;
                lcms.add(app);
            }
            HashSet<ServerLifecycleModule> listenerSet = new HashSet<ServerLifecycleModule>();
            for (Application next : lcms) {
                Properties props = next.getDeployProperties();
                String enabled = next.getEnabled();
                if (!this.isEnabled(next.getName(), enabled)) continue;
                String strOrder = (String)props.remove("load-order");
                int order = Integer.MAX_VALUE;
                if (strOrder != null) {
                    try {
                        order = Integer.parseInt(strOrder);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                }
                String className = (String)props.remove("class-name");
                ServerLifecycleModule slcm = new ServerLifecycleModule(this.context, next.getName(), className);
                slcm.setLoadOrder(order);
                String classpath = (String)props.remove("classpath");
                slcm.setClasspath(classpath);
                String isFailureFatal = (String)props.remove("is-failure-fatal");
                slcm.setIsFatal(Boolean.valueOf(isFailureFatal));
                props.remove("isLifecycle");
                props.remove("object-type");
                for (String propName : props.stringPropertyNames()) {
                    slcm.setProperty(propName, props.getProperty(propName));
                }
                LifecycleListener listener = slcm.loadServerLifecycle();
                listenerSet.add(slcm);
            }
            this.sortModules(listenerSet);
        }
        catch (Exception ce1) {
            ce1.printStackTrace();
        }
        this.initialize();
    }

    private boolean isEnabled(String name, String enabled) {
        return Boolean.valueOf(enabled) != false && Boolean.valueOf(ConfigBeansUtilities.getEnabled((String)"server", (String)name)) != false;
    }

    private void resetClassLoader(final ClassLoader c) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(c);
                return null;
            }
        });
    }

    private void sortModules(HashSet listenerSet) {
        for (ServerLifecycleModule next : listenerSet) {
            int i;
            int order = next.getLoadOrder();
            for (i = 0; i < this.listeners.size() && ((ServerLifecycleModule)this.listeners.get(i)).getLoadOrder() <= order; ++i) {
            }
            this.listeners.add(i, next);
        }
    }

    private void initialize() throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (ServerLifecycleModule next : this.listeners) {
            next.onInitialization();
        }
        this.resetClassLoader(cl);
    }

    private void onStartup() throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (ServerLifecycleModule next : this.listeners) {
            next.onStartup();
        }
        this.resetClassLoader(cl);
    }

    private void onReady() throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (ServerLifecycleModule next : this.listeners) {
            next.onReady();
        }
        this.resetClassLoader(cl);
    }

    private void onShutdown() throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (ServerLifecycleModule next : this.listeners) {
            next.onShutdown();
        }
        this.resetClassLoader(cl);
    }

    private void onTermination() throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (ServerLifecycleModule next : this.listeners) {
            next.onTermination();
        }
        this.resetClassLoader(cl);
    }
}

