/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.common.util.logging.LoggingOutputStream;
import com.sun.common.util.logging.LoggingXMLNames;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.logging.AgentFormatterDelegate;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.glassfish.api.admin.FileMonitoring;
import org.glassfish.internal.api.Init;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class LogManagerService
implements Init,
PostConstruct,
PreDestroy {
    @Inject
    Logger logger;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Habitat habitat;
    @Inject(optional=true)
    Agent agent = null;
    @Inject
    FileMonitoring fileMonitoring;
    @Inject(name="server-config")
    Config config;
    @Inject
    LoggingConfigImpl loggingConfig;
    final Map<String, Handler> gfHandlers = new HashMap<String, Handler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct() {
        Collection handlers;
        Object src;
        if (System.getProperty("java.util.logging.config.file") != null) {
            return;
        }
        final LogManager logMgr = LogManager.getLogManager();
        File logging = new File(this.env.getConfigDirPath(), "logging.properties");
        System.setProperty("java.util.logging.config.file", logging.getAbsolutePath());
        try {
            if (!logging.exists()) {
                Logger.getAnonymousLogger().log(Level.WARNING, logging.getAbsolutePath() + " not found, creating new file from template.");
                String rootFolder = (String)this.env.getProps().get("com.sun.aas.installRoot");
                String templateDir = rootFolder + File.separator + "lib" + File.separator + "templates";
                src = new File(templateDir, "logging.properties");
                File dest = new File(this.env.getConfigDirPath(), "logging.properties");
                FileUtils.copy((File)src, (File)dest);
                logging = new File(this.env.getConfigDirPath(), "logging.properties");
            }
            logMgr.readConfiguration();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Cannot read logging configuration file : ", e);
        }
        AgentFormatterDelegate agentDelegate = null;
        if (this.agent != null) {
            agentDelegate = new AgentFormatterDelegate(this.agent);
        }
        if ((handlers = this.habitat.getAllByContract(Handler.class)) != null && handlers.size() > 0) {
            src = logMgr;
            synchronized (src) {
                Enumeration<String> loggerNames = logMgr.getLoggerNames();
                while (loggerNames.hasMoreElements()) {
                    String loggerName = loggerNames.nextElement();
                    logMgr.getLogger(loggerName);
                    for (Handler handler : this.logger.getHandlers()) {
                        if (!(handler.getFormatter() instanceof UniformLogFormatter)) continue;
                        ((UniformLogFormatter)handler.getFormatter()).setDelegate(agentDelegate);
                    }
                }
                for (Handler handler : handlers) {
                    this.addHandler(handler);
                }
            }
        }
        try {
            Map map = this.loggingConfig.getLoggingProperties();
            String filterClassName = (String)map.get(LoggingXMLNames.xmltoPropsMap.get("log-filter"));
            if (filterClassName != null) {
                Filter filterClass = (Filter)this.habitat.getComponent(Filter.class, filterClassName);
                Logger rootLogger = Logger.global.getParent();
                if (rootLogger != null) {
                    rootLogger.setFilter(filterClass);
                }
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        LoggingOutputStream los = new LoggingOutputStream(Logger.getAnonymousLogger(), Level.INFO);
        PrintStream pout = new PrintStream((OutputStream)los, true);
        System.setOut(pout);
        los = new LoggingOutputStream(Logger.getAnonymousLogger(), Level.SEVERE);
        PrintStream perr = new PrintStream((OutputStream)los, true);
        System.setErr(perr);
        if (logging != null) {
            this.fileMonitoring.monitors(logging, new FileMonitoring.FileChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void changed(File changedFile) {
                    Map<String, Handler> map = LogManagerService.this.gfHandlers;
                    synchronized (map) {
                        try {
                            Map props = LogManagerService.this.loggingConfig.getLoggingProperties();
                            if (props == null) {
                                return;
                            }
                            Set keys = props.keySet();
                            for (String a : keys) {
                                if (!a.endsWith(".level")) continue;
                                String n = a.substring(0, a.lastIndexOf(".level"));
                                Level l = Level.parse((String)props.get(a));
                                if (logMgr.getLogger(n) != null) {
                                    logMgr.getLogger(n).setLevel(l);
                                    continue;
                                }
                                if (LogManagerService.this.gfHandlers.containsKey(n)) {
                                    Handler h = LogManagerService.this.gfHandlers.get(n);
                                    h.setLevel(l);
                                    continue;
                                }
                                if (!n.equals("java.util.logging.ConsoleHandler")) continue;
                                Logger logger = Logger.global.getParent();
                                Handler[] h = logger.getHandlers();
                                for (int i = 0; i < h.length; ++i) {
                                    String name = h[i].toString();
                                    if (!name.contains("java.util.logging.ConsoleHandler")) continue;
                                    h[i].setLevel(l);
                                }
                            }
                            LogManagerService.this.logger.log(Level.INFO, "Updated log levels for loggers.");
                        }
                        catch (IOException e) {
                            LogManagerService.this.logger.log(Level.SEVERE, "Cannot read logging.properties file : ", e);
                        }
                    }
                }

                public void deleted(File deletedFile) {
                    LogManagerService.this.logger.log(Level.INFO, "logging.properties file removed, updating log levels disabled");
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(Handler handler) {
        Logger rootLogger = Logger.global.getParent();
        if (rootLogger != null) {
            Map<String, Handler> map = this.gfHandlers;
            synchronized (map) {
                rootLogger.addHandler(handler);
                String handlerName = handler.toString();
                this.gfHandlers.put(handlerName.substring(0, handlerName.indexOf("@")), handler);
            }
        }
    }

    public void preDestroy() {
        try {
            for (Inhabitant i : this.habitat.getInhabitants(Handler.class)) {
                i.release();
            }
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }
}

