/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.grizzly.http.FileCache;

public class MonitorableFileCache
extends FileCache {
    private final GrizzlyMonitoring grizzlyMonitoring;
    private final String fileCacheName;

    public MonitorableFileCache(GrizzlyMonitoring grizzlyMonitoring, String fileCacheName) {
        this.grizzlyMonitoring = grizzlyMonitoring;
        this.fileCacheName = fileCacheName;
    }

    protected void recalcCacheStatsIfMonitoring(FileCache.FileCacheEntry entry) {
        this.recalcCacheStats(entry);
    }

    protected void countHit() {
        super.countHit();
        this.grizzlyMonitoring.getFileCacheProbeProvider().countHitEvent(this.fileCacheName);
    }

    protected void countMiss() {
        super.countMiss();
        this.grizzlyMonitoring.getFileCacheProbeProvider().countMissEvent(this.fileCacheName);
    }

    protected void countInfoHit() {
        super.countInfoHit();
        this.grizzlyMonitoring.getFileCacheProbeProvider().countInfoHitEvent(this.fileCacheName);
    }

    protected void countInfoMiss() {
        super.countInfoMiss();
        this.grizzlyMonitoring.getFileCacheProbeProvider().countInfoMissEvent(this.fileCacheName);
    }

    protected void countContentHit() {
        super.countContentHit();
        this.grizzlyMonitoring.getFileCacheProbeProvider().countContentHitEvent(this.fileCacheName);
    }

    protected void countContentMiss() {
        super.countContentMiss();
        this.grizzlyMonitoring.getFileCacheProbeProvider().countContentMissEvent(this.fileCacheName);
    }

    protected void incOpenCacheEntries() {
        super.incOpenCacheEntries();
        this.grizzlyMonitoring.getFileCacheProbeProvider().incOpenCacheEntriesEvent(this.fileCacheName);
    }

    protected void decOpenCacheEntries() {
        super.decOpenCacheEntries();
        this.grizzlyMonitoring.getFileCacheProbeProvider().decOpenCacheEntriesEvent(this.fileCacheName);
    }

    protected void addHeapSize(long size) {
        super.addHeapSize(size);
        this.grizzlyMonitoring.getFileCacheProbeProvider().addHeapSizeEvent(this.fileCacheName, size);
    }

    protected void subHeapSize(long size) {
        super.subHeapSize(size);
        this.grizzlyMonitoring.getFileCacheProbeProvider().subHeapSizeEvent(this.fileCacheName, size);
    }

    protected void addMappedMemorySize(long size) {
        super.addMappedMemorySize(size);
        this.grizzlyMonitoring.getFileCacheProbeProvider().addMappedMemorySizeEvent(this.fileCacheName, size);
    }

    protected void subMappedMemorySize(long size) {
        super.subMappedMemorySize(size);
        this.grizzlyMonitoring.getFileCacheProbeProvider().subMappedMemorySizeEvent(this.fileCacheName, size);
    }
}

