/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.Context;
import com.sun.grizzly.portunif.DefaultFilterChainProtocolHandler;
import com.sun.grizzly.portunif.PUProtocolRequest;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;

public class WebProtocolHandler
extends DefaultFilterChainProtocolHandler {
    protected String[][] protocols = new String[][]{{"http"}, {"https"}, {"https", "http"}, {"sip"}, {"sip", "sip_tls"}};
    private Mode mode;

    public WebProtocolHandler() {
        this(Mode.HTTP);
    }

    public WebProtocolHandler(Mode mode) {
        this.mode = mode;
    }

    public boolean handle(Context context, PUProtocolRequest protocolRequest) throws IOException {
        protocolRequest.setMapSelectionKey(true);
        protocolRequest.setExecuteFilterChain(true);
        return true;
    }

    public String[] getProtocols() {
        return this.protocols[this.mode.ordinal()];
    }

    public boolean expireKey(SelectionKey key) {
        return true;
    }

    public ByteBuffer getByteBuffer() {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        if (workerThread.getSSLEngine() != null) {
            return workerThread.getInputBB();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        HTTP,
        HTTPS,
        HTTP_HTTPS,
        SIP,
        SIP_TLS;

    }
}

