/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.Credentials;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Commands {
    private static final Logger logger = LogService.getLogger();
    private static final StringManager stringManager = StringManager.getManager(Commands.class);

    public static int startDomain(String domainName, CommonInfoModel cInfo) {
        Credentials c = cInfo.getSource().getDomainCredentials();
        String installRoot = System.getProperty("com.sun.aas.domainRoot");
        File installRootF = new File(installRoot);
        File asadminF = new File(installRootF.getParentFile(), "bin/asadmin");
        String asadminScript = asadminF.getAbsolutePath();
        try {
            asadminScript = asadminF.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        String ext = "";
        String osName = System.getProperty("os.name");
        CommandBuilder cb = new CommandBuilder();
        if (osName.indexOf("Windows") != -1) {
            asadminScript = "cmd /c " + asadminScript;
            ext = ".bat";
        }
        cb.add(asadminScript + ext);
        cb.add("start-domain");
        String masterPassword = c.getMasterPassword();
        if (masterPassword != null && masterPassword.length() > 0) {
            cb.add("--passwordfile ");
            cb.add(c.getPasswordFile());
        }
        cb.add("--upgrade");
        cb.add("--domaindir");
        cb.add(cInfo.getTarget().getInstallDir());
        cb.add(domainName);
        return Commands.executeCommand(cb.getCommand());
    }

    private static int executeCommand(String commandString) {
        int exitValue;
        block2: {
            long JOIN_TIMEOUT = 4000L;
            exitValue = 0;
            logger.info(stringManager.getString("commands.executingCommandMsg") + commandString);
            try {
                Process proc = Runtime.getRuntime().exec(commandString);
                StreamWatcher errWatcher = new StreamWatcher(proc.getErrorStream(), "ERR");
                StreamWatcher outWatcher = new StreamWatcher(proc.getInputStream(), "OUT");
                errWatcher.start();
                outWatcher.start();
                exitValue = proc.waitFor();
                logger.fine("Return value from process: " + exitValue);
                errWatcher.join(4000L);
                outWatcher.join(4000L);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, stringManager.getString("upgrade.common.general_exception"), e);
                if (exitValue != 0) break block2;
                exitValue = 1;
            }
        }
        return exitValue;
    }

    public static void killAsadminProcess() {
    }

    private static class StreamWatcher
    extends Thread {
        private final BufferedReader reader;

        public StreamWatcher(InputStream stream, String name) {
            super(name);
            this.reader = new BufferedReader(new InputStreamReader(stream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String line = this.reader.readLine();
                while (line != null) {
                    logger.finer(this.getName() + ": " + line);
                    line = this.reader.readLine();
                    Thread.sleep(2L);
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "todo: Exception reading stream from process", t);
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (IOException ioe) {
                    logger.log(Level.FINE, "Exception closing reader in StreamWatcher", ioe);
                }
            }
        }
    }

    private static class CommandBuilder {
        private static final String SPACE = " ";
        private final StringBuilder sb = new StringBuilder();

        private CommandBuilder() {
        }

        void add(String s) {
            this.sb.append(s);
            this.sb.append(SPACE);
        }

        String getCommand() {
            return this.sb.toString().trim();
        }
    }
}

